/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleAbortsEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.experimental.events.LaneEnterEvent;
import org.matsim.core.api.experimental.events.LaneLeaveEvent;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.mobsim.framework.MobsimDriverAgent;
import org.matsim.core.mobsim.qsim.interfaces.MobsimVehicle;
import org.matsim.core.mobsim.qsim.interfaces.SignalGroupState;
import org.matsim.core.mobsim.qsim.interfaces.SignalizeableItem;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgent;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQNode;
import org.matsim.core.mobsim.qsim.qnetsimengine.DefaultSignalizeableItem;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QItem;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLaneI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkImpl;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicleq.FIFOVehicleQ;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicleq.PassingVehicleQ;
import org.matsim.core.mobsim.qsim.qnetsimengine.vehicleq.VehicleQ;
import org.matsim.core.utils.misc.Time;
import org.matsim.lanes.Lane;
import org.matsim.vehicles.Vehicle;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.VisVehicle;

final class QueueWithBuffer
implements QLaneI,
SignalizeableItem {
    private static final Logger log = Logger.getLogger(QueueWithBuffer.class);
    private final FlowcapAccumulate flowcap_accumulate = new FlowcapAccumulate();
    private boolean thisTimeStepGreen = true;
    private double inverseFlowCapacityPerTimeStep;
    private double flowCapacityPerTimeStep;
    private double remainingHolesStorageCapacity = 0.0;
    private final Queue<Hole> holes = new LinkedList<Hole>();
    private double bufferLastMovedTime = Time.getUndefinedTime();
    private final VehicleQ<QVehicle> vehQueue;
    private double storageCapacity;
    private double usedStorageCapacity;
    private final Queue<QVehicle> buffer = new LinkedList<QVehicle>();
    private DefaultSignalizeableItem qSignalizedItem = null;
    private final AbstractQLink.QLinkInternalInterface qLink;
    private final Id<Lane> id;
    private static int spaceCapWarningCount = 0;
    static final double HOLE_SPEED_KM_H = 15.0;
    private final double length;
    private double unscaledFlowCapacity_s = Double.NaN;
    private double effectiveNumberOfLanes = Double.NaN;
    private final QLaneI.VisData visData = new VisDataImpl();
    private final NetsimEngineContext context;
    private double maxFlowFromFdiag = Double.POSITIVE_INFINITY;
    private double accumulatedInflowCap = 1.0;
    private static int wrnCnt = 0;
    private int noOfSeepModeBringFwd = 0;

    private QueueWithBuffer(AbstractQLink.QLinkInternalInterface qlink, VehicleQ<QVehicle> vehicleQueue, Id<Lane> laneId, double length, double effectiveNumberOfLanes, double flowCapacity_s, NetsimEngineContext context) {
        this.qLink = qlink;
        this.id = laneId;
        this.context = context;
        this.vehQueue = vehicleQueue;
        this.length = length;
        this.unscaledFlowCapacity_s = flowCapacity_s;
        this.effectiveNumberOfLanes = effectiveNumberOfLanes;
        this.calculateFlowCapacity();
        this.calculateStorageCapacity();
        this.flowcap_accumulate.setValue(this.flowCapacityPerTimeStep);
        if (context.qsimConfig.getTimeStepSize() < 1.0) {
            throw new RuntimeException("yyyy This will produce weird results because in at least one place (addFromUpstream(...)) everything is pulled to integer values.  Aborting ... (This statement may no longer be correct; I think that the incriminating code was modified.  So please test and remove the warning if it works. kai, sep'14");
        }
    }

    @Override
    public final void addFromWait(QVehicle veh) {
        if (this.flowcap_accumulate.getValue() <= 0.0 && veh.getVehicle().getType().getPcuEquivalents() > this.context.qsimConfig.getPcuThresholdForFlowCapacityEasing()) {
            throw new IllegalStateException("Buffer of link " + this.id + " has no space left!");
        }
        this.addToBuffer(veh);
    }

    private void addToBuffer(QVehicle veh) {
        QNodeI toNode;
        double now = this.context.getSimTimer().getTimeOfDay();
        this.flowcap_accumulate.addValue(-veh.getFlowCapacityConsumptionInEquivalents(), now);
        this.buffer.add(veh);
        if (this.buffer.size() == 1) {
            this.bufferLastMovedTime = now;
        }
        if ((toNode = this.qLink.getToNodeQ()) instanceof AbstractQNode) {
            ((AbstractQNode)toNode).activateNode();
        }
    }

    @Override
    public final boolean isAcceptingFromWait(QVehicle veh) {
        return this.hasFlowCapacityLeft(veh);
    }

    private boolean hasFlowCapacityLeft(VisVehicle veh) {
        if (this.context.qsimConfig.isUsingFastCapacityUpdate()) {
            this.updateFastFlowAccumulation();
        }
        return this.flowcap_accumulate.getValue() > 0.0 || veh.getVehicle().getType().getPcuEquivalents() <= this.context.qsimConfig.getPcuThresholdForFlowCapacityEasing();
    }

    private void updateFastFlowAccumulation() {
        double now = this.context.getSimTimer().getTimeOfDay();
        if (this.flowcap_accumulate.getTimeStep() < now && this.flowcap_accumulate.getValue() < this.flowCapacityPerTimeStep && this.isNotOfferingVehicle()) {
            double timeSteps = (now - this.flowcap_accumulate.getTimeStep()) / this.context.qsimConfig.getTimeStepSize();
            double accumulateFlowCap = timeSteps * this.flowCapacityPerTimeStep;
            double newFlowCap = Math.min(this.flowcap_accumulate.getValue() + accumulateFlowCap, this.flowCapacityPerTimeStep);
            this.flowcap_accumulate.setValue(newFlowCap);
            this.flowcap_accumulate.setTimeStep(now);
        }
    }

    private void updateSlowFlowAccumulation() {
        if (this.thisTimeStepGreen && this.flowcap_accumulate.getValue() < this.flowCapacityPerTimeStep && this.isNotOfferingVehicle()) {
            double newFlowCap = Math.min(this.flowcap_accumulate.getValue() + this.flowCapacityPerTimeStep, this.flowCapacityPerTimeStep);
            this.flowcap_accumulate.setValue(newFlowCap);
        }
    }

    @Override
    public final void initBeforeSimStep() {
        if (!this.context.qsimConfig.isUsingFastCapacityUpdate()) {
            this.updateSlowFlowAccumulation();
        }
    }

    private void calculateFlowCapacity() {
        double now = this.context.getSimTimer().getTimeOfDay();
        this.flowCapacityPerTimeStep = this.unscaledFlowCapacity_s;
        this.flowCapacityPerTimeStep = this.flowCapacityPerTimeStep * this.context.qsimConfig.getTimeStepSize() * this.context.qsimConfig.getFlowCapFactor();
        this.inverseFlowCapacityPerTimeStep = 1.0 / this.flowCapacityPerTimeStep;
        switch (this.context.qsimConfig.getTrafficDynamics()) {
            case queue: 
            case withHoles: {
                break;
            }
            case kinematicWaves: {
                this.maxFlowFromFdiag = 1.0 / this.context.effectiveCellSize / (0.24 + 1.0 / this.qLink.getFreespeed());
                if (!(this.maxFlowFromFdiag < this.flowCapacityPerTimeStep) || wrnCnt >= 10) break;
                log.warn("max flow from fdiag < requested flow cap; linkId=" + this.qLink.getId() + "; req flow cap/h=" + 3600.0 * this.flowCapacityPerTimeStep / this.context.qsimConfig.getTimeStepSize() + "; max flow from fdiag/h=" + 3600.0 * this.maxFlowFromFdiag / this.context.qsimConfig.getTimeStepSize());
                if (++wrnCnt != 10) break;
                log.warn(" Future occurences of this logging statement are suppressed.");
                break;
            }
            default: {
                throw new RuntimeException("The traffic dynamics " + (Object)((Object)this.context.qsimConfig.getTrafficDynamics()) + " is not implemented yet.");
            }
        }
    }

    private void calculateStorageCapacity() {
        this.storageCapacity = this.length * this.effectiveNumberOfLanes / this.context.effectiveCellSize * this.context.qsimConfig.getStorageCapFactor();
        this.storageCapacity = Math.max(this.storageCapacity, this.getBufferStorageCapacity());
        double freespeedTravelTime = this.length / this.qLink.getFreespeed();
        if (Double.isNaN(freespeedTravelTime)) {
            throw new IllegalStateException("Double.NaN is not a valid freespeed travel time for a link. Please check the attributes length and freespeed!");
        }
        double tempStorageCapacity = freespeedTravelTime * this.flowCapacityPerTimeStep;
        if (this.storageCapacity < tempStorageCapacity) {
            if (spaceCapWarningCount <= 10) {
                log.warn("Link " + this.id + " too small: enlarge storage capacity from: " + this.storageCapacity + " Vehicles to: " + tempStorageCapacity + " Vehicles.  This is not fatal, but modifies the traffic flow dynamics.");
                if (spaceCapWarningCount == 10) {
                    log.warn("Additional warnings of this type are suppressed.");
                }
                ++spaceCapWarningCount;
            }
            this.storageCapacity = tempStorageCapacity;
        }
        switch (this.context.qsimConfig.getTrafficDynamics()) {
            case queue: {
                break;
            }
            case withHoles: 
            case kinematicWaves: {
                double freeSpeed = this.qLink.getFreespeed();
                double holeSpeed = 4.166666666666667;
                double minStorCapForHoles = this.length * this.flowCapacityPerTimeStep * (freeSpeed + 4.166666666666667) / freeSpeed / 4.166666666666667;
                if (this.storageCapacity < minStorCapForHoles) {
                    if (spaceCapWarningCount <= 10) {
                        log.warn("storage capacity not sufficient for holes; increasing from " + this.storageCapacity + " to " + minStorCapForHoles);
                        ++spaceCapWarningCount;
                    }
                    this.storageCapacity = minStorCapForHoles;
                }
                this.remainingHolesStorageCapacity = this.storageCapacity;
                break;
            }
            default: {
                throw new RuntimeException("The traffic dynmics " + (Object)((Object)this.context.qsimConfig.getTrafficDynamics()) + " is not implemented yet.");
            }
        }
    }

    private double getBufferStorageCapacity() {
        return this.flowCapacityPerTimeStep;
    }

    @Override
    public final boolean doSimStep() {
        switch (this.context.qsimConfig.getTrafficDynamics()) {
            case queue: {
                break;
            }
            case withHoles: {
                this.processArrivalOfHoles();
                break;
            }
            case kinematicWaves: {
                this.accumulatedInflowCap = Math.min(this.accumulatedInflowCap + this.maxFlowFromFdiag, this.maxFlowFromFdiag);
                this.processArrivalOfHoles();
                break;
            }
            default: {
                throw new RuntimeException("The traffic dynmics " + (Object)((Object)this.context.qsimConfig.getTrafficDynamics()) + " is not implemented yet.");
            }
        }
        this.moveQueueToBuffer();
        return true;
    }

    private void processArrivalOfHoles() {
        double now = this.context.getSimTimer().getTimeOfDay();
        while (this.holes.size() > 0 && this.holes.peek().getEarliestLinkExitTime() < now) {
            Hole hole = this.holes.poll();
            this.remainingHolesStorageCapacity += hole.getSizeInEquivalents();
        }
    }

    private void moveQueueToBuffer() {
        QVehicle veh;
        double now = this.context.getSimTimer().getTimeOfDay();
        while ((veh = this.peekFromVehQueue()) != null) {
            if (veh.getEarliestLinkExitTime() > now) {
                return;
            }
            MobsimDriverAgent driver = veh.getDriver();
            if (driver instanceof TransitDriverAgent) {
                AbstractQLink.HandleTransitStopResult handleTransitStop = this.qLink.handleTransitStop(now, veh, (TransitDriverAgent)driver, this.qLink.getId());
                if (handleTransitStop == AbstractQLink.HandleTransitStopResult.accepted) {
                    this.removeVehicleFromQueue(veh);
                    continue;
                }
                if (handleTransitStop == AbstractQLink.HandleTransitStopResult.rehandle) continue;
            }
            if (driver.isWantingToArriveOnCurrentLink()) {
                if (this.qLink.letVehicleArrive(veh)) {
                    this.removeVehicleFromQueue(veh);
                    continue;
                }
                return;
            }
            if (!this.hasFlowCapacityLeft(veh)) {
                return;
            }
            this.addToBuffer(veh);
            this.removeVehicleFromQueue(veh);
            if (!this.context.qsimConfig.isRestrictingSeepage() || this.context.qsimConfig.getLinkDynamics() != QSimConfigGroup.LinkDynamics.SeepageQ || !this.context.qsimConfig.getSeepModes().contains(veh.getDriver().getMode())) continue;
            ++this.noOfSeepModeBringFwd;
        }
    }

    private void removeVehicleFromQueue(QVehicle veh2Remove) {
        double now = this.context.getSimTimer().getTimeOfDay();
        QVehicle veh = this.pollFromVehQueue(veh2Remove);
        if (this.context.qsimConfig.getLinkDynamics() != QSimConfigGroup.LinkDynamics.SeepageQ || !this.context.qsimConfig.isSeepModeStorageFree() || !this.context.qsimConfig.getSeepModes().contains(veh.getVehicle().getType().getId().toString())) {
            this.usedStorageCapacity -= veh.getSizeInEquivalents();
        }
        switch (this.context.qsimConfig.getTrafficDynamics()) {
            case queue: {
                break;
            }
            case withHoles: 
            case kinematicWaves: {
                Hole hole = new Hole();
                double ttimeOfHoles = this.length * 3600.0 / 15.0 / 1000.0;
                hole.setEarliestLinkExitTime(now + 1.0 * ttimeOfHoles + 0.0 * MatsimRandom.getRandom().nextDouble() * ttimeOfHoles);
                hole.setSizeInEquivalents(veh2Remove.getSizeInEquivalents());
                this.holes.add(hole);
                break;
            }
            default: {
                throw new RuntimeException("The traffic dynmics " + (Object)((Object)this.context.qsimConfig.getTrafficDynamics()) + " is not implemented yet.");
            }
        }
    }

    @Override
    public final boolean isActive() {
        if (this.context.qsimConfig.isUsingFastCapacityUpdate()) {
            return !this.vehQueue.isEmpty() || !this.isNotOfferingVehicle() && this.context.qsimConfig.isUseLanes() || !this.holes.isEmpty();
        }
        return this.flowcap_accumulate.getValue() < this.flowCapacityPerTimeStep || !this.vehQueue.isEmpty() || !this.isNotOfferingVehicle() && this.context.qsimConfig.isUseLanes() || !this.holes.isEmpty();
    }

    @Override
    public final void setSignalStateAllTurningMoves(SignalGroupState state) {
        this.qSignalizedItem.setSignalStateAllTurningMoves(state);
        this.thisTimeStepGreen = this.qSignalizedItem.hasGreenForAllToLinks();
    }

    @Override
    public final double getSimulatedFlowCapacityPerTimeStep() {
        return this.flowCapacityPerTimeStep;
    }

    @Override
    public final boolean isAcceptingFromUpstream() {
        boolean storageOk;
        boolean bl = storageOk = this.usedStorageCapacity < this.storageCapacity;
        if (this.context.qsimConfig.getTrafficDynamics() == QSimConfigGroup.TrafficDynamics.queue) {
            return storageOk;
        }
        if (this.context.qsimConfig.getTrafficDynamics() != QSimConfigGroup.TrafficDynamics.queue && this.remainingHolesStorageCapacity <= 0.0) {
            return false;
        }
        if (this.context.qsimConfig.getTrafficDynamics() != QSimConfigGroup.TrafficDynamics.kinematicWaves) {
            return true;
        }
        return this.accumulatedInflowCap > 0.0;
    }

    @Override
    public void recalcTimeVariantAttributes() {
        this.calculateFlowCapacity();
        this.calculateStorageCapacity();
        this.flowcap_accumulate.setValue(this.flowCapacityPerTimeStep);
    }

    @Override
    public final QVehicle getVehicle(Id<Vehicle> vehicleId) {
        for (QVehicle veh : this.vehQueue) {
            if (!veh.getId().equals(vehicleId)) continue;
            return veh;
        }
        for (QVehicle veh : this.buffer) {
            if (!veh.getId().equals(vehicleId)) continue;
            return veh;
        }
        return null;
    }

    @Override
    public final Collection<MobsimVehicle> getAllVehicles() {
        ArrayList<MobsimVehicle> vehicles = new ArrayList<MobsimVehicle>();
        vehicles.addAll(this.buffer);
        vehicles.addAll(this.vehQueue);
        return vehicles;
    }

    @Override
    public final QVehicle popFirstVehicle() {
        double now = this.context.getSimTimer().getTimeOfDay();
        QVehicle veh = this.removeFirstVehicle();
        if (this.context.qsimConfig.isUseLanes() && this.hasMoreThanOneLane()) {
            this.context.getEventsManager().processEvent(new LaneLeaveEvent(now, veh.getId(), this.qLink.getId(), this.getId()));
        }
        return veh;
    }

    private final QVehicle removeFirstVehicle() {
        double now = this.context.getSimTimer().getTimeOfDay();
        QVehicle veh = this.buffer.poll();
        this.bufferLastMovedTime = now;
        if (this.context.qsimConfig.isUsingFastCapacityUpdate()) {
            this.flowcap_accumulate.setTimeStep(now - 1.0);
        }
        return veh;
    }

    @Override
    public final void setSignalStateForTurningMove(SignalGroupState state, Id<Link> toLinkId) {
        if (!this.qLink.getToNode().getOutLinks().containsKey(toLinkId)) {
            throw new IllegalArgumentException("ToLink " + toLinkId + " is not reachable from QLink Id " + this.id);
        }
        this.qSignalizedItem.setSignalStateForTurningMove(state, toLinkId);
        this.thisTimeStepGreen = this.qSignalizedItem.hasGreenForAllToLinks();
    }

    @Override
    public final boolean hasGreenForToLink(Id<Link> toLinkId) {
        if (this.qSignalizedItem != null) {
            return this.qSignalizedItem.hasGreenForToLink(toLinkId);
        }
        return true;
    }

    @Override
    public boolean hasGreenForAllToLinks() {
        if (this.qSignalizedItem != null) {
            return this.qSignalizedItem.hasGreenForAllToLinks();
        }
        return true;
    }

    @Override
    public final double getStorageCapacity() {
        return this.storageCapacity;
    }

    @Override
    public final boolean isNotOfferingVehicle() {
        return this.buffer.isEmpty();
    }

    @Override
    public final void clearVehicles() {
        double now = this.context.getSimTimer().getTimeOfDay();
        for (QVehicle veh : this.vehQueue) {
            this.context.getEventsManager().processEvent(new VehicleAbortsEvent(now, veh.getId(), veh.getCurrentLink().getId()));
            this.context.getEventsManager().processEvent(new PersonStuckEvent(now, veh.getDriver().getId(), veh.getCurrentLink().getId(), veh.getDriver().getMode()));
            this.context.getAgentCounter().incLost();
            this.context.getAgentCounter().decLiving();
        }
        this.vehQueue.clear();
        for (QVehicle veh : this.buffer) {
            this.context.getEventsManager().processEvent(new VehicleAbortsEvent(now, veh.getId(), veh.getCurrentLink().getId()));
            this.context.getEventsManager().processEvent(new PersonStuckEvent(now, veh.getDriver().getId(), veh.getCurrentLink().getId(), veh.getDriver().getMode()));
            this.context.getAgentCounter().incLost();
            this.context.getAgentCounter().decLiving();
        }
        this.buffer.clear();
        this.holes.clear();
        this.remainingHolesStorageCapacity = this.storageCapacity;
    }

    @Override
    public final void addFromUpstream(QVehicle veh) {
        double now = this.context.getSimTimer().getTimeOfDay();
        if (this.context.qsimConfig.isUseLanes() && this.hasMoreThanOneLane()) {
            this.context.getEventsManager().processEvent(new LaneEnterEvent(now, veh.getId(), this.qLink.getId(), this.getId()));
        }
        this.qLink.activateLink();
        if (!this.context.qsimConfig.isSeepModeStorageFree() || !this.context.qsimConfig.getSeepModes().contains(veh.getVehicle().getType().getId().toString())) {
            this.usedStorageCapacity += veh.getSizeInEquivalents();
        }
        double linkTravelTime = this.length / this.qLink.getMaximumVelocityFromLinkSpeedCalculator(veh, now);
        linkTravelTime = this.context.qsimConfig.getTimeStepSize() * Math.floor(linkTravelTime / this.context.qsimConfig.getTimeStepSize());
        veh.setEarliestLinkExitTime(now + linkTravelTime);
        this.qLink.setCurrentLinkToVehicle(veh);
        this.vehQueue.add(veh);
        switch (this.context.qsimConfig.getTrafficDynamics()) {
            case queue: {
                break;
            }
            case withHoles: {
                this.remainingHolesStorageCapacity -= veh.getSizeInEquivalents();
                break;
            }
            case kinematicWaves: {
                this.remainingHolesStorageCapacity -= veh.getSizeInEquivalents();
                this.accumulatedInflowCap -= veh.getFlowCapacityConsumptionInEquivalents();
                break;
            }
            default: {
                throw new RuntimeException("The traffic dynamics " + (Object)((Object)this.context.qsimConfig.getTrafficDynamics()) + " is not implemented yet.");
            }
        }
    }

    private boolean hasMoreThanOneLane() {
        return this.qLink.getAcceptingQLane() != this.qLink.getOfferingQLanes().get(0);
    }

    @Override
    public final QLaneI.VisData getVisData() {
        return this.visData;
    }

    @Override
    public final QVehicle getFirstVehicle() {
        if (this.buffer.isEmpty()) {
            return (QVehicle)this.vehQueue.peek();
        }
        return this.buffer.peek();
    }

    @Override
    public final double getLastMovementTimeOfFirstVehicle() {
        return this.bufferLastMovedTime;
    }

    @Override
    public final void addTransitSlightlyUpstreamOfStop(QVehicle veh) {
        this.vehQueue.addFirst(veh);
    }

    @Override
    public final void setSignalized(boolean isSignalized) {
        this.qSignalizedItem = new DefaultSignalizeableItem(this.qLink.getToNode().getOutLinks().keySet());
    }

    @Override
    public final void changeUnscaledFlowCapacityPerSecond(double val) {
        this.unscaledFlowCapacity_s = val;
        this.recalcTimeVariantAttributes();
    }

    @Override
    public final void changeEffectiveNumberOfLanes(double val) {
        this.effectiveNumberOfLanes = val;
        this.recalcTimeVariantAttributes();
    }

    @Override
    public Id<Lane> getId() {
        return this.id;
    }

    private QVehicle peekFromVehQueue() {
        double now = this.context.getSimTimer().getTimeOfDay();
        QVehicle returnVeh = (QVehicle)this.vehQueue.peek();
        if (this.context.qsimConfig.getLinkDynamics() == QSimConfigGroup.LinkDynamics.SeepageQ) {
            int maxSeepModeAllowed = 4;
            if (this.context.qsimConfig.isRestrictingSeepage() && this.noOfSeepModeBringFwd == maxSeepModeAllowed) {
                this.noOfSeepModeBringFwd = 0;
                return returnVeh;
            }
            PassingVehicleQ newVehQueue = new PassingVehicleQ();
            newVehQueue.addAll(this.vehQueue);
            Iterator it = newVehQueue.iterator();
            while (it.hasNext()) {
                QVehicle veh = (QVehicle)newVehQueue.poll();
                if (!(veh.getEarliestLinkExitTime() <= now) || !this.context.qsimConfig.getSeepModes().contains(veh.getDriver().getMode())) continue;
                returnVeh = veh;
                break;
            }
        }
        return returnVeh;
    }

    private QVehicle pollFromVehQueue(QVehicle veh2Remove) {
        if (this.vehQueue.remove(veh2Remove)) {
            return veh2Remove;
        }
        throw new RuntimeException("Desired vehicle is not removed from vehQueue. Aborting...");
    }

    @Override
    public double getLoadIndicator() {
        return this.usedStorageCapacity;
    }

    class VisDataImpl
    implements QLaneI.VisData {
        private Coord upstreamCoord;
        private Coord downstreamCoord;

        VisDataImpl() {
        }

        @Override
        public final Collection<AgentSnapshotInfo> addAgentSnapshotInfo(Collection<AgentSnapshotInfo> positions, double now) {
            if (!(QueueWithBuffer.this.buffer.isEmpty() && QueueWithBuffer.this.vehQueue.isEmpty() && QueueWithBuffer.this.holes.isEmpty())) {
                Gbl.assertNotNull(positions);
                Gbl.assertNotNull(((QueueWithBuffer)QueueWithBuffer.this).context.snapshotInfoBuilder);
                if (this.upstreamCoord == null) {
                    this.upstreamCoord = QueueWithBuffer.this.qLink.getFromNode().getCoord();
                }
                if (this.downstreamCoord == null) {
                    this.downstreamCoord = QueueWithBuffer.this.qLink.getToNode().getCoord();
                }
                positions = ((QueueWithBuffer)QueueWithBuffer.this).context.snapshotInfoBuilder.positionVehiclesAlongLine(positions, now, QueueWithBuffer.this.getAllVehicles(), QueueWithBuffer.this.length, QueueWithBuffer.this.storageCapacity + QueueWithBuffer.this.getBufferStorageCapacity(), this.upstreamCoord, this.downstreamCoord, QueueWithBuffer.this.inverseFlowCapacityPerTimeStep, QueueWithBuffer.this.qLink.getFreespeed(now), QueueWithBuffer.this.qLink.getNumberOfLanesAsInt(now), QueueWithBuffer.this.holes);
            }
            return positions;
        }

        void setVisInfo(Coord upstreamCoord, Coord downstreamCoord) {
            this.upstreamCoord = upstreamCoord;
            this.downstreamCoord = downstreamCoord;
        }
    }

    static final class Hole
    implements QItem {
        private double earliestLinkEndTime;
        private double pcu;

        Hole() {
        }

        @Override
        public final double getEarliestLinkExitTime() {
            return this.earliestLinkEndTime;
        }

        @Override
        public final void setEarliestLinkExitTime(double earliestLinkEndTime) {
            this.earliestLinkEndTime = earliestLinkEndTime;
        }

        @Override
        public final double getSizeInEquivalents() {
            return this.pcu;
        }

        final void setSizeInEquivalents(double pcuFactorOfHole) {
            this.pcu = pcuFactorOfHole;
        }

        @Override
        public Vehicle getVehicle() {
            return null;
        }

        @Override
        public MobsimDriverAgent getDriver() {
            return null;
        }

        @Override
        public Id<Vehicle> getId() {
            return null;
        }
    }

    private static class FlowcapAccumulate {
        private double timeStep = 0.0;
        private double value = 0.0;

        private FlowcapAccumulate() {
        }

        private double getTimeStep() {
            return this.timeStep;
        }

        private void setTimeStep(double now) {
            this.timeStep = now;
        }

        private double getValue() {
            return this.value;
        }

        private void setValue(double value) {
            this.value = value;
        }

        private void addValue(double value1, double now) {
            this.value += value1;
            this.timeStep = now;
        }
    }

    static final class Builder
    implements QLinkImpl.LaneFactory {
        private VehicleQ<QVehicle> vehicleQueue = new FIFOVehicleQ();
        private Id<Lane> id = null;
        private Double length = null;
        private Double effectiveNumberOfLanes = null;
        private Double flowCapacity_s = null;
        private final NetsimEngineContext context;

        Builder(NetsimEngineContext context) {
            this.context = context;
            if (context.qsimConfig.getLinkDynamics() == QSimConfigGroup.LinkDynamics.PassingQ || context.qsimConfig.getLinkDynamics() == QSimConfigGroup.LinkDynamics.SeepageQ) {
                this.vehicleQueue = new PassingVehicleQ();
            }
        }

        void setVehicleQueue(VehicleQ<QVehicle> vehicleQueue) {
            this.vehicleQueue = vehicleQueue;
        }

        void setLaneId(Id<Lane> id) {
            this.id = id;
        }

        void setLength(Double length) {
            this.length = length;
        }

        void setEffectiveNumberOfLanes(Double effectiveNumberOfLanes) {
            this.effectiveNumberOfLanes = effectiveNumberOfLanes;
        }

        void setFlowCapacity_s(Double flowCapacity_s) {
            this.flowCapacity_s = flowCapacity_s;
        }

        @Override
        public QueueWithBuffer createLane(AbstractQLink qLink) {
            if (this.id == null) {
                this.id = Id.create(qLink.getLink().getId(), Lane.class);
            }
            if (this.length == null) {
                this.length = qLink.getLink().getLength();
            }
            if (this.effectiveNumberOfLanes == null) {
                this.effectiveNumberOfLanes = qLink.getLink().getNumberOfLanes();
            }
            if (this.flowCapacity_s == null) {
                this.flowCapacity_s = qLink.getLink().getFlowCapacityPerSec();
            }
            return new QueueWithBuffer(qLink.getInternalInterface(), this.vehicleQueue, this.id, this.length, this.effectiveNumberOfLanes, this.flowCapacity_s, this.context);
        }
    }
}

