/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import javax.inject.Inject;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.Controler;
import org.matsim.core.mobsim.framework.MobsimTimer;
import org.matsim.core.mobsim.qsim.interfaces.AgentCounter;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractAgentSnapshotInfoBuilder;
import org.matsim.core.mobsim.qsim.qnetsimengine.NetsimEngineContext;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkImpl;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetworkFactory;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNodeImpl;
import org.matsim.core.mobsim.qsim.qnetsimengine.QueueWithBuffer;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;

public class RunFlexibleQNetworkFactoryExample {
    public static void main(String[] args) {
        Config config = ConfigUtils.createConfig();
        Scenario scenario = ScenarioUtils.createScenario(config);
        Controler controler = new Controler(scenario);
        controler.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                this.bind(QNetworkFactory.class).to(MyQNetworkFactory.class);
            }
        });
        controler.run();
    }

    static final class MyQNetworkFactory
    implements QNetworkFactory {
        @Inject
        private EventsManager events;
        @Inject
        private Scenario scenario;
        @Inject
        private Network network;
        @Inject
        private QSimConfigGroup qsimConfig;
        private NetsimEngineContext context;
        private QNetsimEngine.NetsimInternalInterface netsimEngine;

        MyQNetworkFactory() {
        }

        @Override
        public final void initializeFactory(AgentCounter agentCounter, MobsimTimer mobsimTimer, QNetsimEngine.NetsimInternalInterface netsimEngine1) {
            double effectiveCellSize = this.network.getEffectiveCellSize();
            SnapshotLinkWidthCalculator linkWidthCalculator = new SnapshotLinkWidthCalculator();
            linkWidthCalculator.setLinkWidthForVis(this.qsimConfig.getLinkWidthForVis());
            if (!Double.isNaN(this.network.getEffectiveLaneWidth())) {
                linkWidthCalculator.setLaneWidth(this.network.getEffectiveLaneWidth());
            }
            AbstractAgentSnapshotInfoBuilder snapshotBuilder = QNetsimEngine.createAgentSnapshotInfoBuilder(this.scenario, linkWidthCalculator);
            this.context = new NetsimEngineContext(this.events, effectiveCellSize, agentCounter, snapshotBuilder, this.qsimConfig, mobsimTimer, linkWidthCalculator);
            this.netsimEngine = netsimEngine1;
        }

        @Override
        public final QNodeI createNetsimNode(Node node) {
            QNodeImpl.Builder builder = new QNodeImpl.Builder(this.netsimEngine, this.context);
            return builder.build(node);
        }

        @Override
        public final QLinkI createNetsimLink(Link link, QNodeI queueNode) {
            QLinkImpl.Builder linkBuilder = new QLinkImpl.Builder(this.context, this.netsimEngine);
            QueueWithBuffer.Builder laneBuilder = new QueueWithBuffer.Builder(this.context);
            linkBuilder.setLaneFactory(laneBuilder);
            return linkBuilder.build(link, queueNode);
        }
    }
}

