/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.internal.MatsimComparator;
import org.matsim.core.mobsim.qsim.pt.TransitDriverAgent;
import org.matsim.core.mobsim.qsim.qnetsimengine.AbstractQLink;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLaneI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

final class TransitQLink {
    private final Queue<QVehicle> transitVehicleStopQueue = new PriorityQueue<QVehicle>(5, VEHICLE_EXIT_COMPARATOR);
    private final QLaneI road;
    private static final Comparator<QVehicle> VEHICLE_EXIT_COMPARATOR = new QVehicleEarliestLinkExitTimeComparator();

    TransitQLink(QLaneI road) {
        this.road = road;
    }

    Queue<QVehicle> getTransitVehicleStopQueue() {
        return this.transitVehicleStopQueue;
    }

    final boolean addTransitToStopQueue(double now, QVehicle veh, Id<Link> linkId) {
        if (veh.getDriver() instanceof TransitDriverAgent) {
            TransitStopFacility stop;
            TransitDriverAgent driver = (TransitDriverAgent)veh.getDriver();
            while ((stop = driver.getNextTransitStop()) != null && stop.getLinkId().equals(linkId)) {
                double delay = driver.handleTransitStop(stop, now);
                if (!(delay > 0.0)) continue;
                veh.setEarliestLinkExitTime(now + delay);
                this.transitVehicleStopQueue.add(veh);
                return true;
            }
            return false;
        }
        return false;
    }

    void handleTransitVehiclesInStopQueue(double now) {
        QVehicle veh;
        LinkedList<QVehicle> departingTransitVehicles = null;
        while ((veh = this.transitVehicleStopQueue.peek()) != null && !(veh.getEarliestLinkExitTime() > now)) {
            if (departingTransitVehicles == null) {
                departingTransitVehicles = new LinkedList<QVehicle>();
            }
            departingTransitVehicles.add(this.transitVehicleStopQueue.poll());
        }
        if (departingTransitVehicles != null) {
            ListIterator iter = departingTransitVehicles.listIterator(departingTransitVehicles.size());
            while (iter.hasPrevious()) {
                this.road.addTransitSlightlyUpstreamOfStop((QVehicle)iter.previous());
            }
        }
    }

    AbstractQLink.HandleTransitStopResult handleTransitStop(double now, QVehicle veh, TransitDriverAgent transitDriver, Id<Link> linkId) {
        TransitStopFacility stop = transitDriver.getNextTransitStop();
        if (stop != null && stop.getLinkId().equals(linkId)) {
            double delay = transitDriver.handleTransitStop(stop, now);
            if (delay > 0.0) {
                veh.setEarliestLinkExitTime(now + delay);
                if (!stop.getIsBlockingLane()) {
                    this.transitVehicleStopQueue.add(veh);
                    return AbstractQLink.HandleTransitStopResult.accepted;
                }
                return AbstractQLink.HandleTransitStopResult.rehandle;
            }
            return AbstractQLink.HandleTransitStopResult.rehandle;
        }
        return AbstractQLink.HandleTransitStopResult.continue_driving;
    }

    static class QVehicleEarliestLinkExitTimeComparator
    implements Comparator<QVehicle>,
    Serializable,
    MatsimComparator {
        private static final long serialVersionUID = 1L;

        QVehicleEarliestLinkExitTimeComparator() {
        }

        @Override
        public int compare(QVehicle veh1, QVehicle veh2) {
            if (veh1.getEarliestLinkExitTime() > veh2.getEarliestLinkExitTime()) {
                return 1;
            }
            if (veh1.getEarliestLinkExitTime() < veh2.getEarliestLinkExitTime()) {
                return -1;
            }
            return veh2.getId().compareTo(veh1.getId());
        }
    }
}

