/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.mobsim.framework.MobsimAgent;
import org.matsim.core.mobsim.framework.MobsimDriverAgent;
import org.matsim.core.mobsim.qsim.interfaces.DepartureHandler;
import org.matsim.core.mobsim.qsim.qnetsimengine.QLinkI;
import org.matsim.core.mobsim.qsim.qnetsimengine.QNetsimEngine;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;
import org.matsim.vehicles.Vehicle;

class VehicularDepartureHandler
implements DepartureHandler {
    private static final Logger log = Logger.getLogger(VehicularDepartureHandler.class);
    private int cntTeleportVehicle = 0;
    private final QSimConfigGroup.VehicleBehavior vehicleBehavior;
    private final QNetsimEngine qNetsimEngine;
    private final Collection<String> transportModes;

    VehicularDepartureHandler(QNetsimEngine qNetsimEngine, QSimConfigGroup.VehicleBehavior vehicleBehavior, QSimConfigGroup qsimConfig) {
        this.qNetsimEngine = qNetsimEngine;
        this.vehicleBehavior = vehicleBehavior;
        this.transportModes = qsimConfig.getMainModes();
    }

    @Override
    public boolean handleDeparture(double now, MobsimAgent agent, Id<Link> linkId) {
        if (this.transportModes.contains(agent.getMode())) {
            if (agent instanceof MobsimDriverAgent) {
                this.handleCarDeparture(now, (MobsimDriverAgent)agent, linkId);
                return true;
            }
            throw new UnsupportedOperationException("wrong agent type to depart on a network mode");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCarDeparture(double now, MobsimDriverAgent agent, Id<Link> linkId) {
        Id<Vehicle> vehicleId = agent.getPlannedVehicleId();
        QLinkI qlink = (QLinkI)this.qNetsimEngine.getNetsimNetwork().getNetsimLink(linkId);
        QVehicle vehicle = qlink.removeParkedVehicle(vehicleId);
        if (vehicle == null) {
            if (this.vehicleBehavior == QSimConfigGroup.VehicleBehavior.teleport) {
                vehicle = this.qNetsimEngine.getVehicles().get(vehicleId);
                if (vehicle == null) {
                    String msg = "could not find requested vehicle " + vehicleId + " in simulation for agent " + agent + " with id " + agent.getId() + " on link " + agent.getCurrentLinkId() + " at time " + now + ".";
                    log.error(msg);
                    log.error("Note that, with AgentSource and if the agent starts on a leg, the vehicle needs to be inserted BEFORE the agent!");
                    throw new RuntimeException(msg + " aborting ...");
                }
                this.teleportVehicleTo(vehicle, linkId);
                vehicle.setDriver(agent);
                agent.setVehicle(vehicle);
                qlink.letVehicleDepart(vehicle);
                return;
            } else {
                if (this.vehicleBehavior != QSimConfigGroup.VehicleBehavior.wait) throw new RuntimeException("vehicle " + vehicleId + " not available for agent " + agent.getId() + " on link " + linkId + " at time " + now);
                qlink.registerDriverAgentWaitingForCar(agent);
            }
            return;
        } else {
            vehicle.setDriver(agent);
            agent.setVehicle(vehicle);
            qlink.letVehicleDepart(vehicle);
        }
    }

    private void teleportVehicleTo(QVehicle vehicle, Id<Link> linkId) {
        if (vehicle.getCurrentLink() != null) {
            QLinkI qlinkOld;
            QVehicle result;
            if (this.cntTeleportVehicle < 9) {
                ++this.cntTeleportVehicle;
                log.info("teleport vehicle " + vehicle.getId() + " from link " + vehicle.getCurrentLink().getId() + " to link " + linkId);
                if (this.cntTeleportVehicle == 9) {
                    log.info("No more occurrences of teleported vehicles will be reported.");
                }
            }
            if ((result = (qlinkOld = (QLinkI)this.qNetsimEngine.getNetsimNetwork().getNetsimLink(vehicle.getCurrentLink().getId())).removeParkedVehicle(vehicle.getId())) == null) {
                throw new RuntimeException("Could not remove parked vehicle with id " + vehicle.getId() + " on the link id " + vehicle.getCurrentLink().getId() + ".  Maybe it is currently used by someone else?" + " (In which case ignoring this exception would lead to duplication of this vehicle.) " + "Maybe was never placed onto a link?");
            }
        }
    }
}

