/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.qsim.qnetsimengine;

import java.util.ArrayList;
import java.util.List;
import org.matsim.api.core.v01.Identifiable;
import org.matsim.core.mobsim.framework.PassengerAgent;
import org.matsim.core.mobsim.qsim.qnetsimengine.QVehicle;

final class VisUtils {
    private VisUtils() {
    }

    static final List<Identifiable<?>> getPeopleInVehicle(QVehicle vehicle) {
        ArrayList people = new ArrayList();
        people.add(vehicle.getDriver());
        for (PassengerAgent passengerAgent : vehicle.getPassengers()) {
            people.add(passengerAgent);
        }
        return people;
    }

    public static final Integer guessLane(QVehicle veh, int numberOfLanes) {
        Integer tmpLane;
        block2: {
            try {
                tmpLane = Integer.parseInt(veh.getId().toString());
            }
            catch (NumberFormatException ee) {
                tmpLane = veh.getId().hashCode();
                if (tmpLane >= 0) break block2;
                tmpLane = -tmpLane.intValue();
            }
        }
        int lane = 1 + tmpLane % numberOfLanes;
        return lane;
    }

    public static final double calcSpeedValueBetweenZeroAndOne(QVehicle veh, double inverseSimulatedFlowCapacity, double now, double freespeed) {
        int cmp = (int)(veh.getEarliestLinkExitTime() + inverseSimulatedFlowCapacity + 2.0);
        double speed = now > (double)cmp ? 0.0 : 1.0;
        return speed;
    }
}

