/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.util.Arrays;
import java.util.TreeMap;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.network.TimeVariantAttribute;
import org.matsim.core.trafficmonitoring.TimeBinUtils;
import org.matsim.core.utils.misc.Time;

final class FixedIntervalTimeVariantAttribute
implements TimeVariantAttribute {
    private final int timeSlice;
    private final int numSlots;
    private double baseValue;
    private double[] values;
    private int eventsCount = 0;
    private int eventsCountWhenLastRecalc = -1;

    public FixedIntervalTimeVariantAttribute(int timeSlice, int maxTime) {
        this.timeSlice = timeSlice;
        this.numSlots = TimeBinUtils.getTimeBinCount(maxTime, timeSlice);
    }

    @Override
    public boolean isRecalcRequired() {
        return this.eventsCountWhenLastRecalc != this.eventsCount;
    }

    @Override
    public void recalc(TreeMap<Double, NetworkChangeEvent> changeEvents, TimeVariantAttribute.ChangeValueGetter valueGetter, double baseValue1) {
        this.baseValue = baseValue1;
        if (this.eventsCount == 0) {
            return;
        }
        if (this.values == null) {
            this.values = new double[this.numSlots];
        }
        int numEvent = 0;
        int fromBin = 0;
        double currentValue = baseValue1;
        if (changeEvents != null) {
            for (NetworkChangeEvent event : changeEvents.values()) {
                NetworkChangeEvent.ChangeValue value = valueGetter.getChangeValue(event);
                if (value == null) continue;
                ++numEvent;
                int toBin = (int)(event.getStartTime() / (double)this.timeSlice);
                Arrays.fill(this.values, fromBin, toBin, currentValue);
                switch (value.getType()) {
                    case ABSOLUTE_IN_SI_UNITS: {
                        currentValue = value.getValue();
                        break;
                    }
                    case FACTOR: {
                        currentValue *= value.getValue();
                        break;
                    }
                    case OFFSET_IN_SI_UNITS: {
                        currentValue += value.getValue();
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown ChangeType");
                    }
                }
                fromBin = toBin;
            }
        }
        Arrays.fill(this.values, fromBin, this.values.length, currentValue);
        this.eventsCountWhenLastRecalc = this.eventsCount;
        if (numEvent != this.eventsCount) {
            throw new RuntimeException("Expected number of change events (" + this.eventsCount + ") differs from the number of events found (" + numEvent + ")!");
        }
    }

    @Override
    public double getValue(double time) {
        if (Time.isUndefinedTime(time) || this.eventsCount == 0) {
            return this.baseValue;
        }
        int bin = TimeBinUtils.getTimeBinIndex(time, this.timeSlice, this.numSlots);
        return this.values[bin];
    }

    @Override
    public void incChangeEvents() {
        ++this.eventsCount;
    }

    @Override
    public void clearEvents() {
        this.eventsCount = 0;
        this.eventsCountWhenLastRecalc = -1;
        this.values = null;
    }
}

