/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.utils.misc.Time;
import org.matsim.utils.objectattributes.attributable.Attributes;

class LinkImpl
implements Link {
    private static final Logger log = Logger.getLogger(Link.class);
    private final Id<Link> id;
    private Node from = null;
    private Node to = null;
    private double length = Double.NaN;
    private double freespeed = Double.NaN;
    private double capacity = Double.NaN;
    private double nofLanes = Double.NaN;
    private Set<String> allowedModes = HashSetCache.get(new HashSet<String>());
    private final Network network;
    private static int fsWarnCnt = 0;
    private static int cpWarnCnt = 0;
    private static int plWarnCnt = 0;
    private static int lengthWarnCnt = 0;
    private static int loopWarnCnt = 0;
    private static final int maxFsWarnCnt = 1;
    private static final int maxCpWarnCnt = 1;
    private static final int maxPlWarnCnt = 1;
    private static final int maxLengthWarnCnt = 1;
    private static final int maxLoopWarnCnt = 1;
    private static final Set<String> DEFAULT_ALLOWED_MODES;
    private final Attributes attributes = new Attributes();

    LinkImpl(Id<Link> id, Node from, Node to, Network network, double length, double freespeed, double capacity, double lanes) {
        this.id = id;
        this.network = network;
        this.from = from;
        this.to = to;
        this.allowedModes = DEFAULT_ALLOWED_MODES;
        this.setLength(length);
        this.freespeed = freespeed;
        this.checkFreespeedSemantics();
        this.capacity = capacity;
        this.checkCapacitySemantics();
        this.nofLanes = lanes;
        this.checkNumberOfLanesSemantics();
        if (this.from.equals(this.to) && loopWarnCnt < 1) {
            log.warn("fromNode=toNode=" + this.to + ": link is a loop");
            if (++loopWarnCnt == 1) {
                log.warn(" Future occurences of this logging statement are suppressed.");
            }
        }
    }

    private void checkCapacitySemantics() {
        if (this.capacity <= 0.0 && cpWarnCnt < 1) {
            log.warn("capacity=" + this.capacity + " of link id " + this.getId() + " may cause problems");
            if (++cpWarnCnt == 1) {
                log.warn(" Future occurences of this logging statement are suppressed.");
            }
        }
    }

    private void checkFreespeedSemantics() {
        if (this.freespeed <= 0.0 && fsWarnCnt < 1 && ++fsWarnCnt == 1) {
            log.warn(" Future occurences of this logging statement are suppressed.");
        }
    }

    private void checkNumberOfLanesSemantics() {
        if (this.nofLanes < 1.0 && plWarnCnt < 1) {
            log.warn("permlanes=" + this.nofLanes + " of link id " + this.getId() + " may cause problems");
            if (++plWarnCnt == 1) {
                log.warn(" Future occurences of this logging statement are suppressed.");
            }
        }
    }

    private void checkLengthSemantics() {
        if (this.getLength() <= 0.0 && lengthWarnCnt < 1) {
            log.warn("length=" + this.length + " of link id " + this.getId() + " may cause problems");
            if (++lengthWarnCnt == 1) {
                log.warn(" Future occurences of this logging statement are suppressed.");
            }
        }
    }

    @Override
    public Node getFromNode() {
        return this.from;
    }

    @Override
    public final boolean setFromNode(Node node) {
        this.from = node;
        return true;
    }

    @Override
    public Node getToNode() {
        return this.to;
    }

    @Override
    public final boolean setToNode(Node node) {
        this.to = node;
        return true;
    }

    @Override
    public void setCapacity(double capacityPerNetworkCapcityPeriod) {
        this.capacity = capacityPerNetworkCapcityPeriod;
        this.checkCapacitySemantics();
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    @Override
    public double getCapacity(double time) {
        return this.capacity;
    }

    @Override
    public double getFlowCapacityPerSec() {
        return this.getFlowCapacityPerSec(Time.getUndefinedTime());
    }

    @Override
    public double getFlowCapacityPerSec(double time) {
        return this.getCapacity(time) / this.network.getCapacityPeriod();
    }

    double getCapacityPeriod() {
        return this.network.getCapacityPeriod();
    }

    @Override
    public double getFreespeed() {
        return this.freespeed;
    }

    @Override
    public double getFreespeed(double time) {
        return this.freespeed;
    }

    @Override
    public void setFreespeed(double freespeed) {
        this.freespeed = freespeed;
        this.checkFreespeedSemantics();
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public final void setLength(double length) {
        this.length = length;
        this.checkLengthSemantics();
    }

    @Override
    public double getNumberOfLanes() {
        return this.nofLanes;
    }

    @Override
    public double getNumberOfLanes(double time) {
        return this.nofLanes;
    }

    @Override
    public void setNumberOfLanes(double lanes) {
        this.nofLanes = lanes;
        this.checkNumberOfLanesSemantics();
    }

    @Override
    public final Set<String> getAllowedModes() {
        return this.allowedModes;
    }

    @Override
    public final void setAllowedModes(Set<String> modes) {
        this.allowedModes = HashSetCache.get(modes);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.from.addOutLink(this);
        this.to.addInLink(this);
    }

    public String toString() {
        return super.toString() + "[id=" + this.getId() + "]" + "[from_id=" + this.from.getId() + "]" + "[to_id=" + this.to.getId() + "]" + "[length=" + this.length + "]" + "[freespeed=" + this.freespeed + "]" + "[capacity=" + this.capacity + "]" + "[permlanes=" + this.nofLanes + "]" + "[modes=" + this.allowedModes;
    }

    @Override
    public Id<Link> getId() {
        return this.id;
    }

    @Override
    public Coord getCoord() {
        Coord fromXY = this.getFromNode().getCoord();
        Coord toXY = this.getToNode().getCoord();
        return new Coord((fromXY.getX() + toXY.getX()) / 2.0, (fromXY.getY() + toXY.getY()) / 2.0);
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("car");
        DEFAULT_ALLOWED_MODES = HashSetCache.get(set);
    }

    static abstract class HashSetCache {
        private static final Map<Integer, List<Set<String>>> cache = new ConcurrentHashMap<Integer, List<Set<String>>>();

        HashSetCache() {
        }

        public static Set<String> get(Set<String> set) {
            if (set == null) {
                return null;
            }
            int size = set.size();
            List<Set<String>> list = cache.get(size);
            if (list == null) {
                list = new ArrayList<Set<String>>(4);
                cache.put(size, list);
                HashSet<String> set2 = new HashSet<String>(set);
                Set<String> set3 = Collections.unmodifiableSet(set2);
                list.add(set3);
                return set3;
            }
            for (Set<String> s2 : list) {
                if (!s2.equals(set)) continue;
                return s2;
            }
            HashSet<String> set2 = new HashSet<String>(set);
            Set<String> set3 = Collections.unmodifiableSet(set2);
            list.add(set3);
            return set3;
        }
    }
}

