/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.util.ArrayList;
import org.matsim.api.core.v01.network.Link;

public final class LinkQuadTree {
    private final QuadTreeNode top;

    public LinkQuadTree(double minX, double minY, double maxX, double maxY) {
        this.top = new QuadTreeNode(minX, minY, maxX, maxY);
    }

    public void put(Link link) {
        this.top.put(new LinkWrapper(link));
    }

    public Link getNearest(double x, double y) {
        LinkWrapper w = this.top.getNearest(x, y, new MutableDouble(Double.POSITIVE_INFINITY));
        if (w == null) {
            return null;
        }
        return w.link;
    }

    public void remove(Link link) {
        this.top.remove(new LinkWrapper(link));
    }

    public double getMinEasting() {
        return this.top.minX;
    }

    public double getMaxEasting() {
        return this.top.maxX;
    }

    public double getMinNorthing() {
        return this.top.minY;
    }

    public double getMaxNorthing() {
        return this.top.maxY;
    }

    private static double calcLineSegmentDistanceIndicator(double x, double y, Link link) {
        double fx = link.getFromNode().getCoord().getX();
        double fy = link.getFromNode().getCoord().getY();
        double lineDX = link.getToNode().getCoord().getX() - fx;
        double lineDY = link.getToNode().getCoord().getY() - fy;
        if (lineDX == 0.0 && lineDY == 0.0) {
            return LinkQuadTree.calcDistanceIndicator(fx, fy, x, y);
        }
        double u = ((x - fx) * lineDX + (y - fy) * lineDY) / (lineDX * lineDX + lineDY * lineDY);
        if (u <= 0.0) {
            return LinkQuadTree.calcDistanceIndicator(fx, fy, x, y);
        }
        if (u >= 1.0) {
            return LinkQuadTree.calcDistanceIndicator(fx + lineDX, fy + lineDY, x, y);
        }
        return LinkQuadTree.calcDistanceIndicator(fx + u * lineDX, fy + u * lineDY, x, y);
    }

    private static double calcDistanceIndicator(double fromX, double fromY, double toX, double toY) {
        double xDiff = toX - fromX;
        double yDiff = toY - fromY;
        return xDiff * xDiff + yDiff * yDiff;
    }

    private static class MutableDouble {
        public double value;

        public MutableDouble(double value) {
            this.value = value;
        }
    }

    private static class LinkWrapper {
        final double minX;
        final double minY;
        final double maxX;
        final double maxY;
        final Link link;

        public LinkWrapper(Link link) {
            double fx = link.getFromNode().getCoord().getX();
            double fy = link.getFromNode().getCoord().getY();
            double tx = link.getToNode().getCoord().getX();
            double ty = link.getToNode().getCoord().getY();
            if (fx == tx) {
                this.minX = fx - fx * 1.0E-8;
                this.maxX = fx + fx * 1.0E-8;
            } else {
                this.minX = Math.min(fx, tx);
                this.maxX = Math.max(fx, tx);
            }
            if (fy == ty) {
                this.minY = fy - fy * 1.0E-8;
                this.maxY = fy + fy * 1.0E-8;
            } else {
                this.minY = Math.min(fy, ty);
                this.maxY = Math.max(fy, ty);
            }
            this.link = link;
        }
    }

    private static class QuadTreeNode {
        public final double minX;
        public final double minY;
        public final double maxX;
        public final double maxY;
        private final ArrayList<LinkWrapper> links = new ArrayList(3);
        private QuadTreeNode[] children = null;

        public QuadTreeNode(double minX, double minY, double maxX, double maxY) {
            this.minX = Math.min(minX, maxX);
            this.minY = Math.min(minY, maxY);
            this.maxX = Math.max(minX, maxX);
            this.maxY = Math.max(minY, maxY);
        }

        public void put(LinkWrapper w) {
            if (this.children == null && this.links.isEmpty()) {
                this.links.add(w);
            } else {
                ChildPosition pos = this.getChildPosition(w);
                if (pos == ChildPosition.NO_CHILD) {
                    this.links.add(w);
                } else {
                    if (this.children == null) {
                        this.split();
                    }
                    this.children[pos.ordinal()].put(w);
                }
            }
        }

        public boolean remove(LinkWrapper w) {
            ChildPosition pos = this.getChildPosition(w);
            if (pos == ChildPosition.NO_CHILD || this.children == null) {
                int n = this.links.size();
                for (int i = 0; i < n; ++i) {
                    LinkWrapper w2 = this.links.get(i);
                    if (!w2.link.equals(w.link)) continue;
                    this.links.remove(i);
                    return true;
                }
            } else {
                return this.children[pos.ordinal()].remove(w);
            }
            return false;
        }

        public LinkWrapper getNearest(double x, double y, MutableDouble bestDistanceIndicator) {
            ChildPosition childPos;
            LinkWrapper closest = null;
            for (LinkWrapper w : this.links) {
                double tmp = LinkQuadTree.calcLineSegmentDistanceIndicator(x, y, w.link);
                if (!(tmp < bestDistanceIndicator.value)) continue;
                bestDistanceIndicator.value = tmp;
                closest = w;
            }
            if (this.children != null && (childPos = this.getChildPosition(x, y)) != ChildPosition.NO_CHILD) {
                LinkWrapper tmp = this.children[childPos.ordinal()].getNearest(x, y, bestDistanceIndicator);
                if (tmp != null) {
                    closest = tmp;
                }
                for (ChildPosition c : ChildPosition.values()) {
                    QuadTreeNode child;
                    if (c == childPos || c == ChildPosition.NO_CHILD || !((child = this.children[c.ordinal()]).calcDistanceIndicator(x, y) < bestDistanceIndicator.value) || (tmp = child.getNearest(x, y, bestDistanceIndicator)) == null) continue;
                    closest = tmp;
                }
            }
            return closest;
        }

        private void split() {
            double centerX = (this.minX + this.maxX) / 2.0;
            double centerY = (this.minY + this.maxY) / 2.0;
            this.children = new QuadTreeNode[4];
            this.children[ChildPosition.CHILD_NW.ordinal()] = new QuadTreeNode(this.minX, centerY, centerX, this.maxY);
            this.children[ChildPosition.CHILD_NE.ordinal()] = new QuadTreeNode(centerX, centerY, this.maxX, this.maxY);
            this.children[ChildPosition.CHILD_SE.ordinal()] = new QuadTreeNode(centerX, this.minY, this.maxX, centerY);
            this.children[ChildPosition.CHILD_SW.ordinal()] = new QuadTreeNode(this.minX, this.minY, centerX, centerY);
            ArrayList<LinkWrapper> keep = new ArrayList<LinkWrapper>(this.links.size() / 2);
            for (LinkWrapper w : this.links) {
                ChildPosition pos = this.getChildPosition(w);
                if (pos == ChildPosition.NO_CHILD) {
                    keep.add(w);
                    continue;
                }
                this.children[pos.ordinal()].put(w);
            }
            this.links.clear();
            this.links.ensureCapacity(keep.size() + 5);
            this.links.addAll(keep);
        }

        private ChildPosition getChildPosition(LinkWrapper w) {
            double centerX = (this.minX + this.maxX) / 2.0;
            double centerY = (this.minY + this.maxY) / 2.0;
            if (w.maxX < centerX && w.minY >= centerY) {
                return ChildPosition.CHILD_NW;
            }
            if (w.minX >= centerX && w.minY >= centerY) {
                return ChildPosition.CHILD_NE;
            }
            if (w.minX >= centerX && w.maxY < centerY) {
                return ChildPosition.CHILD_SE;
            }
            if (w.maxX < centerX && w.maxY < centerY) {
                return ChildPosition.CHILD_SW;
            }
            return ChildPosition.NO_CHILD;
        }

        private ChildPosition getChildPosition(double x, double y) {
            double centerX = (this.minX + this.maxX) / 2.0;
            double centerY = (this.minY + this.maxY) / 2.0;
            if (x < centerX && y >= centerY) {
                return ChildPosition.CHILD_NW;
            }
            if (x >= centerX && y >= centerY) {
                return ChildPosition.CHILD_NE;
            }
            if (x >= centerX && y < centerY) {
                return ChildPosition.CHILD_SE;
            }
            if (x < centerX && y < centerY) {
                return ChildPosition.CHILD_SW;
            }
            throw new RuntimeException("should never get here since (x,y) has to be _somewhere_ with respect to centerX and centerY");
        }

        private double calcDistanceIndicator(double x, double y) {
            double distanceX = this.minX <= x && x <= this.maxX ? 0.0 : Math.min(Math.abs(this.minX - x), Math.abs(this.maxX - x));
            double distanceY = this.minY <= y && y <= this.maxY ? 0.0 : Math.min(Math.abs(this.minY - y), Math.abs(this.maxY - y));
            return distanceX * distanceX + distanceY * distanceY;
        }

        private static enum ChildPosition {
            CHILD_NW,
            CHILD_NE,
            CHILD_SE,
            CHILD_SW,
            NO_CHILD;

        }
    }
}

