/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.internal.MatsimComparator;

public final class NetworkChangeEvent {
    private final List<Link> links = new ArrayList<Link>();
    private final List<Link> unmodifiableLinks = Collections.unmodifiableList(this.links);
    private final double startTime;
    private ChangeValue flowCapacityChange = null;
    private ChangeValue freespeedChange = null;
    private ChangeValue lanesChange = null;

    public NetworkChangeEvent(double startTime) {
        this.startTime = startTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addLinks(Collection<? extends Link> links1) {
        this.links.addAll(links1);
    }

    public void removeLink(Link link) {
        this.links.remove(link);
    }

    public Collection<Link> getLinks() {
        return this.unmodifiableLinks;
    }

    public ChangeValue getFlowCapacityChange() {
        return this.flowCapacityChange;
    }

    public void setFlowCapacityChange(ChangeValue flowCapacityChange) {
        this.flowCapacityChange = flowCapacityChange;
    }

    public ChangeValue getFreespeedChange() {
        return this.freespeedChange;
    }

    public void setFreespeedChange(ChangeValue freespeedChange) {
        this.freespeedChange = freespeedChange;
    }

    public ChangeValue getLanesChange() {
        return this.lanesChange;
    }

    public void setLanesChange(ChangeValue lanesChange) {
        this.lanesChange = lanesChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkChangeEvent that = (NetworkChangeEvent)o;
        if (Double.compare(that.startTime, this.startTime) != 0) {
            return false;
        }
        if (!this.links.equals(that.links)) {
            return false;
        }
        if (this.flowCapacityChange != null ? !this.flowCapacityChange.equals(that.flowCapacityChange) : that.flowCapacityChange != null) {
            return false;
        }
        if (this.freespeedChange != null ? !this.freespeedChange.equals(that.freespeedChange) : that.freespeedChange != null) {
            return false;
        }
        return this.lanesChange != null ? this.lanesChange.equals(that.lanesChange) : that.lanesChange == null;
    }

    public int hashCode() {
        int result = this.links.hashCode();
        long temp = Double.doubleToLongBits(this.startTime);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.flowCapacityChange != null ? this.flowCapacityChange.hashCode() : 0);
        result = 31 * result + (this.freespeedChange != null ? this.freespeedChange.hashCode() : 0);
        result = 31 * result + (this.lanesChange != null ? this.lanesChange.hashCode() : 0);
        return result;
    }

    public static class StartTimeComparator
    implements Comparator<NetworkChangeEvent>,
    Serializable,
    MatsimComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(NetworkChangeEvent o1, NetworkChangeEvent o2) {
            return Double.compare(o1.getStartTime(), o2.getStartTime());
        }
    }

    public static class ChangeValue {
        private final ChangeType type;
        private final double value;

        public ChangeValue(ChangeType type, double value) {
            this.type = type;
            this.value = value;
        }

        public ChangeType getType() {
            return this.type;
        }

        public double getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeValue that = (ChangeValue)o;
            if (Double.compare(that.value, this.value) != 0) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }

    public static enum ChangeType {
        ABSOLUTE_IN_SI_UNITS,
        FACTOR,
        OFFSET_IN_SI_UNITS;

    }
}

