/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.NetworkFactory;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.LinkFactory;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.geometry.CoordUtils;

final class NetworkFactoryImpl
implements NetworkFactory {
    private static final Logger log = Logger.getLogger(NetworkFactory.class);
    private LinkFactory linkFactory = null;
    private final Network network;

    NetworkFactoryImpl(Network network) {
        this.network = network;
        this.linkFactory = NetworkUtils.createLinkFactory();
    }

    @Override
    public Node createNode(Id<Node> id, Coord coord) {
        Node node = NetworkUtils.createNode(id);
        node.setCoord(coord);
        return node;
    }

    @Override
    public Link createLink(Id<Link> id, Node fromNode, Node toNode) {
        return this.linkFactory.createLink(id, fromNode, toNode, this.network, CoordUtils.calcEuclideanDistance(fromNode.getCoord(), toNode.getCoord()), 1.0, 1.0, 1.0);
    }

    @Override
    public void setLinkFactory(LinkFactory factory) {
        this.linkFactory = factory;
    }
}

