/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.NetworkFactory;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.LinkQuadTree;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.network.NetworkFactoryImpl;
import org.matsim.core.network.SearchableNetwork;
import org.matsim.core.network.TimeDependentNetwork;
import org.matsim.core.network.TimeVariantLinkImpl;
import org.matsim.core.scenario.Lockable;
import org.matsim.core.utils.collections.QuadTree;
import org.matsim.utils.objectattributes.attributable.Attributes;

final class NetworkImpl
implements Network,
Lockable,
TimeDependentNetwork,
SearchableNetwork {
    private static final Logger log = Logger.getLogger(NetworkImpl.class);
    private double capacityPeriod = 3600.0;
    private final Map<Id<Node>, Node> nodes = new LinkedHashMap<Id<Node>, Node>();
    private final Map<Id<Link>, Link> links = new LinkedHashMap<Id<Link>, Link>();
    private QuadTree<Node> nodeQuadTree = null;
    private LinkQuadTree linkQuadTree = null;
    private static final double DEFAULT_EFFECTIVE_CELL_SIZE = 7.5;
    private double effectiveCellSize = 7.5;
    private double effectiveLaneWidth = 3.75;
    private NetworkFactory factory;
    private final Queue<NetworkChangeEvent> networkChangeEvents = new PriorityQueue<NetworkChangeEvent>(11, new NetworkChangeEvent.StartTimeComparator());
    private String name = null;
    private int counter = 0;
    private int nextMsg = 1;
    private int counter2 = 0;
    private int nextMsg2 = 1;
    private boolean locked = false;
    private final Attributes attributes = new Attributes();

    NetworkImpl() {
        this.factory = new NetworkFactoryImpl(this);
    }

    @Override
    public void addLink(Link link) {
        Link testLink = this.links.get(link.getId());
        if (testLink != null) {
            if (testLink == link) {
                log.warn("Trying to add a link a second time to the network. link id = " + link.getId().toString());
                return;
            }
            throw new IllegalArgumentException("There exists already a link with id = " + link.getId().toString() + ".\nExisting link: " + testLink + "\nLink to be added: " + link + ".\nLink is not added to the network.");
        }
        Node fromNode = this.nodes.get(link.getFromNode().getId());
        if (fromNode == null) {
            throw new IllegalArgumentException("Trying to add link = " + link.getId() + ", but its fromNode = " + link.getFromNode().getId() + " has not been added to the network.");
        }
        Node toNode = this.nodes.get(link.getToNode().getId());
        if (toNode == null) {
            throw new IllegalArgumentException("Trying to add link = " + link.getId() + ", but its toNode = " + link.getToNode().getId() + " has not been added to the network.");
        }
        fromNode.addOutLink(link);
        toNode.addInLink(link);
        this.links.put(link.getId(), link);
        if (this.linkQuadTree != null) {
            double linkMinX = Math.min(link.getFromNode().getCoord().getX(), link.getToNode().getCoord().getX());
            double linkMaxX = Math.max(link.getFromNode().getCoord().getX(), link.getToNode().getCoord().getX());
            double linkMinY = Math.min(link.getFromNode().getCoord().getY(), link.getToNode().getCoord().getY());
            double linkMaxY = Math.max(link.getFromNode().getCoord().getY(), link.getToNode().getCoord().getY());
            if (Double.isInfinite(this.linkQuadTree.getMinEasting())) {
                this.linkQuadTree = null;
            } else if (this.linkQuadTree.getMinEasting() <= linkMinX && this.linkQuadTree.getMaxEasting() > linkMaxX && this.linkQuadTree.getMinNorthing() <= linkMinY && this.linkQuadTree.getMaxNorthing() > linkMaxY) {
                this.linkQuadTree.put(link);
            } else {
                this.linkQuadTree = null;
            }
        }
        ++this.counter;
        if (this.counter % this.nextMsg == 0) {
            this.nextMsg *= 4;
            this.printLinksCount();
        }
        if (this.locked && link instanceof Lockable) {
            ((Lockable)((Object)link)).setLocked();
        }
    }

    private void printLinksCount() {
        log.info(" link # " + this.counter);
    }

    private void printNodesCount() {
        log.info(" node # " + this.counter2);
    }

    @Override
    public void addNode(Node nn) {
        Id id = nn.getId();
        Node node = this.nodes.get(id);
        if (node != null) {
            if (node == nn) {
                log.warn("Trying to add a node a second time to the network. node id = " + id.toString());
                return;
            }
            throw new IllegalArgumentException("There exists already a node with id = " + id.toString() + ".\nExisting node: " + node + "\nNode to be added: " + nn + ".\nNode is not added to the network.");
        }
        this.nodes.put(id, nn);
        if (this.nodeQuadTree != null) {
            if (Double.isInfinite(this.nodeQuadTree.getMinEasting())) {
                this.nodeQuadTree.clear();
                this.nodeQuadTree = null;
            } else if (this.nodeQuadTree.getMinEasting() <= nn.getCoord().getX() && this.nodeQuadTree.getMaxEasting() > nn.getCoord().getX() && this.nodeQuadTree.getMinNorthing() <= nn.getCoord().getY() && this.nodeQuadTree.getMaxNorthing() > nn.getCoord().getY()) {
                this.nodeQuadTree.put(nn.getCoord().getX(), nn.getCoord().getY(), nn);
            } else {
                this.nodeQuadTree.clear();
                this.nodeQuadTree = null;
            }
        }
        ++this.counter2;
        if (this.counter2 % this.nextMsg2 == 0) {
            this.nextMsg2 *= 4;
            this.printNodesCount();
        }
        if (this.locked && nn instanceof Lockable) {
            ((Lockable)((Object)nn)).setLocked();
        }
    }

    @Override
    public Node removeNode(Id<Node> nodeId) {
        Node n = this.nodes.remove(nodeId);
        if (n == null) {
            return null;
        }
        HashSet<Link> links1 = new HashSet<Link>();
        links1.addAll(n.getInLinks().values());
        links1.addAll(n.getOutLinks().values());
        for (Link l : links1) {
            this.removeLink(l.getId());
        }
        if (this.nodeQuadTree != null) {
            this.nodeQuadTree.remove(n.getCoord().getX(), n.getCoord().getY(), n);
        }
        return n;
    }

    @Override
    public Link removeLink(Id<Link> linkId) {
        Link l = this.links.remove(linkId);
        if (l == null) {
            return null;
        }
        l.getFromNode().removeOutLink(l.getId());
        l.getToNode().removeInLink(l.getId());
        if (this.linkQuadTree != null) {
            this.linkQuadTree.remove(l);
        }
        return l;
    }

    @Override
    public void setCapacityPeriod(double capPeriod) {
        this.testForLocked();
        this.capacityPeriod = (int)capPeriod;
    }

    @Override
    public void setEffectiveCellSize(double effectiveCellSize) {
        this.testForLocked();
        if (this.effectiveCellSize != effectiveCellSize) {
            if (effectiveCellSize != 7.5) {
                log.warn("Setting effectiveCellSize to a non-default value of " + effectiveCellSize);
            } else {
                log.info("Setting effectiveCellSize to " + effectiveCellSize);
            }
            this.effectiveCellSize = effectiveCellSize;
        }
    }

    @Override
    public void setEffectiveLaneWidth(double effectiveLaneWidth) {
        this.testForLocked();
        if (!Double.isNaN(this.effectiveLaneWidth) && this.effectiveLaneWidth != effectiveLaneWidth) {
            log.warn(this + "[effectiveLaneWidth=" + this.effectiveLaneWidth + " already set. Will be overwritten with " + effectiveLaneWidth + "]");
        }
        this.effectiveLaneWidth = effectiveLaneWidth;
    }

    @Override
    public void setNetworkChangeEvents(List<NetworkChangeEvent> events) {
        this.networkChangeEvents.clear();
        for (Link link : this.getLinks().values()) {
            if (!(link instanceof TimeVariantLinkImpl)) continue;
            ((TimeVariantLinkImpl)link).clearEvents();
        }
        for (NetworkChangeEvent event : events) {
            this.addNetworkChangeEvent(event);
        }
    }

    @Override
    public void addNetworkChangeEvent(NetworkChangeEvent event) {
        this.networkChangeEvents.add(event);
        for (Link link : event.getLinks()) {
            if (link instanceof TimeVariantLinkImpl) {
                ((TimeVariantLinkImpl)link).applyEvent(event);
                continue;
            }
            throw new IllegalArgumentException("Link " + link.getId().toString() + " is not timeVariant. " + "Did you make the network factory time variant?  The easiest way to achieve this is " + "either in the config file, or syntax of the type\n" + "config.network().setTimeVariantNetwork(true);\n" + "Scenario scenario = ScenarioUtils.load/createScenario(config);\n" + "Note that the scenario needs to be created _after_ the config option is set, otherwise" + "the factory will already be there.");
        }
    }

    @Override
    public double getCapacityPeriod() {
        return this.capacityPeriod;
    }

    @Override
    public double getEffectiveCellSize() {
        return this.effectiveCellSize;
    }

    @Override
    public double getEffectiveLaneWidth() {
        return this.effectiveLaneWidth;
    }

    public Map<Id<Node>, Node> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    @Override
    public Link getNearestLinkExactly(Coord coord) {
        if (this.linkQuadTree == null) {
            this.buildLinkQuadTree();
        }
        return this.linkQuadTree.getNearest(coord.getX(), coord.getY());
    }

    @Override
    public Node getNearestNode(Coord coord) {
        if (this.nodeQuadTree == null) {
            this.buildQuadTree();
        }
        return this.nodeQuadTree.getClosest(coord.getX(), coord.getY());
    }

    @Override
    public Collection<Node> getNearestNodes(Coord coord, double distance) {
        if (this.nodeQuadTree == null) {
            this.buildQuadTree();
        }
        return this.nodeQuadTree.getDisk(coord.getX(), coord.getY(), distance);
    }

    @Override
    public Queue<NetworkChangeEvent> getNetworkChangeEvents() {
        return this.networkChangeEvents;
    }

    @Override
    public NetworkFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return super.toString() + "[capperiod=" + this.capacityPeriod + "]" + "[nof_nodes=" + this.nodes.size() + "]";
    }

    private synchronized void buildQuadTree() {
        if (this.nodeQuadTree != null) {
            return;
        }
        double startTime = System.currentTimeMillis();
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (Node n : this.nodes.values()) {
            if (n.getCoord().getX() < minx) {
                minx = n.getCoord().getX();
            }
            if (n.getCoord().getY() < miny) {
                miny = n.getCoord().getY();
            }
            if (n.getCoord().getX() > maxx) {
                maxx = n.getCoord().getX();
            }
            if (!(n.getCoord().getY() > maxy)) continue;
            maxy = n.getCoord().getY();
        }
        log.info("building QuadTree for nodes: xrange(" + (minx -= 1.0) + "," + (maxx += 1.0) + "); yrange(" + (miny -= 1.0) + "," + (maxy += 1.0) + ")");
        QuadTree<Node> quadTree = new QuadTree<Node>(minx, miny, maxx, maxy);
        for (Node n : this.nodes.values()) {
            quadTree.put(n.getCoord().getX(), n.getCoord().getY(), n);
        }
        this.nodeQuadTree = quadTree;
        log.info("Building QuadTree took " + ((double)System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }

    private synchronized void buildLinkQuadTree() {
        if (this.linkQuadTree != null) {
            return;
        }
        double startTime = System.currentTimeMillis();
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (Node n : this.nodes.values()) {
            if (n.getCoord().getX() < minx) {
                minx = n.getCoord().getX();
            }
            if (n.getCoord().getY() < miny) {
                miny = n.getCoord().getY();
            }
            if (n.getCoord().getX() > maxx) {
                maxx = n.getCoord().getX();
            }
            if (!(n.getCoord().getY() > maxy)) continue;
            maxy = n.getCoord().getY();
        }
        log.info("building LinkQuadTree for nodes: xrange(" + (minx -= 1.0) + "," + (maxx += 1.0) + "); yrange(" + (miny -= 1.0) + "," + (maxy += 1.0) + ")");
        LinkQuadTree qt = new LinkQuadTree(minx, miny, maxx, maxy);
        for (Link l : this.links.values()) {
            qt.put(l);
        }
        this.linkQuadTree = qt;
        log.info("Building LinkQuadTree took " + ((double)System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }

    public Map<Id<Link>, Link> getLinks() {
        return Collections.unmodifiableMap(this.links);
    }

    void setFactory(NetworkFactory networkFactory) {
        this.factory = networkFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLocked() {
        this.locked = true;
        for (Link link : this.links.values()) {
            if (!(link instanceof Lockable)) continue;
            ((Lockable)((Object)link)).setLocked();
        }
        for (Node node : this.nodes.values()) {
            if (!(node instanceof Lockable)) continue;
            ((Lockable)((Object)node)).setLocked();
        }
    }

    private void testForLocked() {
        if (this.locked) {
            throw new RuntimeException("Network is locked; too late to do this.  See comments in code.");
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public final LinkQuadTree getLinkQuadTree() {
        return this.linkQuadTree;
    }

    @Override
    public final QuadTree<Node> getNodeQuadTree() {
        return this.nodeQuadTree;
    }
}

