/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.NetworkWriter;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.groups.NetworkConfigGroup;
import org.matsim.core.network.LinkFactoryImpl;
import org.matsim.core.network.LinkImpl;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.network.NetworkImpl;
import org.matsim.core.network.NodeImpl;
import org.matsim.core.network.SearchableNetwork;
import org.matsim.core.network.TimeDependentNetwork;
import org.matsim.core.network.VariableIntervalTimeVariantLinkFactory;
import org.matsim.core.network.algorithms.NetworkCleaner;
import org.matsim.core.network.algorithms.NetworkSimplifier;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.geometry.CoordUtils;

public final class NetworkUtils {
    private static Logger log = Logger.getLogger(NetworkUtils.class);
    public static final String TYPE = "type";
    public static final String ORIGID = "origid";

    public static Network createNetwork(Config config) {
        return NetworkUtils.createNetwork(config.network());
    }

    public static Network createNetwork(NetworkConfigGroup networkConfigGroup) {
        NetworkImpl network = new NetworkImpl();
        if (networkConfigGroup.isTimeVariantNetwork()) {
            network.getFactory().setLinkFactory(new VariableIntervalTimeVariantLinkFactory());
        }
        return network;
    }

    public static double[] getBoundingBox(Collection<? extends Node> nodes) {
        double[] bBox = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (Node node : nodes) {
            if (node.getCoord().getX() < bBox[0]) {
                bBox[0] = node.getCoord().getX();
            }
            if (node.getCoord().getX() > bBox[2]) {
                bBox[2] = node.getCoord().getX();
            }
            if (node.getCoord().getY() > bBox[3]) {
                bBox[3] = node.getCoord().getY();
            }
            if (!(node.getCoord().getY() < bBox[1])) continue;
            bBox[1] = node.getCoord().getY();
        }
        return bBox;
    }

    public static Node[] getSortedNodes(Network network) {
        Node[] nodes = network.getNodes().values().toArray(new Node[network.getNodes().size()]);
        Arrays.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return nodes;
    }

    public static List<Node> getNodes(Network network, String nodes) {
        if (nodes == null) {
            return new ArrayList<Node>(0);
        }
        String trimmed = nodes.trim();
        if (trimmed.length() == 0) {
            return new ArrayList<Node>(0);
        }
        String[] parts = trimmed.split("[ \t\n]+");
        ArrayList<Node> nodesList = new ArrayList<Node>(parts.length);
        for (String id : parts) {
            Node node = network.getNodes().get(Id.create(id, Node.class));
            if (node == null) {
                throw new IllegalArgumentException("no node with id " + id);
            }
            nodesList.add(node);
        }
        return nodesList;
    }

    public static Link[] getSortedLinks(Network network) {
        Link[] links = network.getLinks().values().toArray(new Link[network.getLinks().size()]);
        Arrays.sort(links, new Comparator<Link>(){

            @Override
            public int compare(Link o1, Link o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return links;
    }

    public static List<Link> getLinks(Network network, String links) {
        if (links == null) {
            return new ArrayList<Link>(0);
        }
        String trimmed = links.trim();
        if (trimmed.length() == 0) {
            return new ArrayList<Link>(0);
        }
        String[] parts = trimmed.split("[ \t\n]+");
        ArrayList<Link> linksList = new ArrayList<Link>(parts.length);
        for (String id : parts) {
            Link link = network.getLinks().get(Id.create(id, Link.class));
            if (link == null) {
                throw new IllegalArgumentException("no link with id " + id);
            }
            linksList.add(link);
        }
        return linksList;
    }

    public static List<Id<Link>> getLinkIds(String links) {
        if (links == null) {
            return new ArrayList<Id<Link>>(0);
        }
        String trimmed = links.trim();
        if (trimmed.length() == 0) {
            return new ArrayList<Id<Link>>(0);
        }
        String[] parts = trimmed.split("[ \t\n]+");
        ArrayList<Id<Link>> linkIdsList = new ArrayList<Id<Link>>(parts.length);
        for (String id : parts) {
            linkIdsList.add(Id.create(id, Link.class));
        }
        return linkIdsList;
    }

    public static List<Link> getLinks(Network network, List<Id<Link>> linkIds) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (Id<Link> linkId : linkIds) {
            Link link = network.getLinks().get(linkId);
            if (link == null) {
                throw new IllegalArgumentException("no link with id " + linkId);
            }
            links.add(link);
        }
        return links;
    }

    public static List<Id<Link>> getLinkIds(List<Link> links) {
        ArrayList<Id<Link>> linkIds = new ArrayList<Id<Link>>();
        if (links != null) {
            for (Link link : links) {
                linkIds.add(link.getId());
            }
        }
        return linkIds;
    }

    public static int getNumberOfLanesAsInt(double time, Link link) {
        int numberOfLanes = (int)link.getNumberOfLanes(time);
        if (numberOfLanes == 0) {
            return 1;
        }
        return numberOfLanes;
    }

    public static boolean isMultimodal(Network network) {
        String mode = null;
        boolean hasEmptyModes = false;
        for (Link link : network.getLinks().values()) {
            Set<String> modes = link.getAllowedModes();
            if (modes.size() > 1) {
                return true;
            }
            if (modes.size() == 1) {
                String m22 = modes.iterator().next();
                if (mode == null) {
                    if (hasEmptyModes) {
                        return true;
                    }
                    mode = m22;
                    continue;
                }
                if (m22.equals(mode)) continue;
                return true;
            }
            if (modes.size() != 0) continue;
            if (mode != null) {
                return true;
            }
            hasEmptyModes = true;
        }
        return false;
    }

    public static Link getConnectingLink(Node fromNode, Node toNode) {
        for (Link link : fromNode.getOutLinks().values()) {
            if (link.getToNode() != toNode) continue;
            return link;
        }
        return null;
    }

    public static Node getCloserNodeOnLink(Coord coord, Link link) {
        double distanceFromNode;
        Node toNode = link.getToNode();
        Node fromNode = link.getFromNode();
        double distanceToNode = NetworkUtils.getEuclideanDistance(coord, toNode.getCoord());
        if (distanceToNode < (distanceFromNode = NetworkUtils.getEuclideanDistance(coord, fromNode.getCoord()))) {
            return toNode;
        }
        return fromNode;
    }

    public static double getEuclideanDistance(Coord origin, Coord destination) {
        return CoordUtils.calcEuclideanDistance(origin, destination);
    }

    public static double getEuclideanDistance(double x1, double y1, double x2, double y2) {
        return NetworkUtils.getEuclideanDistance(new Coord(x1, y1), new Coord(x2, y2));
    }

    public static Link getNearestRightEntryLink(Network network, Coord coord) {
        Link nearestRightLink = null;
        Link nearestOverallLink = null;
        Node nearestNode = NetworkUtils.getNearestNode(network, coord);
        double[] coordVector = new double[]{nearestNode.getCoord().getX() - coord.getX(), nearestNode.getCoord().getY() - coord.getY()};
        double shortestRightDistance = Double.MAX_VALUE;
        double shortestOverallDistance = Double.MAX_VALUE;
        ArrayList<? extends Link> incidentLinks = new ArrayList<Link>(nearestNode.getInLinks().values());
        incidentLinks.addAll(nearestNode.getOutLinks().values());
        for (Link link : incidentLinks) {
            double[] linkVector;
            double crossProductZ;
            double dist = CoordUtils.distancePointLinesegment(link.getFromNode().getCoord(), link.getToNode().getCoord(), coord);
            if (dist <= shortestRightDistance && (crossProductZ = coordVector[0] * (linkVector = new double[]{link.getToNode().getCoord().getX() - link.getFromNode().getCoord().getX(), link.getToNode().getCoord().getY() - link.getFromNode().getCoord().getY()})[1] - coordVector[1] * linkVector[0]) < 0.0) {
                if (dist < shortestRightDistance) {
                    shortestRightDistance = dist;
                    nearestRightLink = link;
                } else if (link.getId().compareTo(nearestRightLink.getId()) < 0) {
                    shortestRightDistance = dist;
                    nearestRightLink = link;
                }
            }
            if (dist < shortestOverallDistance) {
                shortestOverallDistance = dist;
                nearestOverallLink = link;
                continue;
            }
            if (dist != shortestOverallDistance || link.getId().compareTo(nearestOverallLink.getId()) >= 0) continue;
            shortestOverallDistance = dist;
            nearestOverallLink = link;
        }
        if (nearestRightLink == null) {
            return nearestOverallLink;
        }
        return nearestRightLink;
    }

    public static Link getNearestLink(Network network, Coord coord) {
        Link nearestLink = null;
        Node nearestNode = NetworkUtils.getNearestNode(network, coord);
        if (nearestNode == null) {
            log.warn("[nearestNode not found.  Will probably crash eventually. Maybe run NetworkCleaner?  Also may mean that network for mode is not defined.]" + network);
            return null;
        }
        if (nearestNode.getInLinks().isEmpty() && nearestNode.getOutLinks().isEmpty()) {
            log.warn(network + "[found nearest node that has no incident links.  Will probably crash eventually ...  Maybe run NetworkCleaner?]");
        }
        double shortestDistance = Double.MAX_VALUE;
        for (Link link : NetworkUtils.getIncidentLinks(nearestNode).values()) {
            double dist = CoordUtils.distancePointLinesegment(link.getFromNode().getCoord(), link.getToNode().getCoord(), coord);
            if (!(dist < shortestDistance)) continue;
            shortestDistance = dist;
            nearestLink = link;
        }
        if (nearestLink == null) {
            log.warn(network + "[nearestLink not found.  Will probably crash eventually ...  Maybe run NetworkCleaner?]");
        }
        return nearestLink;
    }

    public static Link getLeftmostTurnExcludingU(Link inLink) {
        TreeMap<Double, Link> result = NetworkUtils.getOutLinksSortedClockwiseByAngle(inLink);
        if (result.size() == 0) {
            return null;
        }
        return result.get(result.firstKey());
    }

    public static TreeMap<Double, Link> getOutLinksSortedClockwiseByAngle(Link inLink) {
        Coord coordInLink = NetworkUtils.getVector(inLink);
        double thetaInLink = Math.atan2(coordInLink.getY(), coordInLink.getX());
        TreeMap<Double, Link> outLinksByOrientation = new TreeMap<Double, Link>();
        for (Link link : inLink.getToNode().getOutLinks().values()) {
            if (link.getToNode().equals(inLink.getFromNode())) continue;
            Coord coordOutLink = NetworkUtils.getVector(link);
            double thetaOutLink = Math.atan2(coordOutLink.getY(), coordOutLink.getX());
            double thetaDiff = thetaOutLink - thetaInLink;
            if (thetaDiff < -Math.PI) {
                thetaDiff += Math.PI * 2;
            } else if (thetaDiff > Math.PI) {
                thetaDiff -= Math.PI * 2;
            }
            outLinksByOrientation.put(-thetaDiff, link);
        }
        return outLinksByOrientation;
    }

    private static Coord getVector(Link link) {
        double x = link.getToNode().getCoord().getX() - link.getFromNode().getCoord().getX();
        double y = link.getToNode().getCoord().getY() - link.getFromNode().getCoord().getY();
        return new Coord(x, y);
    }

    public static Map<Id<Node>, ? extends Node> getOutNodes(Node node) {
        TreeMap nodes = new TreeMap();
        for (Link link : node.getOutLinks().values()) {
            Node outNode = link.getToNode();
            nodes.put(outNode.getId(), outNode);
        }
        return nodes;
    }

    public static Map<Id<Link>, ? extends Link> getIncidentLinks(Node node) {
        TreeMap<Id<Link>, ? extends Link> links = new TreeMap<Id<Link>, Link>(node.getInLinks());
        links.putAll(node.getOutLinks());
        return links;
    }

    public static Map<Id<Node>, ? extends Node> getInNodes(Node node) {
        TreeMap nodes = new TreeMap();
        for (Link link : node.getInLinks().values()) {
            Node inNode = link.getFromNode();
            nodes.put(inNode.getId(), inNode);
        }
        return nodes;
    }

    public static Map<Id<Node>, ? extends Node> getIncidentNodes(Node node) {
        TreeMap<Id<Node>, ? extends Node> nodes = new TreeMap<Id<Node>, Node>(NetworkUtils.getInNodes(node));
        nodes.putAll(NetworkUtils.getOutNodes(node));
        return nodes;
    }

    public static Node createNode(Id<Node> id) {
        return new NodeImpl(id);
    }

    public static Node createNode(Id<Node> id, Coord coord, String type) {
        return new NodeImpl(id, coord, type);
    }

    public static Node createNode(Id<Node> id, Coord coord) {
        return new NodeImpl(id, coord);
    }

    @Deprecated
    public static void setOrigId(Node node, String id) {
        if (!(node instanceof NodeImpl)) {
            throw new RuntimeException("wrong implementation of interface Node to do this");
        }
        ((NodeImpl)node).setOrigId(id);
    }

    @Deprecated
    public static void setType(Node node, String type) {
        if (!(node instanceof NodeImpl)) {
            throw new RuntimeException("wrong implementation of interface Node to do this");
        }
        ((NodeImpl)node).setType(type);
    }

    @Deprecated
    public static String getOrigId(Node node) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getOrigId();
        }
        throw new RuntimeException("wrong implementation of interface Node to do this");
    }

    @Deprecated
    public static String getType(Node node) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getType();
        }
        throw new RuntimeException("wrong implementation of interface Node to do this");
    }

    public static double getFreespeedTravelTime(Link link) {
        return link.getLength() / link.getFreespeed();
    }

    public static double getFreespeedTravelTime(Link link, double time) {
        return link.getLength() / link.getFreespeed(time);
    }

    public static void setType(Link link, String type) {
        if (type != null) {
            link.getAttributes().putAttribute(TYPE, type);
        }
    }

    public static String getType(Link link) {
        return (String)link.getAttributes().getAttribute(TYPE);
    }

    public static String getOrigId(Link link) {
        return (String)link.getAttributes().getAttribute(ORIGID);
    }

    public static void setOrigId(Link link, String id) {
        if (id != null) {
            link.getAttributes().putAttribute(ORIGID, id);
        }
    }

    public static Link createLink(Id<Link> id, Node from, Node to, Network network, double length, double freespeed, double capacity, double lanes) {
        return new LinkImpl(id, from, to, network, length, freespeed, capacity, lanes);
    }

    public static Network createNetwork() {
        return new NetworkImpl();
    }

    public static Link createAndAddLink(Network network, Id<Link> id, Node fromNode, Node toNode, double length, double freespeed, double capacity, double numLanes) {
        return NetworkUtils.createAndAddLink(network, id, fromNode, toNode, length, freespeed, capacity, numLanes, null, null);
    }

    public static Link createAndAddLink(Network network, Id<Link> id, Node fromNode, Node toNode, double length, double freespeed, double capacity, double numLanes, String origId, String type) {
        if (network.getNodes().get(fromNode.getId()) == null) {
            throw new IllegalArgumentException(network + "[from=" + fromNode + " does not exist]");
        }
        if (network.getNodes().get(toNode.getId()) == null) {
            throw new IllegalArgumentException(network + "[to=" + toNode + " does not exist]");
        }
        Link link = network.getFactory().createLink(id, fromNode, toNode);
        link.setLength(length);
        link.setFreespeed(freespeed);
        link.setCapacity(capacity);
        link.setNumberOfLanes(numLanes);
        NetworkUtils.setType(link, type);
        NetworkUtils.setOrigId(link, origId);
        network.addLink(link);
        return link;
    }

    public static void setNetworkChangeEvents(Network network, List<NetworkChangeEvent> events) {
        if (!(network instanceof TimeDependentNetwork)) {
            throw new RuntimeException("wrong implementation of interface; Network, TimeDependentNetwork");
        }
        ((TimeDependentNetwork)((Object)network)).setNetworkChangeEvents(events);
    }

    public static Node createAndAddNode(Network network, Id<Node> id, Coord coord) {
        if (network.getNodes().containsKey(id)) {
            throw new IllegalArgumentException(network + "[id=" + id + " already exists]");
        }
        Node n = network.getFactory().createNode(id, coord);
        network.addNode(n);
        return n;
    }

    public static void addNetworkChangeEvent(Network network, NetworkChangeEvent event) {
        if (!(network instanceof TimeDependentNetwork)) {
            throw new RuntimeException("wrong implementation of interface;  Network, TimeDependentNetwork ");
        }
        ((TimeDependentNetwork)((Object)network)).addNetworkChangeEvent(event);
    }

    public static Queue<NetworkChangeEvent> getNetworkChangeEvents(Network network) {
        if (network instanceof TimeDependentNetwork) {
            return ((TimeDependentNetwork)((Object)network)).getNetworkChangeEvents();
        }
        throw new RuntimeException("wrong implementation of interface;  Network, TimeDependentNetwork ");
    }

    public static Link getNearestLinkExactly(Network network, Coord coord) {
        if (network instanceof SearchableNetwork) {
            return ((SearchableNetwork)((Object)network)).getNearestLinkExactly(coord);
        }
        throw new RuntimeException("wrong implementation of interface;  Network, SearchableNetwork ");
    }

    public static Node getNearestNode(Network network, Coord coord) {
        if (network instanceof SearchableNetwork) {
            return ((SearchableNetwork)((Object)network)).getNearestNode(coord);
        }
        throw new RuntimeException("wrong implementation of interface;  Network, SearchableNetwork ");
    }

    public static Collection<Node> getNearestNodes(Network network, Coord coord, double distance) {
        if (network instanceof SearchableNetwork) {
            return ((SearchableNetwork)((Object)network)).getNearestNodes(coord, distance);
        }
        throw new RuntimeException("wrong implementation of interface;  Network, SearchableNetwork");
    }

    @Deprecated
    public static LinkFactoryImpl createLinkFactory() {
        return new LinkFactoryImpl();
    }

    public static void runNetworkCleaner(Network network) {
        new NetworkCleaner().run(network);
    }

    public static void runNetworkSimplifier(Network network) {
        new NetworkSimplifier().run(network);
    }

    public static void writeNetwork(Network network, String string) {
        new NetworkWriter(network).write(string);
    }

    public static Link findLinkInOppositeDirection(Link link) {
        for (Link link2 : link.getToNode().getOutLinks().values()) {
            if (!link2.getToNode().equals(link.getFromNode())) continue;
            return link2;
        }
        return null;
    }

    public static void readNetwork(Network network, String string) {
        new MatsimNetworkReader(network).readFile(string);
    }

    public static Network readNetwork(String string) {
        Network network = ScenarioUtils.createScenario(ConfigUtils.createConfig()).getNetwork();
        new MatsimNetworkReader(network).readFile(string);
        return network;
    }
}

