/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.scenario.Lockable;
import org.matsim.core.utils.collections.IdentifiableArrayMap;
import org.matsim.utils.objectattributes.attributable.Attributes;

class NodeImpl
implements Node,
Lockable {
    private String type = null;
    private String origid = null;
    private transient Map<Id<Link>, Link> inlinks = new IdentifiableArrayMap<Link, Link>();
    private transient Map<Id<Link>, Link> outlinks = new IdentifiableArrayMap<Link, Link>();
    private Coord coord;
    private final Id<Node> id;
    private boolean locked = false;
    private static final Logger log = Logger.getLogger(Node.class);
    private final Attributes attributes = new Attributes();
    private static int cnt2 = 0;
    private static int cnt = 0;

    NodeImpl(Id<Node> id, Coord coord) {
        this(id, coord, null);
    }

    NodeImpl(Id<Node> id, Coord coord, String type) {
        this(id);
        this.coord = coord;
        NetworkUtils.setType(this, type);
    }

    NodeImpl(Id<Node> id) {
        this.id = id;
        this.coord = null;
    }

    void setType(String type) {
        this.type = type == null ? null : type.intern();
    }

    @Override
    public final boolean addInLink(Link inlink) {
        Id linkid = inlink.getId();
        if (this.inlinks.containsKey(linkid)) {
            throw new IllegalArgumentException(this + ": inlink_id=" + inlink.getId() + " already exists");
        }
        if (this.outlinks.containsKey(linkid) && cnt2 < 1) {
            ++cnt2;
            log.warn(this + ": inlink_id=" + inlink.getId() + " is now in- and out-link");
            log.warn(" This message given only once.");
        }
        this.inlinks.put(linkid, inlink);
        return true;
    }

    @Override
    public final boolean addOutLink(Link outlink) {
        Id linkid = outlink.getId();
        if (this.outlinks.containsKey(linkid)) {
            throw new IllegalArgumentException(this + ": outlink_id=" + outlink.getId() + " already exists");
        }
        if (this.inlinks.containsKey(linkid) && cnt < 1) {
            ++cnt;
            log.warn(this.toString() + ": outlink_id=" + outlink.getId() + " is now in- and out-link");
            log.warn(" This message given only once.");
        }
        this.outlinks.put(linkid, outlink);
        return true;
    }

    @Override
    public void setCoord(Coord coord) {
        this.testForLocked();
        this.coord = coord;
    }

    void setOrigId(String origId) {
        this.origid = origId;
    }

    @Override
    public final Link removeInLink(Id<Link> linkId) {
        return this.inlinks.remove(linkId);
    }

    @Override
    public Link removeOutLink(Id<Link> outLinkId) {
        return this.outlinks.remove(outLinkId);
    }

    String getOrigId() {
        return this.origid;
    }

    String getType() {
        return this.type;
    }

    @Override
    public Map<Id<Link>, ? extends Link> getInLinks() {
        return Collections.unmodifiableMap(this.inlinks);
    }

    @Override
    public Map<Id<Link>, ? extends Link> getOutLinks() {
        return Collections.unmodifiableMap(this.outlinks);
    }

    @Override
    public Coord getCoord() {
        return this.coord;
    }

    @Override
    public Id<Node> getId() {
        return this.id;
    }

    public String toString() {
        return "[id=" + this.id + "]" + "[coord=" + this.coord + "]" + "[type=" + this.type + "]" + "[nof_inlinks=" + this.inlinks.size() + "]" + "[nof_outlinks=" + this.outlinks.size() + "]";
    }

    @Override
    public void setLocked() {
        this.locked = true;
    }

    private void testForLocked() {
        if (this.locked) {
            throw new RuntimeException("Network is locked; too late to do this.  See comments in code.");
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

