/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.util.TreeMap;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.FixedIntervalTimeVariantAttribute;
import org.matsim.core.network.LinkImpl;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.network.TimeVariantAttribute;
import org.matsim.core.network.VariableIntervalTimeVariantAttribute;

final class TimeVariantLinkImpl
extends LinkImpl {
    private TreeMap<Double, NetworkChangeEvent> changeEvents;
    private final TimeVariantAttribute variableFreespeed;
    private final TimeVariantAttribute variableFlowCapacity;
    private final TimeVariantAttribute variableLanes;

    public static TimeVariantLinkImpl createLinkWithVariableIntervalAttributes(Id<Link> id, Node from, Node to, Network network, double length, double freespeed, double capacity, double lanes) {
        return new TimeVariantLinkImpl(id, from, to, network, length, freespeed, capacity, lanes, new VariableIntervalTimeVariantAttribute(), new VariableIntervalTimeVariantAttribute(), new VariableIntervalTimeVariantAttribute());
    }

    public static TimeVariantLinkImpl createLinkWithFixedIntervalAttributes(Id<Link> id, Node from, Node to, Network network, double length, double freespeed, double capacity, double lanes, int interval, int maxTime) {
        return new TimeVariantLinkImpl(id, from, to, network, length, freespeed, capacity, lanes, new FixedIntervalTimeVariantAttribute(interval, maxTime), new FixedIntervalTimeVariantAttribute(interval, maxTime), new FixedIntervalTimeVariantAttribute(interval, maxTime));
    }

    TimeVariantLinkImpl(Id<Link> id, Node from, Node to, Network network, double length, double freespeed, double capacity, double lanes, TimeVariantAttribute variableFreespeed, TimeVariantAttribute variableFlowCapacity, TimeVariantAttribute variableLanes) {
        super(id, from, to, network, length, freespeed, capacity, lanes);
        this.variableFreespeed = variableFreespeed;
        this.variableFlowCapacity = variableFlowCapacity;
        this.variableLanes = variableLanes;
    }

    protected synchronized void applyEvent(NetworkChangeEvent event) {
        if (this.changeEvents == null) {
            this.changeEvents = new TreeMap();
        }
        this.changeEvents.put(event.getStartTime(), event);
        if (event.getFreespeedChange() != null) {
            this.variableFreespeed.incChangeEvents();
        }
        if (event.getFlowCapacityChange() != null) {
            this.variableFlowCapacity.incChangeEvents();
        }
        if (event.getLanesChange() != null) {
            this.variableLanes.incChangeEvents();
        }
    }

    synchronized void clearEvents() {
        if (this.changeEvents != null) {
            this.changeEvents.clear();
        }
        this.variableFreespeed.clearEvents();
        this.variableFlowCapacity.clearEvents();
        this.variableLanes.clearEvents();
    }

    @Override
    public synchronized double getFreespeed(double time) {
        if (this.variableFreespeed.isRecalcRequired()) {
            this.recalcFreespeed();
        }
        return this.variableFreespeed.getValue(time);
    }

    @Override
    public void setFreespeed(double freespeed) {
        super.setFreespeed(freespeed);
        this.recalcFreespeed();
    }

    @Override
    public synchronized double getFlowCapacityPerSec(double time) {
        if (this.variableFlowCapacity.isRecalcRequired()) {
            this.recalcFlowCapacity();
        }
        return this.variableFlowCapacity.getValue(time);
    }

    @Override
    public final void setCapacity(double capacityPerNetworkCapcityPeriod) {
        super.setCapacity(capacityPerNetworkCapcityPeriod);
        this.recalcFlowCapacity();
    }

    @Override
    public synchronized double getCapacity(double time) {
        return this.getFlowCapacityPerSec(time) * this.getCapacityPeriod();
    }

    private synchronized void recalcFlowCapacity() {
        double baseFlowCapacityPerSec = this.getCapacity() / this.getCapacityPeriod();
        this.variableFlowCapacity.recalc(this.changeEvents, TimeVariantAttribute.FLOW_CAPACITY_GETTER, baseFlowCapacityPerSec);
    }

    @Override
    public synchronized double getNumberOfLanes(double time) {
        if (this.variableLanes.isRecalcRequired()) {
            this.recalcLanes();
        }
        return this.variableLanes.getValue(time);
    }

    @Override
    public void setNumberOfLanes(double lanes) {
        super.setNumberOfLanes(lanes);
        this.recalcLanes();
    }

    private synchronized void recalcFreespeed() {
        this.variableFreespeed.recalc(this.changeEvents, TimeVariantAttribute.FREESPEED_GETTER, this.getFreespeed());
    }

    private synchronized void recalcLanes() {
        this.variableLanes.recalc(this.changeEvents, TimeVariantAttribute.LANES_GETTER, this.getNumberOfLanes());
    }
}

