/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network;

import java.util.Arrays;
import java.util.TreeMap;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.network.TimeVariantAttribute;

final class VariableIntervalTimeVariantAttribute
implements TimeVariantAttribute {
    private int aEvents = 1;
    private double[] aValues;
    private double[] aTimes;

    VariableIntervalTimeVariantAttribute() {
    }

    @Override
    public boolean isRecalcRequired() {
        return this.aTimes == null || this.aTimes.length != this.aEvents;
    }

    @Override
    public void recalc(TreeMap<Double, NetworkChangeEvent> changeEvents, TimeVariantAttribute.ChangeValueGetter valueGetter, double baseValue) {
        this.aTimes = new double[this.aEvents];
        this.aValues = new double[this.aEvents];
        this.aTimes[0] = Double.NEGATIVE_INFINITY;
        this.aValues[0] = baseValue;
        int numEvent = 0;
        if (changeEvents != null) {
            block5: for (NetworkChangeEvent event : changeEvents.values()) {
                NetworkChangeEvent.ChangeValue value = valueGetter.getChangeValue(event);
                if (value == null) continue;
                switch (value.getType()) {
                    case ABSOLUTE_IN_SI_UNITS: {
                        this.aValues[++numEvent] = value.getValue();
                        this.aTimes[numEvent] = event.getStartTime();
                        continue block5;
                    }
                    case FACTOR: {
                        double currentValue = this.aValues[numEvent];
                        this.aValues[++numEvent] = currentValue * value.getValue();
                        this.aTimes[numEvent] = event.getStartTime();
                        continue block5;
                    }
                    case OFFSET_IN_SI_UNITS: {
                        double currentValue = this.aValues[numEvent];
                        this.aValues[++numEvent] = currentValue + value.getValue();
                        this.aTimes[numEvent] = event.getStartTime();
                        continue block5;
                    }
                }
                throw new RuntimeException("unknown ChangeType");
            }
        }
        if (numEvent != this.aEvents - 1) {
            throw new RuntimeException("Expected number of change events (" + (this.aEvents - 1) + ") differs from the number of events found (" + numEvent + ")!");
        }
    }

    @Override
    public double getValue(double time) {
        int key = Arrays.binarySearch(this.aTimes, time);
        key = key >= 0 ? key : -key - 2;
        return this.aValues[key];
    }

    @Override
    public void incChangeEvents() {
        ++this.aEvents;
    }

    @Override
    public void clearEvents() {
        this.aTimes = null;
        this.aValues = null;
        this.aEvents = 1;
    }
}

