/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;

public final class CalcBoundingBox
implements NetworkRunnable {
    private double minX = Double.POSITIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;

    @Override
    public void run(Network network) {
        this.minX = Double.POSITIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        for (Node node : network.getNodes().values()) {
            if (node.getCoord().getX() < this.minX) {
                this.minX = node.getCoord().getX();
            }
            if (node.getCoord().getY() < this.minY) {
                this.minY = node.getCoord().getY();
            }
            if (node.getCoord().getX() > this.maxX) {
                this.maxX = node.getCoord().getX();
            }
            if (!(node.getCoord().getY() > this.maxY)) continue;
            this.maxY = node.getCoord().getY();
        }
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

