/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;

public final class MultimodalNetworkCleaner {
    private static final Logger log = Logger.getLogger(MultimodalNetworkCleaner.class);
    private final Network network;
    private final Set<Id<Link>> removedLinks = new HashSet<Id<Link>>();
    private final Set<Id<Link>> modifiedLinks = new HashSet<Id<Link>>();

    public MultimodalNetworkCleaner(Network network) {
        this.network = network;
    }

    public void removeNodesWithoutLinks() {
        ArrayList<Node> toBeRemoved = new ArrayList<Node>();
        for (Node node : this.network.getNodes().values()) {
            if (node.getInLinks().size() != 0 || node.getOutLinks().size() != 0) continue;
            toBeRemoved.add(node);
        }
        for (Node node : toBeRemoved) {
            this.network.removeNode(node.getId());
        }
    }

    public void run(Set<String> modes) {
        this.run(modes, new HashSet<String>());
    }

    public void run(Set<String> cleaningModes, Set<String> connectivityModes) {
        HashSet<String> combinedModes = new HashSet<String>(cleaningModes);
        combinedModes.addAll(connectivityModes);
        TreeMap<Id<Link>, Link> visitedLinks = new TreeMap<Id<Link>, Link>();
        Map<Object, Object> biggestCluster = new TreeMap();
        log.info("running " + this.getClass().getName() + " algorithm for modes " + Arrays.toString(cleaningModes.toArray()) + " with connectivity modes " + Arrays.toString(connectivityModes.toArray()) + "...");
        log.info("  checking " + this.network.getNodes().size() + " nodes and " + this.network.getLinks().size() + " links for dead-ends...");
        boolean stillSearching = true;
        Iterator<? extends Link> iter = this.network.getLinks().values().iterator();
        while (iter.hasNext() && stillSearching) {
            Link startLink = iter.next();
            if (visitedLinks.containsKey(startLink.getId()) || !this.intersectingSets(combinedModes, startLink.getAllowedModes())) continue;
            Map<Id<Link>, Link> cluster = this.findCluster(startLink, combinedModes);
            visitedLinks.putAll(cluster);
            if (cluster.size() <= biggestCluster.size() || (biggestCluster = cluster).size() < this.network.getLinks().size() - visitedLinks.size()) continue;
            stillSearching = false;
        }
        log.info("    The biggest cluster consists of " + biggestCluster.size() + " links.");
        log.info("  done.");
        ArrayList<? extends Link> allLinks = new ArrayList<Link>(this.network.getLinks().values());
        for (Link link : allLinks) {
            if (biggestCluster.containsKey(link.getId())) continue;
            HashSet<String> reducedModes = new HashSet<String>(link.getAllowedModes());
            reducedModes.removeAll(cleaningModes);
            link.setAllowedModes(reducedModes);
            if (reducedModes.isEmpty()) {
                this.network.removeLink(link.getId());
                if (link.getFromNode().getInLinks().size() + link.getFromNode().getOutLinks().size() == 0) {
                    this.network.removeNode(link.getFromNode().getId());
                }
                if (link.getToNode().getInLinks().size() + link.getToNode().getOutLinks().size() == 0) {
                    this.network.removeNode(link.getToNode().getId());
                }
                this.removedLinks.add(link.getId());
            }
            if (this.removedLinks.contains(link.getId())) continue;
            this.modifiedLinks.add(link.getId());
        }
        log.info("  resulting network contains " + this.network.getNodes().size() + " nodes and " + this.network.getLinks().size() + " links.");
        log.info("done.");
    }

    private Map<Id<Link>, Link> findCluster(Link startLink, Set<String> modes) {
        DoubleFlagRole r;
        Node currNode;
        int idx;
        HashMap<Id<Link>, DoubleFlagRole> linkRoles = new HashMap<Id<Link>, DoubleFlagRole>(this.network.getLinks().size());
        ArrayList<Node> pendingForward = new ArrayList<Node>();
        ArrayList<Node> pendingBackward = new ArrayList<Node>();
        TreeMap<Id<Link>, Link> clusterLinks = new TreeMap<Id<Link>, Link>();
        pendingForward.add(startLink.getToNode());
        pendingBackward.add(startLink.getFromNode());
        while (pendingForward.size() > 0) {
            idx = pendingForward.size() - 1;
            currNode = (Node)pendingForward.remove(idx);
            for (Link link : currNode.getOutLinks().values()) {
                if (!this.intersectingSets(modes, link.getAllowedModes())) continue;
                r = MultimodalNetworkCleaner.getDoubleFlag(link, linkRoles);
                if (r.forwardFlag) continue;
                r.forwardFlag = true;
                pendingForward.add(link.getToNode());
            }
        }
        while (pendingBackward.size() > 0) {
            idx = pendingBackward.size() - 1;
            currNode = (Node)pendingBackward.remove(idx);
            for (Link link : currNode.getInLinks().values()) {
                if (!this.intersectingSets(modes, link.getAllowedModes())) continue;
                r = MultimodalNetworkCleaner.getDoubleFlag(link, linkRoles);
                if (r.backwardFlag) continue;
                r.backwardFlag = true;
                pendingBackward.add(link.getFromNode());
                if (!r.forwardFlag) continue;
                clusterLinks.put(link.getId(), link);
            }
        }
        return clusterLinks;
    }

    public final Set<Id<Link>> getRemovedLinkIds() {
        return this.removedLinks;
    }

    public final Set<Id<Link>> getModifiedLinkIds() {
        return this.modifiedLinks;
    }

    private <T> boolean intersectingSets(Set<T> setA, Set<T> setB) {
        for (T t : setA) {
            if (!setB.contains(t)) continue;
            return true;
        }
        return false;
    }

    private static DoubleFlagRole getDoubleFlag(Link l, Map<Id<Link>, DoubleFlagRole> linkRoles) {
        DoubleFlagRole r = linkRoles.get(l.getId());
        if (null == r) {
            r = new DoubleFlagRole();
            linkRoles.put(l.getId(), r);
        }
        return r;
    }

    static class DoubleFlagRole {
        boolean forwardFlag = false;
        boolean backwardFlag = false;

        DoubleFlagRole() {
        }
    }
}

