/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.utils.geometry.CoordUtils;

public final class NetworkAdaptLength
implements NetworkRunnable {
    private static final double overLengthFactor = 1.001;
    private static final Logger log = Logger.getLogger(NetworkAdaptLength.class);

    @Override
    public void run(Network network) {
        log.info("running " + this.getClass().getName() + " module...");
        log.info("  adapting link length to at least 'overLengthFactor * euclidean distance' (works properly only for eucledian coord systems)");
        log.info("  also ceil link length to meters");
        log.info("  overLengthFactor: 1.001");
        for (Link link : network.getLinks().values()) {
            double dist = 1.001 * CoordUtils.calcEuclideanDistance(link.getFromNode().getCoord(), link.getToNode().getCoord());
            if (dist > link.getLength()) {
                link.setLength(dist);
            }
            double len = Math.ceil(link.getLength());
            link.setLength(len);
        }
        log.info("done.");
    }
}

