/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.internal.NetworkRunnable;

public final class NetworkCalcLanes
implements NetworkRunnable {
    @Override
    public void run(Network network) {
        double capDivider = network.getCapacityPeriod();
        for (Link link : network.getLinks().values()) {
            double capacity = link.getCapacity();
            double cap1h = capacity * 3600.0 / capDivider;
            int lanes = cap1h <= 1400.0 ? 1 : (cap1h <= 3000.0 ? 2 : (cap1h <= 6000.0 ? 3 : (cap1h <= 8500.0 ? 4 : 5)));
            link.setNumberOfLanes(lanes);
        }
    }
}

