/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.utils.misc.Counter;

public final class NetworkCalcTopoType
implements NetworkRunnable {
    private static final Logger log = Logger.getLogger(NetworkCalcTopoType.class);
    public static final Integer EMPTY = 0;
    public static final Integer SOURCE = 1;
    public static final Integer SINK = 2;
    public static final Integer DEADEND = 3;
    public static final Integer PASS1WAY = 4;
    public static final Integer PASS2WAY = 5;
    public static final Integer START1WAY = 6;
    public static final Integer END1WAY = 7;
    public static final Integer INTERSECTION = 8;
    private final Map<Node, Integer> topoTypePerNode = new IdentityHashMap<Node, Integer>(100000);

    @Override
    public void run(Network network) {
        log.info("    running " + this.getClass().getName() + " algorithm...");
        Counter ctr = new Counter("node #");
        for (Node node : network.getNodes().values()) {
            ctr.incCounter();
            int n = node.getInLinks().size();
            int nOfOutLinks = node.getOutLinks().size();
            if (n + nOfOutLinks == 0) {
                this.setTopoType(node, EMPTY);
                continue;
            }
            if (n == 0) {
                this.setTopoType(node, SOURCE);
                continue;
            }
            if (nOfOutLinks == 0) {
                this.setTopoType(node, SINK);
                continue;
            }
            if (this.getNOfIncidentNodes(node) == 1) {
                this.setTopoType(node, DEADEND);
                continue;
            }
            if (this.getNOfIncidentNodes(node) == 2) {
                if (nOfOutLinks == 1 && n == 1) {
                    this.setTopoType(node, PASS1WAY);
                    continue;
                }
                if (nOfOutLinks == 2 && n == 2) {
                    this.setTopoType(node, PASS2WAY);
                    continue;
                }
                if (nOfOutLinks == 2 && n == 1) {
                    this.setTopoType(node, START1WAY);
                    continue;
                }
                if (nOfOutLinks == 1 && n == 2) {
                    this.setTopoType(node, END1WAY);
                    continue;
                }
                if (nOfOutLinks >= 1 && n >= 1) {
                    this.setTopoType(node, INTERSECTION);
                    continue;
                }
                throw new RuntimeException("Node=" + node.toString() + " cannot be assigned to a topo type!");
            }
            this.setTopoType(node, INTERSECTION);
        }
        int[] cnt = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (Node node : network.getNodes().values()) {
            int n = this.getTopoType(node);
            cnt[n] = cnt[n] + 1;
        }
        log.info("      #nodes        = " + network.getNodes().size());
        log.info("      #EMTPY        = " + cnt[EMPTY]);
        log.info("      #SOURCE       = " + cnt[SOURCE]);
        log.info("      #SINK         = " + cnt[SINK]);
        log.info("      #DEADEND      = " + cnt[DEADEND]);
        log.info("      #PASS1WAY     = " + cnt[PASS1WAY]);
        log.info("      #PASS2WAY     = " + cnt[PASS2WAY]);
        log.info("      #START1WAY    = " + cnt[START1WAY]);
        log.info("      #END1WAY      = " + cnt[END1WAY]);
        log.info("      #INTERSECTION = " + cnt[INTERSECTION]);
        log.info("    done.");
    }

    private void setTopoType(Node node, Integer topoType) {
        this.topoTypePerNode.put(node, topoType);
    }

    public int getTopoType(Node node) {
        Integer i = this.topoTypePerNode.get(node);
        if (i == null) {
            return Integer.MIN_VALUE;
        }
        return i;
    }

    private int getNOfIncidentNodes(Node node) {
        HashMap nodes = new HashMap();
        for (Link link : node.getInLinks().values()) {
            nodes.put(link.getFromNode().getId(), link.getFromNode());
        }
        for (Link link : node.getOutLinks().values()) {
            nodes.put(link.getToNode().getId(), link.getToNode());
        }
        return nodes.size();
    }
}

