/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;

public final class NetworkCleaner
implements NetworkRunnable {
    private static final Logger log = Logger.getLogger(NetworkCleaner.class);

    private Map<Id<Node>, Node> findCluster(Node startNode, Network network) {
        Node node;
        Node currNode;
        int idx;
        HashMap<Node, DoubleFlagRole> nodeRoles = new HashMap<Node, DoubleFlagRole>(network.getNodes().size());
        ArrayList<Node> pendingForward = new ArrayList<Node>();
        ArrayList<Node> pendingBackward = new ArrayList<Node>();
        TreeMap<Id<Node>, Node> clusterNodes = new TreeMap<Id<Node>, Node>();
        clusterNodes.put(startNode.getId(), startNode);
        DoubleFlagRole r = NetworkCleaner.getDoubleFlag(startNode, nodeRoles);
        r.forwardFlag = true;
        r.backwardFlag = true;
        pendingForward.add(startNode);
        pendingBackward.add(startNode);
        while (pendingForward.size() > 0) {
            idx = pendingForward.size() - 1;
            currNode = (Node)pendingForward.remove(idx);
            for (Link link : currNode.getOutLinks().values()) {
                node = link.getToNode();
                r = NetworkCleaner.getDoubleFlag(node, nodeRoles);
                if (r.forwardFlag) continue;
                r.forwardFlag = true;
                pendingForward.add(node);
            }
        }
        while (pendingBackward.size() > 0) {
            idx = pendingBackward.size() - 1;
            currNode = (Node)pendingBackward.remove(idx);
            for (Link link : currNode.getInLinks().values()) {
                node = link.getFromNode();
                r = NetworkCleaner.getDoubleFlag(node, nodeRoles);
                if (r.backwardFlag) continue;
                r.backwardFlag = true;
                pendingBackward.add(node);
                if (!r.forwardFlag) continue;
                clusterNodes.put(node.getId(), node);
            }
        }
        return clusterNodes;
    }

    public Map<Id<Node>, Node> searchBiggestCluster(Network network) {
        TreeMap<Id<Node>, Node> visitedNodes = new TreeMap<Id<Node>, Node>();
        Map<Id<Node>, Node> biggestCluster = new TreeMap<Id<Node>, Node>();
        log.info("running " + this.getClass().getName() + " algorithm...");
        log.info("  checking " + network.getNodes().size() + " nodes and " + network.getLinks().size() + " links for dead-ends...");
        boolean stillSearching = true;
        Iterator<? extends Node> iter = network.getNodes().values().iterator();
        while (iter.hasNext() && stillSearching) {
            Node startNode = iter.next();
            if (visitedNodes.containsKey(startNode.getId())) continue;
            Map<Id<Node>, Node> cluster = this.findCluster(startNode, network);
            visitedNodes.putAll(cluster);
            if (cluster.size() <= biggestCluster.size() || (biggestCluster = cluster).size() < network.getNodes().size() - visitedNodes.size()) continue;
            stillSearching = false;
        }
        log.info("    The biggest cluster consists of " + biggestCluster.size() + " nodes.");
        log.info("  done.");
        return biggestCluster;
    }

    public static void reduceToBiggestCluster(Network network, Map<Id<Node>, Node> biggestCluster) {
        ArrayList<? extends Node> allNodes2 = new ArrayList<Node>(network.getNodes().values());
        for (Node node : allNodes2) {
            if (biggestCluster.containsKey(node.getId())) continue;
            network.removeNode(node.getId());
        }
        log.info("  resulting network contains " + network.getNodes().size() + " nodes and " + network.getLinks().size() + " links.");
        log.info("done.");
    }

    @Override
    public void run(Network network) {
        Map<Id<Node>, Node> biggestCluster = this.searchBiggestCluster(network);
        NetworkCleaner.reduceToBiggestCluster(network, biggestCluster);
    }

    private static DoubleFlagRole getDoubleFlag(Node n, Map<Node, DoubleFlagRole> nodeRoles) {
        DoubleFlagRole r = nodeRoles.get(n);
        if (null == r) {
            r = new DoubleFlagRole();
            nodeRoles.put(n, r);
        }
        return r;
    }

    static class DoubleFlagRole {
        boolean forwardFlag = false;
        boolean backwardFlag = false;

        DoubleFlagRole() {
        }
    }
}

