/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordUtils;

public final class NetworkExpandNode {
    private final Network network;
    private double expRadius = 1.0;
    private double offset = 0.0;
    private double dist = 1.0;

    public NetworkExpandNode(Network network, double expRadius, double offset) {
        if (network == null) {
            throw new IllegalArgumentException("network must not be null.");
        }
        this.network = network;
        this.setExpRadius(expRadius);
        this.setOffset(offset);
    }

    void setExpRadius(double expRadius) {
        if (Double.isNaN(expRadius)) {
            throw new IllegalArgumentException("expansion radius must not be NaN.");
        }
        this.expRadius = expRadius;
        this.dist = Math.sqrt(this.expRadius * this.expRadius - this.offset * this.offset);
    }

    void setOffset(double offset) {
        if (Double.isNaN(offset)) {
            throw new IllegalArgumentException("expansion offset must not be NaN.");
        }
        this.offset = offset;
        this.dist = Math.sqrt(this.expRadius * this.expRadius - this.offset * this.offset);
    }

    public final Tuple<List<Node>, List<Link>> expandNode(Id<Node> nodeId, List<TurnInfo> turns) {
        Link l;
        Node n;
        double y;
        double x;
        double dy;
        double dx;
        double lcp;
        Coord cp;
        Coord p;
        Coord c;
        double e = this.offset;
        Node node = this.network.getNodes().get(nodeId);
        if (node == null) {
            throw new IllegalArgumentException("nodeid=" + nodeId + ": not found in the network.");
        }
        if (turns == null) {
            throw new IllegalArgumentException("nodeid=" + nodeId + ": turn list not defined!");
        }
        for (TurnInfo turn1 : turns) {
            Id<Link> first = turn1.getFromLinkId();
            if (first == null) {
                throw new IllegalArgumentException("given list contains 'null' values.");
            }
            if (!node.getInLinks().containsKey(first)) {
                throw new IllegalArgumentException("nodeid=" + nodeId + ", linkid=" + first + ": link not an inlink of given node.");
            }
            Id<Link> second = turn1.getToLinkId();
            if (second == null) {
                throw new IllegalArgumentException("given list contains 'null' values.");
            }
            if (node.getOutLinks().containsKey(second)) continue;
            throw new IllegalArgumentException("nodeid=" + nodeId + ", linkid=" + second + ": link not an outlink of given node.");
        }
        TreeMap<Id<Link>, ? extends Link> inlinks = new TreeMap<Id<Link>, Link>(node.getInLinks());
        TreeMap<Id<Link>, ? extends Link> outlinks = new TreeMap<Id<Link>, Link>(node.getOutLinks());
        if (this.network.removeNode(node.getId()) == null) {
            throw new RuntimeException("nodeid=" + nodeId + ": Failed to remove node from the network.");
        }
        ArrayList<Node> newNodes = new ArrayList<Node>(inlinks.size() + outlinks.size());
        ArrayList<Link> newLinks = new ArrayList<Link>(turns.size());
        int nodeIdCnt = 0;
        double d = this.dist;
        for (Link inlink : inlinks.values()) {
            c = node.getCoord();
            p = inlink.getFromNode().getCoord();
            cp = new Coord(p.getX() - c.getX(), p.getY() - c.getY());
            lcp = Math.sqrt(cp.getX() * cp.getX() + cp.getY() * cp.getY());
            if (Math.abs(lcp) < 1.0E-8) {
                lcp = d;
            }
            dx = cp.getX() / lcp;
            dy = cp.getY() / lcp;
            x = c.getX() + d * dx - e * dy;
            y = c.getY() + d * dy + e * dx;
            n = this.network.getFactory().createNode(Id.create(node.getId() + "-" + nodeIdCnt, Node.class), new Coord(x, y));
            this.network.addNode(n);
            newNodes.add(n);
            ++nodeIdCnt;
            l = this.network.getFactory().createLink(inlink.getId(), inlink.getFromNode(), n);
            l.setLength(inlink.getLength());
            l.setFreespeed(inlink.getFreespeed());
            l.setCapacity(inlink.getCapacity());
            l.setNumberOfLanes(inlink.getNumberOfLanes());
            l.setAllowedModes(inlink.getAllowedModes());
            NetworkUtils.setOrigId(l, NetworkUtils.getOrigId(inlink));
            NetworkUtils.setType(l, NetworkUtils.getType(inlink));
            this.network.addLink(l);
        }
        for (Link outlink : outlinks.values()) {
            c = node.getCoord();
            p = outlink.getToNode().getCoord();
            cp = new Coord(p.getX() - c.getX(), p.getY() - c.getY());
            lcp = Math.sqrt(cp.getX() * cp.getX() + cp.getY() * cp.getY());
            if (Math.abs(lcp) < 1.0E-8) {
                lcp = d;
            }
            dx = cp.getX() / lcp;
            dy = cp.getY() / lcp;
            x = c.getX() + d * dx + e * dy;
            y = c.getY() + d * dy - e * dx;
            n = this.network.getFactory().createNode(Id.create(node.getId() + "-" + nodeIdCnt, Node.class), new Coord(x, y));
            this.network.addNode(n);
            newNodes.add(n);
            ++nodeIdCnt;
            l = this.network.getFactory().createLink(outlink.getId(), n, outlink.getToNode());
            l.setLength(outlink.getLength());
            l.setFreespeed(outlink.getFreespeed());
            l.setCapacity(outlink.getCapacity());
            l.setNumberOfLanes(outlink.getNumberOfLanes());
            l.setAllowedModes(outlink.getAllowedModes());
            NetworkUtils.setOrigId(l, NetworkUtils.getOrigId(outlink));
            NetworkUtils.setType(l, NetworkUtils.getType(outlink));
            this.network.addLink(l);
        }
        for (int i = 0; i < turns.size(); ++i) {
            TurnInfo turn = turns.get(i);
            Link fromLink = this.network.getLinks().get(turn.getFromLinkId());
            Link toLink = this.network.getLinks().get(turn.getToLinkId());
            Link l2 = this.network.getFactory().createLink(Id.create(fromLink.getId() + "-" + i, Link.class), fromLink.getToNode(), toLink.getFromNode());
            double dist = CoordUtils.calcEuclideanDistance(toLink.getFromNode().getCoord(), fromLink.getToNode().getCoord());
            if (dist < 0.1 * this.expRadius) {
                dist = 0.1 * this.expRadius;
            }
            l2.setLength(dist);
            l2.setFreespeed(fromLink.getFreespeed());
            l2.setCapacity(fromLink.getCapacity());
            l2.setNumberOfLanes(fromLink.getNumberOfLanes());
            if (turn.getModes() == null) {
                l2.setAllowedModes(fromLink.getAllowedModes());
            } else {
                l2.setAllowedModes(turn.getModes());
            }
            NetworkUtils.setOrigId(l2, NetworkUtils.getOrigId(fromLink));
            NetworkUtils.setType(l2, NetworkUtils.getType(fromLink));
            this.network.addLink(l2);
            newLinks.add(l2);
        }
        return new Tuple<List<Node>, List<Link>>(newNodes, newLinks);
    }

    public boolean turnsAreSameAsSingleNode(Id<Node> nodeId, List<TurnInfo> turns, boolean ignoreUTurns) {
        HashSet<String> modes;
        Node node = this.network.getNodes().get(nodeId);
        HashMap allTurns = new HashMap();
        for (Link link : node.getInLinks().values()) {
            HashMap t2 = new HashMap();
            for (Link link2 : node.getOutLinks().values()) {
                if (link.getFromNode() == link2.getToNode() && ignoreUTurns) continue;
                modes = new HashSet<String>();
                modes.addAll(link.getAllowedModes());
                modes.retainAll(link2.getAllowedModes());
                t2.put(link2.getId(), modes);
            }
            allTurns.put(link.getId(), t2);
        }
        for (TurnInfo turnInfo : turns) {
            Id from = turnInfo.fromLinkId;
            Id to = turnInfo.toLinkId;
            Map map = (Map)allTurns.get(from);
            if (map == null || (modes = (HashSet<String>)map.get(to)) == null) continue;
            if (turnInfo.getModes() == null) {
                modes.clear();
                continue;
            }
            modes.removeAll(turnInfo.getModes());
        }
        for (Map map : allTurns.values()) {
            for (Set modes2 : map.values()) {
                if (modes2.size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static class TurnInfo {
        private final Id<Link> fromLinkId;
        private final Id<Link> toLinkId;
        private final Set<String> modes;

        public TurnInfo(Id<Link> fromLinkId, Id<Link> toLinkId) {
            this.fromLinkId = fromLinkId;
            this.toLinkId = toLinkId;
            this.modes = null;
        }

        public TurnInfo(Id<Link> fromLinkId, Id<Link> toLinkId, Set<String> modes) {
            this.fromLinkId = fromLinkId;
            this.toLinkId = toLinkId;
            this.modes = modes;
        }

        public Id<Link> getFromLinkId() {
            return this.fromLinkId;
        }

        public Id<Link> getToLinkId() {
            return this.toLinkId;
        }

        public Set<String> getModes() {
            return this.modes;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TurnInfo)) {
                return false;
            }
            TurnInfo ti = (TurnInfo)obj;
            return ti.fromLinkId.equals(this.fromLinkId) && ti.toLinkId.equals(this.toLinkId) && (ti.modes == null && this.modes == null || ti.modes != null && ti.modes.equals(this.modes));
        }

        public int hashCode() {
            return this.fromLinkId.hashCode() & this.toLinkId.hashCode() & this.modes.hashCode();
        }
    }
}

