/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.utils.geometry.CoordUtils;

public final class NetworkFalsifier
implements NetworkRunnable {
    private final double distance;

    public NetworkFalsifier(double distance) {
        this.distance = distance;
    }

    @Override
    public void run(Network network) {
        double maxDistance = this.distance * 2.0;
        for (Node node : network.getNodes().values()) {
            Coord coord = node.getCoord();
            node.setCoord(new Coord(coord.getX() + (MatsimRandom.getRandom().nextDouble() - 0.5) * maxDistance, coord.getY() + (MatsimRandom.getRandom().nextDouble() - 0.5) * maxDistance));
        }
        for (Link link : network.getLinks().values()) {
            Coord fromCoord = link.getFromNode().getCoord();
            Coord toCoord = link.getToNode().getCoord();
            link.setLength(CoordUtils.calcEuclideanDistance(fromCoord, toCoord));
        }
    }
}

