/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.NetworkExpandNode;
import org.matsim.core.network.algorithms.NetworkTurnInfoBuilder;

public final class NetworkInverter {
    private static final Logger log = Logger.getLogger(NetworkInverter.class);
    private Network originalNetwork;
    private Network invertedNetwork = null;
    private Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> inLinkTurnInfoMap = null;

    public NetworkInverter(Network originalNet, Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> inLinkTurnInfoMap) {
        this.originalNetwork = originalNet;
        this.inLinkTurnInfoMap = inLinkTurnInfoMap;
    }

    public Network getInvertedNetwork() {
        if (this.invertedNetwork == null) {
            this.invertNetwork();
        }
        return this.invertedNetwork;
    }

    private void invertNetwork() {
        this.invertedNetwork = NetworkUtils.createNetwork();
        int numberOfNodesGenerated = 0;
        int numberOfLinksGenerated = 0;
        for (Link link : this.originalNetwork.getLinks().values()) {
            NetworkUtils.createAndAddNode(this.invertedNetwork, Id.create(link.getId(), Node.class), link.getToNode().getCoord());
            ++numberOfNodesGenerated;
        }
        for (Node node : this.originalNetwork.getNodes().values()) {
            for (Link link : node.getInLinks().values()) {
                for (Link link2 : node.getOutLinks().values()) {
                    List<NetworkExpandNode.TurnInfo> turnInfos = this.inLinkTurnInfoMap.get(link.getId());
                    NetworkExpandNode.TurnInfo ti = NetworkTurnInfoBuilder.getTurnInfoForOutlinkId(turnInfos, link2.getId());
                    if (ti == null) continue;
                    numberOfLinksGenerated = this.createInvertedLink(link, link2, numberOfLinksGenerated, ti.getModes());
                }
            }
        }
        log.info("Generated " + numberOfNodesGenerated + " Nodes and " + numberOfLinksGenerated + " Links");
    }

    private int createInvertedLink(Link inLink, Link outLink, int numberOfLinksGenerated, Set<String> modes) {
        Link link = NetworkUtils.createAndAddLink(this.invertedNetwork, Id.create(numberOfLinksGenerated + 1, Link.class), this.invertedNetwork.getNodes().get(Id.create(inLink.getId(), Node.class)), this.invertedNetwork.getNodes().get(Id.create(outLink.getId(), Node.class)), outLink.getLength(), outLink.getFreespeed(), outLink.getCapacity(), outLink.getNumberOfLanes());
        link.setAllowedModes(modes);
        NetworkUtils.setType(link, NetworkUtils.getType(outLink));
        return numberOfLinksGenerated + 1;
    }

    public List<Link> convertInvertedNodesToLinks(List<Node> nodes) {
        ArrayList<Link> ret = new ArrayList<Link>(nodes.size());
        for (Node n : nodes) {
            ret.add(this.originalNetwork.getLinks().get(Id.create(n.getId(), Link.class)));
        }
        return ret;
    }
}

