/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.misc.Time;

public final class NetworkMergeDoubleLinks
implements NetworkRunnable {
    private static final Logger log = Logger.getLogger(NetworkMergeDoubleLinks.class);
    private final MergeType mergetype;
    private final LogInfoLevel logInfoLevel;

    public NetworkMergeDoubleLinks() {
        this(MergeType.MAXIMUM, LogInfoLevel.MAXIMUM);
    }

    public NetworkMergeDoubleLinks(MergeType mergetype) {
        this(mergetype, LogInfoLevel.MAXIMUM);
    }

    public NetworkMergeDoubleLinks(MergeType mergetype, LogInfoLevel logInfoLevel) {
        this.mergetype = mergetype;
        this.logInfoLevel = logInfoLevel;
    }

    private void mergeLink2IntoLink1(Link link1, Link link2, Network network) {
        switch (this.mergetype) {
            case REMOVE: {
                if (this.logInfoLevel.equals((Object)LogInfoLevel.MAXIMUM)) {
                    log.info("        Link id=" + link2.getId() + " removed because of Link id=" + link1.getId());
                }
                network.removeLink(link2.getId());
                break;
            }
            case ADDITIVE: {
                if (this.logInfoLevel.equals((Object)LogInfoLevel.MAXIMUM)) {
                    log.info("        Link id=" + link2.getId() + " merged (additive) into Link id=" + link1.getId());
                }
                double cap = link1.getCapacity() + link2.getCapacity();
                double fs = Math.max(link1.getFreespeed(), link2.getFreespeed());
                int lanes = NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), link1) + NetworkUtils.getNumberOfLanesAsInt(Double.NEGATIVE_INFINITY, link2);
                double length = Math.max(link1.getLength(), link2.getLength());
                link1.setCapacity(cap);
                link1.setFreespeed(fs);
                link1.setNumberOfLanes(lanes);
                link1.setLength(length);
                network.removeLink(link2.getId());
                break;
            }
            case MAXIMUM: {
                if (this.logInfoLevel.equals((Object)LogInfoLevel.MAXIMUM)) {
                    log.info("        Link id=" + link2.getId() + " merged (maximum) into Link id=" + link1.getId());
                }
                double cap = Math.max(link1.getCapacity(), link2.getCapacity());
                double fs = Math.max(link1.getFreespeed(), link2.getFreespeed());
                int lanes = Math.max(NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), link1), NetworkUtils.getNumberOfLanesAsInt(Double.NEGATIVE_INFINITY, link2));
                double length = Math.max(link1.getLength(), link2.getLength());
                link1.setCapacity(cap);
                link1.setFreespeed(fs);
                link1.setNumberOfLanes(lanes);
                link1.setLength(length);
                network.removeLink(link2.getId());
                break;
            }
            default: {
                throw new IllegalArgumentException("'mergetype' not known!");
            }
        }
    }

    @Override
    public void run(Network network) {
        for (Node node : network.getNodes().values()) {
            Iterator<? extends Link> l1_it = node.getOutLinks().values().iterator();
            while (l1_it.hasNext()) {
                Link l1 = l1_it.next();
                Iterator<? extends Link> l2_it = node.getOutLinks().values().iterator();
                while (l2_it.hasNext()) {
                    Link l2 = l2_it.next();
                    if (l2.equals(l1) || !l2.getToNode().equals(l1.getToNode())) continue;
                    if (this.logInfoLevel.equals((Object)LogInfoLevel.MAXIMUM)) {
                        log.info("      Node id=" + node.getId());
                    }
                    this.mergeLink2IntoLink1(l1, l2, network);
                    l1_it = node.getOutLinks().values().iterator();
                    l2_it = node.getOutLinks().values().iterator();
                }
            }
        }
    }

    public static enum LogInfoLevel {
        NOINFO,
        MAXIMUM;

    }

    public static enum MergeType {
        REMOVE,
        ADDITIVE,
        MAXIMUM;

    }
}

