/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.utils.geometry.CoordUtils;

public final class NetworkScenarioCut
implements NetworkRunnable {
    private final CutType cutType;
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final double radius;
    private final Coord center;
    private static final Logger log = Logger.getLogger(NetworkScenarioCut.class);

    public NetworkScenarioCut(Coord min2, Coord max) {
        this.cutType = CutType.RECTANGLE;
        this.minX = min2.getX();
        this.maxX = max.getX();
        this.minY = min2.getY();
        this.maxY = max.getY();
        this.radius = Double.MAX_VALUE;
        this.center = null;
    }

    public NetworkScenarioCut(Coord center, double radius) {
        this.cutType = CutType.CIRCLE;
        this.center = center;
        this.radius = radius;
        this.minX = Double.MIN_VALUE;
        this.maxX = Double.MAX_VALUE;
        this.minY = Double.MIN_VALUE;
        this.maxY = Double.MAX_VALUE;
    }

    @Override
    public void run(Network network) {
        Set<Node> nodesToRemove;
        if (this.cutType == CutType.RECTANGLE) {
            nodesToRemove = this.rectangularCut(network);
        } else if (this.cutType == CutType.CIRCLE) {
            nodesToRemove = this.circularCut(network);
        } else {
            return;
        }
        int nofLinksRemoved = 0;
        for (Node n : nodesToRemove) {
            nofLinksRemoved += n.getInLinks().size() + n.getOutLinks().size();
            network.removeNode(n.getId());
        }
        log.info("number of nodes removed: " + nodesToRemove.size());
        log.info("number of links removed: " + nofLinksRemoved);
        log.info("number of nodes remaining: " + network.getNodes().size());
        log.info("number of links remaining: " + network.getLinks().size());
    }

    private Set<Node> rectangularCut(Network network) {
        HashSet<Node> nodesToRemove = new HashSet<Node>();
        for (Node node : network.getNodes().values()) {
            Coord coord = node.getCoord();
            double x = coord.getX();
            double y = coord.getY();
            if (x < this.maxX && this.minX < x && y < this.maxY && this.minY < y) continue;
            nodesToRemove.add(node);
        }
        return nodesToRemove;
    }

    private Set<Node> circularCut(Network network) {
        HashSet<Node> nodesToRemove = new HashSet<Node>();
        for (Node node : network.getNodes().values()) {
            Coord coord = node.getCoord();
            double distance = CoordUtils.calcEuclideanDistance(coord, this.center);
            if (!(distance > this.radius)) continue;
            nodesToRemove.add(node);
        }
        return nodesToRemove;
    }

    private static enum CutType {
        RECTANGLE,
        CIRCLE;

    }
}

