/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;

public final class NetworkSegmentDoubleLinks
implements NetworkRunnable {
    private static final Logger log = Logger.getLogger(NetworkSegmentDoubleLinks.class);
    private Network network = null;
    private int dblLinks = 0;
    private int trblLinks = 0;
    private int qtblLinks = 0;
    private int ntblLinks = 0;

    @Override
    public void run(Network network) {
        this.network = network;
        log.info("    running " + this.getClass().getName() + " algorithm...");
        LinkedList<? extends Node> nodes = new LinkedList<Node>(network.getNodes().values());
        while (nodes.peek() != null) {
            Node n = (Node)nodes.poll();
            HashMap<Id<Node>, List<Link>> toNodesMap = new HashMap<Id<Node>, List<Link>>();
            for (Link link : n.getOutLinks().values()) {
                List<Link> links = toNodesMap.get(link.getToNode().getId());
                if (links != null) {
                    links.add(link);
                    continue;
                }
                links = new ArrayList<Link>();
                links.add(link);
                toNodesMap.put(link.getToNode().getId(), links);
            }
            if (toNodesMap.size() <= 0) continue;
            this.handleDblLinks(toNodesMap);
        }
        log.info("handled: ");
        log.info("\t" + this.dblLinks + " dblLinks.");
        log.info("\t" + this.trblLinks + " trblLinks.");
        log.info("\t" + this.qtblLinks + " qtblLinks.");
        log.info("\t" + this.ntblLinks + " ntblLinks.");
        log.info("done.");
    }

    private void handleDblLinks(HashMap<Id<Node>, List<Link>> toNodesMap) {
        for (List<Link> vec : toNodesMap.values()) {
            switch (vec.size()) {
                case 1: {
                    break;
                }
                case 2: {
                    ++this.dblLinks;
                    break;
                }
                case 3: {
                    ++this.trblLinks;
                    break;
                }
                case 4: {
                    ++this.qtblLinks;
                    break;
                }
                default: {
                    ++this.ntblLinks;
                }
            }
            for (int i = 1; i < vec.size(); ++i) {
                this.splitLink(vec.get(i));
            }
        }
    }

    private void splitLink(Link link) {
        this.network.removeLink(link.getId());
        double length = link.getLength() / 2.0;
        double freespeed = link.getFreespeed();
        double capacity = link.getCapacity();
        double permlanes = link.getNumberOfLanes();
        Node medianNode = this.network.getFactory().createNode(this.getNewNodeId(), link.getCoord());
        this.network.addNode(medianNode);
        Link tmpLink = this.network.getFactory().createLink(link.getId(), link.getFromNode(), medianNode);
        tmpLink.setLength(length);
        tmpLink.setFreespeed(freespeed);
        tmpLink.setCapacity(capacity);
        tmpLink.setNumberOfLanes(permlanes);
        this.network.addLink(tmpLink);
        tmpLink = this.network.getFactory().createLink(this.getNewLinkId(), medianNode, link.getToNode());
        tmpLink.setLength(length);
        tmpLink.setFreespeed(freespeed);
        tmpLink.setCapacity(capacity);
        tmpLink.setNumberOfLanes(permlanes);
        this.network.addLink(tmpLink);
    }

    private Id<Link> getNewLinkId() {
        Random r = new Random();
        Id<Link> id = Id.create(r.nextInt(Integer.MAX_VALUE), Link.class);
        while (this.network.getLinks().get(id) != null) {
            id = Id.create(r.nextInt(Integer.MAX_VALUE), Link.class);
        }
        return id;
    }

    private Id<Node> getNewNodeId() {
        Random r = new Random();
        Id<Node> id = Id.create(r.nextInt(Integer.MAX_VALUE), Node.class);
        while (this.network.getNodes().get(id) != null) {
            id = Id.create(r.nextInt(Integer.MAX_VALUE), Node.class);
        }
        return id;
    }
}

