/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.NetworkCalcTopoType;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.network.io.NetworkWriter;
import org.matsim.core.scenario.ScenarioUtils;

public final class NetworkSimplifier {
    private static final Logger log = Logger.getLogger(NetworkSimplifier.class);
    private boolean mergeLinksWithDifferentAttributes = false;
    private Collection<Integer> nodeTopoToMerge = Arrays.asList(NetworkCalcTopoType.PASS1WAY, NetworkCalcTopoType.PASS2WAY);
    private Set<Id<Node>> nodesNotToMerge = new HashSet<Id<Node>>();
    private final Map<Id<Link>, List<Node>> mergedLinksToIntermediateNodes = new HashMap<Id<Link>, List<Node>>();

    public void run(Network network) {
        this.run(network, Double.POSITIVE_INFINITY, ThresholdExceeded.EITHER);
    }

    @Deprecated
    public void run(Network network, double thresholdLength) {
        this.run(network, thresholdLength, ThresholdExceeded.BOTH);
        this.run(network, thresholdLength, ThresholdExceeded.EITHER);
    }

    public void setNodesNotToMerge(Set<Long> nodeIDs) {
        for (Long l : nodeIDs) {
            this.nodesNotToMerge.add(Id.createNodeId(l));
        }
    }

    private void run(Network network, double thresholdLength, ThresholdExceeded type) {
        if (this.nodeTopoToMerge.size() == 0) {
            throw new RuntimeException("No types of node specified. Please use setNodesToMerge to specify which nodes should be merged");
        }
        log.info("running " + this.getClass().getName() + " algorithm...");
        NetworkCalcTopoType nodeTopo = new NetworkCalcTopoType();
        nodeTopo.run(network);
        for (Node node : network.getNodes().values()) {
            if (!this.nodeTopoToMerge.contains(nodeTopo.getTopoType(node)) || this.nodesNotToMerge.contains(node.getId())) continue;
            ArrayList<? extends Link> iLinks = new ArrayList<Link>(node.getInLinks().values());
            Iterator iterator = iLinks.iterator();
            while (iterator.hasNext()) {
                Link iL;
                Link inLink = iL = (Link)iterator.next();
                ArrayList<? extends Link> oLinks = new ArrayList<Link>(node.getOutLinks().values());
                Iterator iterator2 = oLinks.iterator();
                while (iterator2.hasNext()) {
                    Link oL;
                    Link outLink = oL = (Link)iterator2.next();
                    if (inLink == null || outLink == null || !this.areLinksMergeable(inLink, outLink)) continue;
                    if (this.mergeLinksWithDifferentAttributes) {
                        boolean criteria = false;
                        switch (type) {
                            case BOTH: {
                                criteria = this.bothLinksAreShorterThanThreshold(inLink, outLink, thresholdLength);
                                break;
                            }
                            case EITHER: {
                                criteria = this.eitherLinkIsShorterThanThreshold(inLink, outLink, thresholdLength);
                                break;
                            }
                        }
                        if (!criteria) continue;
                        Link link = network.getFactory().createLink(Id.create(inLink.getId() + "-" + outLink.getId(), Link.class), inLink.getFromNode(), outLink.getToNode());
                        link.setLength(inLink.getLength() + outLink.getLength());
                        link.setFreespeed((inLink.getLength() + outLink.getLength()) / (NetworkUtils.getFreespeedTravelTime(inLink) + NetworkUtils.getFreespeedTravelTime(outLink)));
                        link.setCapacity(Math.min(inLink.getCapacity(), outLink.getCapacity()));
                        link.setNumberOfLanes((inLink.getLength() * inLink.getNumberOfLanes() + outLink.getLength() * outLink.getNumberOfLanes()) / (inLink.getLength() + outLink.getLength()));
                        network.addLink(link);
                        network.removeLink(inLink.getId());
                        network.removeLink(outLink.getId());
                        this.collectMergedLinkNodeInfo(inLink, outLink, link.getId());
                        continue;
                    }
                    if (!this.bothLinksHaveSameLinkStats(inLink, outLink)) continue;
                    boolean isHavingShortLinks = false;
                    switch (type) {
                        case BOTH: {
                            isHavingShortLinks = this.bothLinksAreShorterThanThreshold(inLink, outLink, thresholdLength);
                            break;
                        }
                        case EITHER: {
                            isHavingShortLinks = this.eitherLinkIsShorterThanThreshold(inLink, outLink, thresholdLength);
                            break;
                        }
                    }
                    if (!isHavingShortLinks) continue;
                    Link newLink = NetworkUtils.createAndAddLink(network, Id.create(inLink.getId() + "-" + outLink.getId(), Link.class), inLink.getFromNode(), outLink.getToNode(), inLink.getLength() + outLink.getLength(), inLink.getFreespeed(), inLink.getCapacity(), inLink.getNumberOfLanes(), NetworkUtils.getOrigId(inLink) + "-" + NetworkUtils.getOrigId(outLink), null);
                    newLink.setAllowedModes(inLink.getAllowedModes());
                    network.removeLink(inLink.getId());
                    network.removeLink(outLink.getId());
                    this.collectMergedLinkNodeInfo(inLink, outLink, newLink.getId());
                }
            }
        }
        log.info("  resulting network contains " + network.getNodes().size() + " nodes and " + network.getLinks().size() + " links.");
        log.info("done.");
        nodeTopo = new NetworkCalcTopoType();
        nodeTopo.run(network);
    }

    private boolean areLinksMergeable(Link inLink, Link outLink) {
        List<Node> fromNodes = this.mergedLinksToIntermediateNodes.get(inLink.getId());
        if (fromNodes == null) {
            fromNodes = new ArrayList<Node>();
        }
        fromNodes.add(inLink.getFromNode());
        List<Node> toNodes = this.mergedLinksToIntermediateNodes.get(outLink.getId());
        if (toNodes == null) {
            toNodes = new ArrayList<Node>();
        }
        toNodes.add(outLink.getToNode());
        for (Node n : fromNodes) {
            if (!toNodes.contains(n)) continue;
            return false;
        }
        return true;
    }

    private void collectMergedLinkNodeInfo(Link inLink, Link outLink, Id<Link> mergedLinkId) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (this.mergedLinksToIntermediateNodes.containsKey(inLink.getId())) {
            nodes.addAll((Collection)this.mergedLinksToIntermediateNodes.remove(inLink.getId()));
        }
        if (this.mergedLinksToIntermediateNodes.containsKey(outLink.getId())) {
            nodes.addAll((Collection)this.mergedLinksToIntermediateNodes.remove(outLink.getId()));
        }
        nodes.add(inLink.getToNode());
        this.mergedLinksToIntermediateNodes.put(mergedLinkId, nodes);
    }

    public void setNodesToMerge(Set<Integer> nodeTypesToMerge) {
        this.nodeTopoToMerge.addAll(nodeTypesToMerge);
    }

    public void setMergeLinkStats(boolean mergeLinksWithDifferentAttributes) {
        this.mergeLinksWithDifferentAttributes = mergeLinksWithDifferentAttributes;
    }

    private boolean bothLinksAreShorterThanThreshold(Link linkA, Link linkB, double thresholdLength) {
        boolean hasTwoShortLinks = false;
        if (linkA.getLength() < thresholdLength && linkB.getLength() < thresholdLength) {
            hasTwoShortLinks = true;
        }
        return hasTwoShortLinks;
    }

    private boolean eitherLinkIsShorterThanThreshold(Link linkA, Link linkB, double thresholdLength) {
        boolean hasShortLink = false;
        if (linkA.getLength() < thresholdLength || linkB.getLength() < thresholdLength) {
            hasShortLink = true;
        }
        return hasShortLink;
    }

    private boolean bothLinksHaveSameLinkStats(Link linkA, Link linkB) {
        boolean bothLinksHaveSameLinkStats = true;
        if (!linkA.getAllowedModes().equals(linkB.getAllowedModes())) {
            bothLinksHaveSameLinkStats = false;
        }
        if (linkA.getFreespeed() != linkB.getFreespeed()) {
            bothLinksHaveSameLinkStats = false;
        }
        if (linkA.getCapacity() != linkB.getCapacity()) {
            bothLinksHaveSameLinkStats = false;
        }
        if (linkA.getNumberOfLanes() != linkB.getNumberOfLanes()) {
            bothLinksHaveSameLinkStats = false;
        }
        return bothLinksHaveSameLinkStats;
    }

    public static void main(String[] args) {
        String inNetworkFile = args[0];
        String outNetworkFile = args[1];
        TreeSet<Integer> nodeTypesToMerge = new TreeSet<Integer>();
        nodeTypesToMerge.add(4);
        nodeTypesToMerge.add(5);
        Scenario scenario = ScenarioUtils.createScenario(ConfigUtils.createConfig());
        Network network = scenario.getNetwork();
        new MatsimNetworkReader(scenario.getNetwork()).readFile(inNetworkFile);
        NetworkSimplifier nsimply = new NetworkSimplifier();
        nsimply.setNodesToMerge(nodeTypesToMerge);
        nsimply.run(network, Double.NEGATIVE_INFINITY);
        new NetworkWriter(network).write(outNetworkFile);
    }

    private static enum ThresholdExceeded {
        EITHER,
        BOTH;

    }
}

