/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.network.algorithms.NetworkExpandNode;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.gis.ShapeFileReader;
import org.matsim.core.utils.io.IOUtils;
import org.opengis.feature.simple.SimpleFeature;

public final class NetworkTeleatlasAddManeuverRestrictions
implements NetworkRunnable {
    private static final Logger log = Logger.getLogger(NetworkTeleatlasAddManeuverRestrictions.class);
    private final String mnShpFileName;
    private final String mpDbfFileName;
    public boolean removeUTurns = false;
    public double expansionRadius = 3.0E-5;
    public double linkSeparation = 5.0E-6;
    private static final String MN_ID_NAME = "ID";
    private static final String MN_FEATTYP_NAME = "FEATTYP";
    private static final String MN_JNCTID_NAME = "JNCTID";
    private static final String MP_ID_NAME = "ID";
    private static final String MP_SEQNR_NAME = "SEQNR";
    private static final String MP_TRPELID_NAME = "TRPELID";

    public NetworkTeleatlasAddManeuverRestrictions(String mnShpFileName, String mpDbfFileName) {
        log.info("init " + this.getClass().getName() + " module...");
        this.mnShpFileName = mnShpFileName;
        this.mpDbfFileName = mpDbfFileName;
        log.info("done.");
    }

    @Override
    public void run(Network network) {
        try {
            this.run2(network);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void run2(Network network) throws Exception {
        log.info("running " + this.getClass().getName() + " module...");
        NetworkExpandNode neModule = new NetworkExpandNode(network, this.expansionRadius, this.linkSeparation);
        TreeMap<String, TreeMap<Integer, Id<Link>>> mSequences = new TreeMap<String, TreeMap<Integer, Id<Link>>>();
        try (FileInputStream fis = new FileInputStream(this.mpDbfFileName);){
            DbaseFileReader r = new DbaseFileReader(fis.getChannel(), true, IOUtils.CHARSET_WINDOWS_ISO88591);
            int mpIdNameIndex = -1;
            int mpSeqNrNameIndex = -1;
            int mpTrpelIDNameIndex = -1;
            for (int i = 0; i < r.getHeader().getNumFields(); ++i) {
                if (r.getHeader().getFieldName(i).equals("ID")) {
                    mpIdNameIndex = i;
                }
                if (r.getHeader().getFieldName(i).equals(MP_SEQNR_NAME)) {
                    mpSeqNrNameIndex = i;
                }
                if (!r.getHeader().getFieldName(i).equals(MP_TRPELID_NAME)) continue;
                mpTrpelIDNameIndex = i;
            }
            if (mpIdNameIndex < 0) {
                throw new NoSuchFieldException("Field name 'ID' not found.");
            }
            if (mpSeqNrNameIndex < 0) {
                throw new NoSuchFieldException("Field name 'SEQNR' not found.");
            }
            if (mpTrpelIDNameIndex < 0) {
                throw new NoSuchFieldException("Field name 'TRPELID' not found.");
            }
            log.trace("  FieldName-->Index:");
            log.trace("    ID-->" + mpIdNameIndex);
            log.trace("    SEQNR-->" + mpSeqNrNameIndex);
            log.trace("    TRPELID-->" + mpTrpelIDNameIndex);
            log.info("  parsing meneuver paths dbf file...");
            while (r.hasNext()) {
                Object[] entries = r.readEntry();
                String mpId = entries[mpIdNameIndex].toString();
                int mpSeqNr = Integer.parseInt(entries[mpSeqNrNameIndex].toString());
                Id<Link> linkId = Id.create(entries[mpTrpelIDNameIndex].toString(), Link.class);
                TreeMap<Integer, Id<Link>> mSequence = (TreeMap<Integer, Id<Link>>)mSequences.get(mpId);
                if (mSequence == null) {
                    mSequence = new TreeMap<Integer, Id<Link>>();
                    mSequences.put(mpId, mSequence);
                }
                if (mSequence.put(mpSeqNr, linkId) == null) continue;
                fis.close();
                throw new IllegalArgumentException("ID=" + mpId + ": " + MP_SEQNR_NAME + " " + mpSeqNr + " already exists.");
            }
            log.info("    " + mSequences.size() + " maneuvers sequences stored.");
            log.info("  done.");
            r.close();
        }
        log.info("  parsing meneuver shape file...");
        TreeMap maneuvers = new TreeMap();
        SimpleFeatureSource fs = ShapeFileReader.readDataFile(this.mnShpFileName);
        SimpleFeatureIterator fIt = fs.getFeatures().features();
        while (fIt.hasNext()) {
            SimpleFeature f = (SimpleFeature)fIt.next();
            int featType = Integer.parseInt(f.getAttribute(MN_FEATTYP_NAME).toString());
            if (featType == 2103 || featType == 2102 || featType == 2101) {
                Id<Node> nodeId = Id.create(f.getAttribute(MN_JNCTID_NAME).toString(), Node.class);
                ArrayList<Tuple<String, Integer>> ms = (ArrayList<Tuple<String, Integer>>)maneuvers.get(nodeId);
                if (ms == null) {
                    ms = new ArrayList<Tuple<String, Integer>>();
                }
                Tuple<String, Integer> m3 = new Tuple<String, Integer>(f.getAttribute("ID").toString(), featType);
                ms.add(m3);
                maneuvers.put(nodeId, ms);
                continue;
            }
            if (featType == 9401 || featType == 2104) continue;
            throw new IllegalArgumentException("mnId=" + f.getAttribute("ID") + ": " + MN_FEATTYP_NAME + "=" + featType + " not known.");
        }
        fIt.close();
        log.info("    " + maneuvers.size() + " nodes with maneuvers stored.");
        log.info("  done.");
        log.info("  expand nodes according to the given manveuvers...");
        int nodesIgnoredCnt = 0;
        int nodesAssignedCnt = 0;
        int maneuverIgnoredCnt = 0;
        int maneuverAssignedCnt = 0;
        int virtualNodesCnt = 0;
        int virtualLinksCnt = 0;
        for (Map.Entry entry : maneuvers.entrySet()) {
            Id nodeId = (Id)entry.getKey();
            if (network.getNodes().get(nodeId) == null) {
                log.trace("  nodeid=" + nodeId + ": maneuvers exist for that node but node is missing. Ignoring and proceeding anyway...");
                ++nodesIgnoredCnt;
                continue;
            }
            Node n = network.getNodes().get(nodeId);
            TreeMap mmatrix = new TreeMap();
            ArrayList ms = (ArrayList)entry.getValue();
            for (Tuple tuple : ms) {
                TreeMap mSequence = (TreeMap)mSequences.get(tuple.getFirst());
                if (mSequence == null) {
                    throw new Exception("nodeid=" + nodeId + "; mnId=" + (String)tuple.getFirst() + ": no maneuver sequence given.");
                }
                if (mSequence.size() < 2) {
                    throw new Exception("nodeid=" + nodeId + "; mnId=" + (String)tuple.getFirst() + ": mSequenceSize=" + mSequence.size() + " not alowed!");
                }
                Id id = (Id)mSequence.values().iterator().next();
                for (Id id2 : mSequence.values()) {
                    Link outLink;
                    Link inLink = n.getInLinks().get(Id.create(id + "FT", Link.class));
                    if (inLink == null) {
                        inLink = n.getInLinks().get(Id.create(id + "TF", Link.class));
                    }
                    if ((outLink = n.getOutLinks().get(Id.create(id2 + "FT", Link.class))) == null) {
                        outLink = n.getOutLinks().get(Id.create(id2 + "TF", Link.class));
                    }
                    if (inLink != null && outLink != null) {
                        TreeMap outLinkMap;
                        if ((Integer)tuple.getSecond() == 2102) {
                            outLinkMap = (TreeMap)mmatrix.get(inLink.getId());
                            if (outLinkMap == null) {
                                outLinkMap = new TreeMap();
                            }
                            outLinkMap.put(outLink.getId(), Boolean.TRUE);
                            mmatrix.put(inLink.getId(), outLinkMap);
                        } else {
                            outLinkMap = (TreeMap)mmatrix.get(inLink.getId());
                            if (outLinkMap == null) {
                                outLinkMap = new TreeMap();
                            }
                            outLinkMap.put(outLink.getId(), Boolean.FALSE);
                            mmatrix.put(inLink.getId(), outLinkMap);
                        }
                        ++maneuverAssignedCnt;
                        continue;
                    }
                    ++maneuverIgnoredCnt;
                }
            }
            for (TreeMap treeMap : mmatrix.values()) {
                boolean hasRestrictedManeuver = false;
                for (Boolean bl : treeMap.values()) {
                    if (!bl.booleanValue()) continue;
                    hasRestrictedManeuver = true;
                }
                for (Id<Link> id : n.getOutLinks().keySet()) {
                    if (treeMap.containsKey(id)) continue;
                    treeMap.put(id, !hasRestrictedManeuver);
                }
            }
            for (Id id : n.getInLinks().keySet()) {
                if (mmatrix.containsKey(id)) continue;
                mmatrix.put(id, new TreeMap());
                for (Id<Link> id3 : n.getOutLinks().keySet()) {
                    ((TreeMap)mmatrix.get(id)).put(id3, Boolean.TRUE);
                }
            }
            if (this.removeUTurns) {
                for (Id id : n.getInLinks().keySet()) {
                    String str1 = id.toString().substring(0, id.toString().length() - 2);
                    for (Id<Link> id4 : n.getOutLinks().keySet()) {
                        String string = id4.toString().substring(0, id4.toString().length() - 2);
                        if (!str1.equals(string)) continue;
                        ((TreeMap)mmatrix.get(id)).put(id4, Boolean.FALSE);
                    }
                }
            }
            ArrayList<NetworkExpandNode.TurnInfo> turns = new ArrayList<NetworkExpandNode.TurnInfo>();
            for (Map.Entry fromLinkEntry : mmatrix.entrySet()) {
                Id id = (Id)fromLinkEntry.getKey();
                for (Map.Entry entry2 : ((TreeMap)fromLinkEntry.getValue()).entrySet()) {
                    if (!((Boolean)entry2.getValue()).booleanValue()) continue;
                    turns.add(new NetworkExpandNode.TurnInfo(id, (Id)entry2.getKey()));
                }
            }
            Tuple<List<Node>, List<Link>> tuple = neModule.expandNode(nodeId, turns);
            virtualNodesCnt += tuple.getFirst().size();
            virtualLinksCnt += tuple.getSecond().size();
            ++nodesAssignedCnt;
        }
        log.info("    " + nodesAssignedCnt + " nodes expanded.");
        log.info("    " + maneuverAssignedCnt + " maneuvers assigned.");
        log.info("    " + virtualNodesCnt + " new nodes created.");
        log.info("    " + virtualLinksCnt + " new links created.");
        log.info("    " + nodesIgnoredCnt + " nodes with given maneuvers (2103, 2102 or 2101) ignored.");
        log.info("    " + maneuverIgnoredCnt + " maneuvers ignored (while node was found).");
        log.info("  done.");
        log.info("done.");
    }

    public final void printInfo(String prefix) {
        System.out.println(prefix + "configuration of " + this.getClass().getName() + ":");
        System.out.println(prefix + "  options:");
        System.out.println(prefix + "    removeUTurns:    " + this.removeUTurns);
        System.out.println(prefix + "    expansionRadius: " + this.expansionRadius);
        System.out.println(prefix + "    linkSeparation:  " + this.linkSeparation);
        System.out.println(prefix + "  maneuver shape:");
        System.out.println(prefix + "    mnShpFileName:   " + this.mnShpFileName);
        System.out.println(prefix + "    MN_ID_NAME:      " + "ID");
        System.out.println(prefix + "    MN_FEATTYP_NAME: " + MN_FEATTYP_NAME);
        System.out.println(prefix + "    MN_JNCTID_NAME:  " + MN_JNCTID_NAME);
        System.out.println(prefix + "  maneuver path dbf:");
        System.out.println(prefix + "    mpDbfFileName:   " + this.mpDbfFileName);
        System.out.println(prefix + "    MP_ID_NAME:      " + "ID");
        System.out.println(prefix + "    MP_SEQNR_NAME:   " + MP_SEQNR_NAME);
        System.out.println(prefix + "    MP_TRPELID_NAME: " + MP_TRPELID_NAME);
        System.out.println(prefix + "done.");
    }
}

