/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.io.FileInputStream;
import org.apache.log4j.Logger;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.utils.io.IOUtils;

public final class NetworkTeleatlasAddSpeedRestrictions
implements NetworkRunnable {
    private static final Logger log = Logger.getLogger(NetworkTeleatlasAddSpeedRestrictions.class);
    private final String srDbfFileName;
    private static final String SR_ID_NAME = "ID";
    private static final String SR_SPEED_NAME = "SPEED";
    private static final String SR_VALDIR_NAME = "VALDIR";
    private static final String SR_VERIFIED_NAME = "VERIFIED";

    public NetworkTeleatlasAddSpeedRestrictions(String srDbfFileName) {
        log.info("init " + this.getClass().getName() + " module...");
        this.srDbfFileName = srDbfFileName;
        log.info("done.");
    }

    @Override
    public void run(Network network) {
        try {
            this.run2(network);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void run2(Network network) throws Exception {
        log.info("running " + this.getClass().getName() + " module...");
        try (FileInputStream fis = new FileInputStream(this.srDbfFileName);){
            DbaseFileReader r = new DbaseFileReader(fis.getChannel(), true, IOUtils.CHARSET_WINDOWS_ISO88591);
            int srIdNameIndex = -1;
            int srSpeedNameIndex = -1;
            int srValDirNameIndex = -1;
            int srVerifiedNameIndex = -1;
            for (int i = 0; i < r.getHeader().getNumFields(); ++i) {
                if (r.getHeader().getFieldName(i).equals(SR_ID_NAME)) {
                    srIdNameIndex = i;
                }
                if (r.getHeader().getFieldName(i).equals(SR_SPEED_NAME)) {
                    srSpeedNameIndex = i;
                }
                if (r.getHeader().getFieldName(i).equals(SR_VALDIR_NAME)) {
                    srValDirNameIndex = i;
                }
                if (!r.getHeader().getFieldName(i).equals(SR_VERIFIED_NAME)) continue;
                srVerifiedNameIndex = i;
            }
            if (srIdNameIndex < 0) {
                throw new NoSuchFieldException("Field name 'ID' not found.");
            }
            if (srSpeedNameIndex < 0) {
                throw new NoSuchFieldException("Field name 'SPEED' not found.");
            }
            if (srValDirNameIndex < 0) {
                throw new NoSuchFieldException("Field name 'VALDIR' not found.");
            }
            if (srVerifiedNameIndex < 0) {
                throw new NoSuchFieldException("Field name 'VERIFIED' not found.");
            }
            log.trace("  FieldName-->Index:");
            log.trace("    ID-->" + srIdNameIndex);
            log.trace("    SPEED-->" + srSpeedNameIndex);
            log.trace("    VALDIR-->" + srValDirNameIndex);
            log.trace("    VERIFIED-->" + srVerifiedNameIndex);
            int srCnt = 0;
            int srIgnoreCnt = 0;
            while (r.hasNext()) {
                Link ftLink;
                Object[] entries = r.readEntry();
                int verified = Integer.parseInt(entries[srVerifiedNameIndex].toString());
                if (verified != 1) continue;
                int valdir = Integer.parseInt(entries[srValDirNameIndex].toString());
                String id = entries[srIdNameIndex].toString();
                if (valdir == 1) {
                    ftLink = network.getLinks().get(Id.create(id + "FT", Link.class));
                    Link tfLink = network.getLinks().get(Id.create(id + "TF", Link.class));
                    if (ftLink == null || tfLink == null) {
                        log.trace("  linkid=" + id + ", valdir=" + valdir + ": at least one link not found. Ignoring and proceeding anyway...");
                        ++srIgnoreCnt;
                        continue;
                    }
                    double speed = Double.parseDouble(entries[srSpeedNameIndex].toString()) / 3.6;
                    if (speed < ftLink.getFreespeed()) {
                        ftLink.setFreespeed(speed);
                        ++srCnt;
                    } else {
                        ++srIgnoreCnt;
                    }
                    if (speed < tfLink.getFreespeed()) {
                        tfLink.setFreespeed(speed);
                        ++srCnt;
                        continue;
                    }
                    ++srIgnoreCnt;
                    continue;
                }
                if (valdir == 2) {
                    ftLink = network.getLinks().get(Id.create(id + "FT", Link.class));
                    if (ftLink == null) {
                        log.trace("  linkid=" + id + ", valdir=" + valdir + ": link not found. Ignoring and proceeding anyway...");
                        ++srIgnoreCnt;
                        continue;
                    }
                    double speed = Double.parseDouble(entries[srSpeedNameIndex].toString()) / 3.6;
                    if (speed < ftLink.getFreespeed()) {
                        ftLink.setFreespeed(speed);
                        ++srCnt;
                        continue;
                    }
                    ++srIgnoreCnt;
                    continue;
                }
                if (valdir == 3) {
                    Link tfLink = network.getLinks().get(Id.create(id + "TF", Link.class));
                    if (tfLink == null) {
                        log.trace("  linkid=" + id + ", valdir=" + valdir + ": link not found. Ignoring and proceeding anyway...");
                        ++srIgnoreCnt;
                        continue;
                    }
                    double speed = Double.parseDouble(entries[srSpeedNameIndex].toString()) / 3.6;
                    if (speed < tfLink.getFreespeed()) {
                        tfLink.setFreespeed(speed);
                        ++srCnt;
                        continue;
                    }
                    ++srIgnoreCnt;
                    continue;
                }
                throw new IllegalArgumentException("linkid=" + id + ": valdir=" + valdir + " not known.");
            }
            log.info("  " + srCnt + " links with restricted speed assigned.");
            log.info("  " + srIgnoreCnt + " speed restrictions ignored (while verified = 1).");
            log.info("done.");
            r.close();
        }
    }

    public final void printInfo(String prefix) {
        System.out.println(prefix + "configuration of " + this.getClass().getName() + ":");
        System.out.println(prefix + "  speed restrictions:");
        System.out.println(prefix + "    srDbfFileName:    " + this.srDbfFileName);
        System.out.println(prefix + "    SR_ID_NAME:       " + SR_ID_NAME);
        System.out.println(prefix + "    SR_SPEED_NAME:    " + SR_SPEED_NAME);
        System.out.println(prefix + "    SR_VALDIR_NAME:   " + SR_VALDIR_NAME);
        System.out.println(prefix + "    SR_VERIFIED_NAME: " + SR_VERIFIED_NAME);
        System.out.println(prefix + "done.");
    }
}

