/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.algorithms.NetworkExpandNode;
import org.matsim.core.network.algorithms.NetworkTurnInfoBuilderI;
import org.matsim.lanes.Lane;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesToLinkAssignment;

public final class NetworkTurnInfoBuilder
implements NetworkTurnInfoBuilderI {
    private final Scenario scenario;

    @Inject
    public NetworkTurnInfoBuilder(Scenario scenario) {
        this.scenario = scenario;
    }

    @Override
    public Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> createAllowedTurnInfos() {
        HashMap<Id<Link>, List<NetworkExpandNode.TurnInfo>> allowedInLinkTurnInfoMap = new HashMap<Id<Link>, List<NetworkExpandNode.TurnInfo>>();
        this.createAndAddTurnInfo("car", allowedInLinkTurnInfoMap);
        if (this.scenario.getConfig().network().getLaneDefinitionsFile() != null || this.scenario.getConfig().qsim().isUseLanes()) {
            Lanes ld = this.scenario.getLanes();
            Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> lanesTurnInfoMap = this.createTurnInfos(ld);
            this.mergeTurnInfoMaps(allowedInLinkTurnInfoMap, lanesTurnInfoMap);
        }
        return allowedInLinkTurnInfoMap;
    }

    private Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> createTurnInfos(Lanes laneDefs) {
        HashMap<Id<Link>, List<NetworkExpandNode.TurnInfo>> inLinkIdTurnInfoMap = new HashMap<Id<Link>, List<NetworkExpandNode.TurnInfo>>();
        HashSet<Id<Link>> toLinkIds = new HashSet<Id<Link>>();
        for (LanesToLinkAssignment l2l : laneDefs.getLanesToLinkAssignments().values()) {
            toLinkIds.clear();
            for (Lane lane : l2l.getLanes().values()) {
                if (lane.getToLinkIds() == null || lane.getToLaneIds() != null && !lane.getToLaneIds().isEmpty()) continue;
                toLinkIds.addAll(lane.getToLinkIds());
            }
            if (toLinkIds.isEmpty()) continue;
            ArrayList<NetworkExpandNode.TurnInfo> turnInfoList = new ArrayList<NetworkExpandNode.TurnInfo>();
            for (Id id : toLinkIds) {
                turnInfoList.add(new NetworkExpandNode.TurnInfo(l2l.getLinkId(), id));
            }
            inLinkIdTurnInfoMap.put(l2l.getLinkId(), turnInfoList);
        }
        return inLinkIdTurnInfoMap;
    }

    private void createAndAddTurnInfo(String mode, Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> inLinkTurnInfoMap) {
        NetworkExpandNode.TurnInfo turnInfo = null;
        HashSet<String> modes = null;
        List<NetworkExpandNode.TurnInfo> turnInfosForInLink = null;
        for (Node node : this.scenario.getNetwork().getNodes().values()) {
            for (Link link : node.getInLinks().values()) {
                turnInfosForInLink = inLinkTurnInfoMap.get(link.getId());
                if (turnInfosForInLink == null) {
                    turnInfosForInLink = new ArrayList<NetworkExpandNode.TurnInfo>();
                    inLinkTurnInfoMap.put(link.getId(), turnInfosForInLink);
                }
                for (Link link2 : node.getOutLinks().values()) {
                    if (!link.getAllowedModes().isEmpty() && !link2.getAllowedModes().isEmpty()) {
                        if (!link.getAllowedModes().contains(mode) || !link2.getAllowedModes().contains(mode)) continue;
                        modes = new HashSet<String>();
                        modes.add(mode);
                        turnInfo = new NetworkExpandNode.TurnInfo(link.getId(), link2.getId(), modes);
                        turnInfosForInLink.add(turnInfo);
                        continue;
                    }
                    turnInfo = new NetworkExpandNode.TurnInfo(link.getId(), link2.getId());
                    turnInfosForInLink.add(turnInfo);
                }
            }
        }
    }

    public final void mergeTurnInfoMaps(Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> allowedInLinkTurnInfoMap, Map<Id<Link>, List<NetworkExpandNode.TurnInfo>> restrictingTurnInfoMap) {
        for (Map.Entry<Id<Link>, List<NetworkExpandNode.TurnInfo>> e : allowedInLinkTurnInfoMap.entrySet()) {
            Id<Link> inLinkId = e.getKey();
            List<NetworkExpandNode.TurnInfo> restrictingTurnInfos = restrictingTurnInfoMap.get(inLinkId);
            if (restrictingTurnInfos == null) continue;
            ArrayList allowedTurnInfos = new ArrayList(e.getValue());
            for (NetworkExpandNode.TurnInfo allowedForOutlink : allowedTurnInfos) {
                NetworkExpandNode.TurnInfo restrictionForOutlink = NetworkTurnInfoBuilder.getTurnInfoForOutlinkId(restrictingTurnInfos, allowedForOutlink.getToLinkId());
                if (restrictionForOutlink == null) {
                    allowedInLinkTurnInfoMap.get(inLinkId).remove(allowedForOutlink);
                    continue;
                }
                if (restrictionForOutlink.getModes() == null || allowedForOutlink.getModes() == null) continue;
                Set<String> commonModes = this.calculateCommonModes(restrictionForOutlink, allowedForOutlink);
                Set<String> allowedModes = allowedForOutlink.getModes();
                for (String mode : allowedModes) {
                    if (commonModes.contains(mode)) continue;
                    allowedForOutlink.getModes().remove(mode);
                }
            }
        }
    }

    static NetworkExpandNode.TurnInfo getTurnInfoForOutlinkId(List<NetworkExpandNode.TurnInfo> turnInfoList, Id<Link> outLinkId) {
        for (NetworkExpandNode.TurnInfo ti : turnInfoList) {
            if (!ti.getToLinkId().equals(outLinkId)) continue;
            return ti;
        }
        return null;
    }

    private Set<String> calculateCommonModes(NetworkExpandNode.TurnInfo first, NetworkExpandNode.TurnInfo second) {
        HashSet<String> modes = new HashSet<String>();
        for (String mode : first.getModes()) {
            if (!second.getModes().contains(mode)) continue;
            modes.add(mode);
        }
        return modes;
    }
}

