/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.NetworkRunnable;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.Time;

public final class NetworkWriteAsTable
implements NetworkRunnable {
    private static final Logger log = Logger.getLogger(NetworkWriteAsTable.class);
    private final String outdir;
    private final double offset;

    public NetworkWriteAsTable(String outdir, double offset) {
        this.offset = offset;
        this.outdir = outdir;
    }

    public NetworkWriteAsTable(String outdir) {
        this(outdir, 0.0);
    }

    public NetworkWriteAsTable() {
        this("output");
    }

    @Override
    public void run(Network network) {
        double capperiod = network.getCapacityPeriod();
        log.info("capperiod = " + (capperiod /= 3600.0));
        try {
            BufferedWriter out_n = IOUtils.getBufferedWriter(this.outdir + "/nodes.txt.gz");
            out_n.write("ID\tX\tY\n");
            out_n.flush();
            for (Node node : network.getNodes().values()) {
                out_n.write(node.getId() + "\t" + node.getCoord().getX() + "\t" + node.getCoord().getY() + "\n");
                out_n.flush();
            }
            out_n.flush();
            out_n.close();
            BufferedWriter out_l = IOUtils.getBufferedWriter(this.outdir + "/links.txt.gz");
            out_l.write("ID\tX1\tY1\tX2\tY2\tLENGHT\tFREESPEED\tCAPACITY\tPERMLANES\tMODES\n");
            out_l.flush();
            BufferedWriter bufferedWriter = IOUtils.getBufferedWriter(this.outdir + "/linksET.txt.gz");
            bufferedWriter.write("ID\tFROMID\tTOID\tLENGTH\tSPEED\tCAP\tLANES\tORIGID\tTYPE\tMODES\n");
            bufferedWriter.flush();
            for (Link link : network.getLinks().values()) {
                Node f = link.getFromNode();
                Node t = link.getToNode();
                double y = -t.getCoord().getX() + f.getCoord().getX();
                Coord offsetVector = new Coord(t.getCoord().getY() - f.getCoord().getY(), y);
                offsetVector = CoordUtils.scalarMult(this.offset / CoordUtils.length(offsetVector), offsetVector);
                Coord fc = CoordUtils.plus(f.getCoord(), offsetVector);
                Coord tc = CoordUtils.plus(t.getCoord(), offsetVector);
                out_l.write(link.getId() + "\t" + fc.getX() + "\t" + fc.getY() + "\t");
                out_l.write(tc.getX() + "\t" + tc.getY() + "\t" + link.getLength() + "\t");
                out_l.write(link.getFreespeed() + "\t" + link.getCapacity() / capperiod + "\t" + NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), link) + "\t" + link.getAllowedModes().toString() + "\n");
                out_l.flush();
                bufferedWriter.write(link.getId() + "\t" + link.getFromNode().getId() + "\t" + link.getToNode().getId() + "\t");
                bufferedWriter.write(Math.round(link.getLength()) + "\t" + Math.round(link.getFreespeed() * 3.6) + "\t");
                bufferedWriter.write(Math.round(link.getCapacity() / capperiod) + "\t" + NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), link) + "\t");
                bufferedWriter.write(NetworkUtils.getOrigId(link) + "\t" + NetworkUtils.getType(link) + "\t" + link.getAllowedModes().toString() + "\n");
                bufferedWriter.write(fc.getX() + "\t" + fc.getY() + "\n");
                bufferedWriter.write(tc.getX() + "\t" + tc.getY() + "\n");
                bufferedWriter.write("END\n");
            }
            out_l.flush();
            out_l.close();
            bufferedWriter.write("END\n");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

