/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.LinkIdComparator;

public final class SubsequentLinksAnalyzer {
    private final Network network;
    private final TreeMap<Id<Link>, Id<Link>> subsequentLinks = new TreeMap();

    public SubsequentLinksAnalyzer(Network network) {
        this.network = network;
        this.compute();
    }

    public Map<Id<Link>, Id<Link>> getSubsequentLinks() {
        return this.subsequentLinks;
    }

    private void compute() {
        TreeMap<Link, Double> absDeltaThetas = new TreeMap<Link, Double>(new LinkIdComparator());
        for (Link link : this.network.getLinks().values()) {
            Node from = link.getFromNode();
            Node to = link.getToNode();
            Coord cFrom = from.getCoord();
            Coord cTo = to.getCoord();
            double xTo = cTo.getX();
            double yTo = cTo.getY();
            double thetaL = Math.atan2(yTo - cFrom.getY(), xTo - cFrom.getX());
            Collection<? extends Link> outLinks = to.getOutLinks().values();
            absDeltaThetas.clear();
            if (outLinks.size() > 1) {
                for (Link link2 : outLinks) {
                    double deltaTheta;
                    Coord cOut = link2.getToNode().getCoord();
                    for (deltaTheta = Math.atan2(cOut.getY() - yTo, cOut.getX() - xTo) - thetaL; deltaTheta < -Math.PI; deltaTheta += Math.PI * 2) {
                    }
                    while (deltaTheta > Math.PI) {
                        deltaTheta -= Math.PI * 2;
                    }
                    absDeltaThetas.put(link2, Math.abs(deltaTheta));
                }
                this.subsequentLinks.put(link.getId(), this.computeSubsequentLink(absDeltaThetas).getId());
                continue;
            }
            if (outLinks.size() != 1) continue;
            this.subsequentLinks.put(link.getId(), outLinks.iterator().next().getId());
        }
    }

    private Link computeSubsequentLink(Map<Link, Double> thetas) {
        ArrayList<Link> minThetaOutLinks = new ArrayList<Link>();
        minThetaOutLinks.clear();
        double absMin = Collections.min(thetas.values());
        for (Map.Entry<Link, Double> entry : thetas.entrySet()) {
            if (absMin != entry.getValue()) continue;
            minThetaOutLinks.add(entry.getKey());
        }
        if (minThetaOutLinks.size() == 1) {
            return (Link)minThetaOutLinks.get(0);
        }
        double maxCapacity = Double.NEGATIVE_INFINITY;
        Link maxCapLink = null;
        for (Link link : minThetaOutLinks) {
            double cap = link.getCapacity();
            if (!(cap > maxCapacity)) continue;
            maxCapacity = cap;
            maxCapLink = link;
        }
        return maxCapLink;
    }
}

