/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms;

import java.util.HashSet;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.NetworkFactory;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.utils.objectattributes.attributable.AttributesUtils;

public final class TransportModeNetworkFilter {
    private final Network fullNetwork;

    public TransportModeNetworkFilter(Network fullNetwork) {
        this.fullNetwork = fullNetwork;
    }

    public void filter(Network subNetwork, Set<String> extractModes) {
        NetworkFactory factory = subNetwork.getFactory();
        for (Node node : this.fullNetwork.getNodes().values()) {
            Node node2 = factory.createNode(node.getId(), node.getCoord());
            AttributesUtils.copyAttributesFromTo(node, node2);
            subNetwork.addNode(node2);
        }
        HashSet nodesToInclude = new HashSet();
        for (Link link : this.fullNetwork.getLinks().values()) {
            HashSet<String> hashSet = new HashSet<String>(extractModes);
            hashSet.retainAll(link.getAllowedModes());
            if (hashSet.size() <= 0) continue;
            Id fromId = link.getFromNode().getId();
            Id toId = link.getToNode().getId();
            Node fromNode2 = subNetwork.getNodes().get(fromId);
            Node toNode2 = subNetwork.getNodes().get(toId);
            nodesToInclude.add(fromId);
            nodesToInclude.add(toId);
            Link link2 = factory.createLink(link.getId(), fromNode2, toNode2);
            link2.setAllowedModes(hashSet);
            link2.setCapacity(link.getCapacity());
            link2.setFreespeed(link.getFreespeed());
            link2.setLength(link.getLength());
            link2.setNumberOfLanes(link.getNumberOfLanes());
            NetworkUtils.setType(link2, NetworkUtils.getType(link));
            AttributesUtils.copyAttributesFromTo(link, link2);
            subNetwork.addLink(link2);
        }
        HashSet hashSet = new HashSet();
        for (Node node : this.fullNetwork.getNodes().values()) {
            if (nodesToInclude.contains(node.getId())) continue;
            hashSet.add(node.getId());
        }
        for (Id id : hashSet) {
            subNetwork.removeNode(id);
        }
    }
}

