/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms.intersectionSimplifier;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.Cluster;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.ClusterActivity;
import org.matsim.core.utils.collections.QuadTree;
import org.matsim.core.utils.io.IOUtils;

public class DensityCluster {
    private List<Node> inputPoints;
    private Map<Id<Coord>, ClusterActivity> lostPoints = new TreeMap<Id<Coord>, ClusterActivity>();
    private QuadTree<ClusterActivity> quadTree;
    private List<Cluster> clusterList;
    private static final Logger log = Logger.getLogger(DensityCluster.class);
    private String delimiter = ",";
    private final boolean silent;

    public DensityCluster(List<Node> nodesToCluster, boolean silent) {
        this.inputPoints = nodesToCluster;
        int nullCounter = 0;
        for (Node node : this.inputPoints) {
            if (node != null && node.getCoord() != null) continue;
            ++nullCounter;
        }
        if (nullCounter > 0) {
            log.warn("In DJCluster: of the " + this.inputPoints.size() + " points, " + nullCounter + " were null.");
        }
        this.clusterList = new ArrayList<Cluster>();
        this.silent = silent;
    }

    public void clusterInput(double radius, int minimumPoints) {
        if (this.inputPoints.size() == 0) {
            log.warn("DJCluster.clusterInput() called, but no points to cluster.");
        } else {
            Object cp;
            if (!this.silent) {
                log.info("Clustering input points. This may take a while.");
            }
            int clusterIndex = 0;
            int pointMultiplier = 1;
            int uPointCounter = 0;
            int cPointCounter = 0;
            double xMin = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (Node node : this.inputPoints) {
                Coord c = node.getCoord();
                if (c == null) {
                    log.warn("Coord is null. Number of points in list: " + this.inputPoints.size());
                    continue;
                }
                xMin = Math.min(xMin, c.getX());
                yMin = Math.min(yMin, c.getY());
                xMax = Math.max(xMax, c.getX());
                yMax = Math.max(yMax, c.getY());
            }
            if (!this.silent) {
                log.info("Place points in QuadTree.");
            }
            this.quadTree = new QuadTree(xMin - 1.0, yMin - 1.0, xMax + 1.0, yMax + 1.0);
            ArrayList<ClusterActivity> listOfPoints = new ArrayList<ClusterActivity>();
            for (int i = 0; i < this.inputPoints.size(); ++i) {
                double x = this.inputPoints.get(i).getCoord().getX();
                double y = this.inputPoints.get(i).getCoord().getY();
                cp = new ClusterActivity(Id.create(i, Coord.class), this.inputPoints.get(i), null);
                this.quadTree.put(x, y, (ClusterActivity)cp);
                listOfPoints.add((ClusterActivity)cp);
            }
            if (!this.silent) {
                log.info("Done placing activities.");
            }
            int pointCounter = 0;
            while (pointCounter < listOfPoints.size()) {
                ClusterActivity p = (ClusterActivity)listOfPoints.get(pointCounter);
                if (p.getCluster() == null) {
                    Collection<ClusterActivity> neighbourhood = this.quadTree.getDisk(p.getCoord().getX(), p.getCoord().getY(), radius);
                    ArrayList<ClusterActivity> uN = new ArrayList<ClusterActivity>(neighbourhood.size());
                    ArrayList cN = new ArrayList(neighbourhood.size());
                    cp = neighbourhood.iterator();
                    while (cp.hasNext()) {
                        ClusterActivity cp2 = (ClusterActivity)cp.next();
                        if (cp2.getCluster() == null) {
                            uN.add(cp2);
                            continue;
                        }
                        cN.add(cp2);
                    }
                    if (neighbourhood.size() < minimumPoints) {
                        this.lostPoints.put(p.getId(), p);
                        ++uPointCounter;
                    } else if (cN.size() > 0) {
                        ArrayList<Cluster> localClusters = new ArrayList<Cluster>();
                        Object smallestCluster = ((ClusterActivity)cN.get(0)).getCluster();
                        for (int i = 1; i < cN.size(); ++i) {
                            if (Integer.parseInt(((ClusterActivity)cN.get(i)).getCluster().getId().toString()) < Integer.parseInt(((Cluster)smallestCluster).getId().toString())) {
                                smallestCluster = ((ClusterActivity)cN.get(i)).getCluster();
                            }
                            if (localClusters.contains(((ClusterActivity)cN.get(i)).getCluster())) continue;
                            localClusters.add(((ClusterActivity)cN.get(i)).getCluster());
                        }
                        for (Cluster DigicoreCluster : localClusters) {
                            if (DigicoreCluster.equals(smallestCluster)) continue;
                            List<ClusterActivity> thisClusterList = DigicoreCluster.getPoints();
                            for (int j = 0; j < thisClusterList.size(); ++j) {
                                thisClusterList.get(j).setCluster((Cluster)smallestCluster);
                                ((Cluster)smallestCluster).getPoints().add(thisClusterList.get(j));
                            }
                        }
                        for (ClusterActivity cp3 : uN) {
                            ((Cluster)smallestCluster).getPoints().add(cp3);
                            cp3.setCluster((Cluster)smallestCluster);
                            ++cPointCounter;
                            if (!this.lostPoints.containsKey(cp3.getId())) continue;
                            this.lostPoints.remove(cp3.getId());
                            --uPointCounter;
                        }
                    } else {
                        Cluster newCluster = new Cluster(Id.create(clusterIndex, Cluster.class));
                        ++clusterIndex;
                        for (ClusterActivity cp4 : uN) {
                            cp4.setCluster(newCluster);
                            newCluster.getPoints().add(cp4);
                            ++cPointCounter;
                            if (!this.lostPoints.containsKey(cp4.getId())) continue;
                            this.lostPoints.remove(cp4.getId());
                            --uPointCounter;
                        }
                    }
                }
                if (this.silent || ++pointCounter != pointMultiplier) continue;
                log.info("   Points clustered: " + pointCounter);
                pointMultiplier = Math.max(pointCounter, pointMultiplier) * 2;
            }
            if (!this.silent) {
                log.info("   Points clustered: " + pointCounter + " (Done)");
                int sum = cPointCounter + uPointCounter;
                log.info("Sum should add up: " + cPointCounter + " (clustered) + " + uPointCounter + " (unclustered) = " + sum);
                log.info("Unclustered points: ");
                for (ClusterActivity ca : this.lostPoints.values()) {
                    log.info(String.format("   %.6f,%.6f", ca.getCoord().getX(), ca.getCoord().getY()));
                }
                log.info("New way of unclustered points:");
                log.info("   Number: " + this.lostPoints.size());
            }
            if (!this.silent) {
                log.info("Building the DigicoreCluster list (2 steps)");
            }
            HashMap clusterMap = new HashMap();
            if (!this.silent) {
                log.info("Step 1 of 2:");
                log.info("Number of ClusterPoints to process: " + listOfPoints.size());
            }
            int cpCounter = 0;
            int cpMultiplier = 1;
            for (ClusterActivity ca : listOfPoints) {
                Cluster theCluster = ca.getCluster();
                if (theCluster != null) {
                    if (!clusterMap.containsKey(theCluster)) {
                        ArrayList newList = new ArrayList();
                        clusterMap.put(theCluster, newList);
                    }
                    ((List)clusterMap.get(theCluster)).add(ca);
                }
                if (this.silent || ++cpCounter != cpMultiplier) continue;
                log.info("   ClusterPoints processed: " + cpCounter + " (" + String.format("%3.2f", (double)cpCounter / (double)listOfPoints.size() * 100.0) + "%)");
                cpMultiplier *= 2;
            }
            if (!this.silent) {
                log.info("   ClusterPoints processed: " + cpCounter + " (Done)");
            }
            if (!this.silent) {
                log.info("Step 2 of 2:");
                log.info("Number of clusters to process: " + clusterMap.keySet().size());
            }
            int clusterCounter = 0;
            int clusterMultiplier = 1;
            int clusterNumber = 0;
            for (Map.Entry e : clusterMap.entrySet()) {
                Cluster digicoreCluster = (Cluster)e.getKey();
                List listOfClusterPoints = (List)e.getValue();
                if (listOfClusterPoints.size() >= minimumPoints) {
                    digicoreCluster.setClusterId(Id.create(clusterNumber++, Cluster.class));
                    ++clusterNumber;
                    digicoreCluster.setCenterOfGravity();
                    this.clusterList.add(digicoreCluster);
                } else if (!this.silent) {
                    log.warn(" ... why do we HAVE a cluster with too few points?...");
                }
                if (this.silent || ++clusterCounter != clusterMultiplier) continue;
                log.info("   Clusters processed: " + clusterCounter + " (" + String.format("%3.2f", (double)clusterCounter / (double)clusterMap.keySet().size() * 100.0) + "%)");
                clusterMultiplier *= 2;
            }
            if (!this.silent) {
                log.info("   Clusters processed: " + clusterCounter + " (Done)");
                log.info("DigicoreCluster list built.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClustersToFile(String filename) {
        int clusterCount = 0;
        int clusterMultiplier = 1;
        int totalClusters = this.clusterList.size();
        if (!this.silent) {
            log.info("Writing a total of " + totalClusters + " to file.");
        }
        try (BufferedWriter output = IOUtils.getBufferedWriter(filename);){
            output.write("ClusterId,Long,Lat,NumberOfActivities");
            output.newLine();
            for (Cluster c : this.clusterList) {
                c.setCenterOfGravity();
                Coord center = c.getCenterOfGravity();
                output.write(c.getId().toString());
                output.write(this.delimiter);
                output.write(String.valueOf(center.getX()));
                output.write(this.delimiter);
                output.write(String.valueOf(center.getY()));
                output.write(this.delimiter);
                output.write(String.valueOf(c.getPoints().size()));
                output.newLine();
                if (this.silent || ++clusterCount != clusterMultiplier) continue;
                log.info("   Clusters written: " + clusterCount);
                clusterMultiplier *= 2;
            }
            if (!this.silent) {
                log.info("   Clusters written: " + clusterCount + " (Done)");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Cluster> getClusterList() {
        return this.clusterList;
    }

    public QuadTree<ClusterActivity> getClusteredPoints() {
        return this.quadTree;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Map<Id<Coord>, ClusterActivity> getLostPoints() {
        return this.lostPoints;
    }
}

