/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms.intersectionSimplifier;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.matsim.utils.objectattributes.AttributeConverter;

public class HullConverter
implements AttributeConverter<Geometry> {
    private final Logger log = Logger.getLogger(HullConverter.class);

    @Override
    public Geometry convert(String value) {
        Geometry g2;
        String[] sa;
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        for (String s2 : sa = value.split(",")) {
            String[] sa2 = s2.substring(1, s2.length() - 1).split(";");
            double x = Double.parseDouble(sa2[0]);
            double y = Double.parseDouble(sa2[1]);
            list.add(new Coordinate(x, y));
        }
        Coordinate[] ca = new Coordinate[list.size()];
        if (ca.length == 1) {
            ca[0] = (Coordinate)list.get(0);
            g2 = gf.createPoint(ca[0]);
        } else if (ca.length == 2) {
            ca[0] = (Coordinate)list.get(0);
            ca[1] = (Coordinate)list.get(1);
            g2 = gf.createLineString(ca);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                ca[i] = (Coordinate)list.get(i);
            }
            g2 = gf.createPolygon(gf.createLinearRing(ca), null);
        }
        return g2;
    }

    @Override
    public String convertToString(Object o) {
        if (!(o instanceof Geometry)) {
            this.log.error("Could not convert the geometry: it is not of type Geometry. Returning empty string.");
            return "";
        }
        Coordinate[] ca = ((Geometry)o).getCoordinates();
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < ca.length - 1; ++i) {
            s2.append("(");
            s2.append(ca[i].x);
            s2.append(";");
            s2.append(ca[i].y);
            s2.append("),");
        }
        s2.append("(");
        s2.append(ca[ca.length - 1].x);
        s2.append(";");
        s2.append(ca[ca.length - 1].y);
        s2.append(")");
        return s2.toString();
    }
}

