/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms.intersectionSimplifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.intersectionSimplifier.DensityCluster;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.Cluster;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.ClusterActivity;
import org.matsim.core.utils.collections.QuadTree;

public class IntersectionSimplifier {
    private static final Logger LOG = Logger.getLogger(IntersectionSimplifier.class);
    private final double pmin;
    private final int epsilon;
    private DensityCluster djc = null;
    private QuadTree<Node> clusteredNodes = null;
    private Map<Id<Node>, Node> mergedNodeId2clusterNode = new HashMap<Id<Node>, Node>();

    public IntersectionSimplifier(double pmin, int epsilon) {
        this.pmin = pmin;
        this.epsilon = epsilon;
    }

    public Network simplify(Network network) {
        if (this.djc != null) {
            LOG.error("This NetworkSimplifier has already been used to simplify a network!");
            throw new RuntimeException("Should instantiate a new NetworkSimplifier");
        }
        LOG.info("Simplifying the intersections...");
        IntersectionSimplifier.reportNetworkStatistics(network);
        Network newNetwork = NetworkUtils.createNetwork();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : network.getNodes().values()) {
            nodes.add(NetworkUtils.createNode(node.getId(), node.getCoord()));
        }
        LOG.info("Clustering the network nodes...");
        this.djc = new DensityCluster(nodes, true);
        this.djc.clusterInput(this.pmin, this.epsilon);
        LOG.info("Done clustering.");
        List<Cluster> clusters = this.djc.getClusterList();
        LOG.info("Populating QuadTree with clustered points.");
        this.clusteredNodes = new QuadTree(this.djc.getClusteredPoints().getMinEasting(), this.djc.getClusteredPoints().getMinNorthing(), this.djc.getClusteredPoints().getMaxEasting(), this.djc.getClusteredPoints().getMaxNorthing());
        for (Cluster cluster : clusters) {
            TreeSet<String> nodeIdsInCluster = new TreeSet<String>();
            for (ClusterActivity clusterActivity : cluster.getPoints()) {
                nodeIdsInCluster.add(clusterActivity.getNode().getId().toString());
            }
            String clusteredNodeName = "";
            for (String nodeInCluster3 : nodeIdsInCluster) {
                if (!clusteredNodeName.equals("")) {
                    clusteredNodeName = clusteredNodeName + "-";
                }
                clusteredNodeName = clusteredNodeName + nodeInCluster3;
            }
            Id<Node> id = Id.createNodeId(clusteredNodeName);
            Node newNode = network.getFactory().createNode(id, cluster.getCenterOfGravity());
            HashSet includedNodes = new HashSet();
            for (ClusterActivity clusterPoint : cluster.getPoints()) {
                Coord clusterPointCoord = clusterPoint.getCoord();
                this.clusteredNodes.put(clusterPointCoord.getX(), clusterPointCoord.getY(), newNode);
                includedNodes.add(clusterPoint.getNode().getId());
                this.mergedNodeId2clusterNode.put(clusterPoint.getNode().getId(), newNode);
            }
        }
        LOG.info("Done populating QuadTree. Number of nodes affected: " + this.clusteredNodes.size());
        for (Link link : network.getLinks().values()) {
            Node fromNode = NetworkUtils.createNode(link.getFromNode().getId(), link.getFromNode().getCoord());
            Node fromCentroid = this.getClusteredNode(fromNode);
            Node node = NetworkUtils.createNode(link.getToNode().getId(), link.getToNode().getCoord());
            Node toCentroid = this.getClusteredNode(node);
            Node newFromNode = fromCentroid != null ? fromCentroid : fromNode;
            Node newToNode = toCentroid != null ? toCentroid : node;
            Link newLink = NetworkUtils.createLink(link.getId(), newFromNode, newToNode, newNetwork, link.getLength(), link.getFreespeed(), link.getCapacity(), link.getNumberOfLanes());
            newLink.setAllowedModes(link.getAllowedModes());
            if (newLink.getFromNode().getCoord().equals(newLink.getToNode().getCoord())) continue;
            if (newFromNode.getId().toString().equalsIgnoreCase("2") || newToNode.getId().toString().equalsIgnoreCase("2")) {
                LOG.info("Got node \"2\"");
            }
            if (!newNetwork.getNodes().containsKey(newLink.getFromNode().getId())) {
                NetworkUtils.createAndAddNode(newNetwork, newLink.getFromNode().getId(), newLink.getFromNode().getCoord());
            }
            if (!newNetwork.getNodes().containsKey(newLink.getToNode().getId())) {
                NetworkUtils.createAndAddNode(newNetwork, newLink.getToNode().getId(), newLink.getToNode().getCoord());
            }
            newLink.setFromNode(newNetwork.getNodes().get(newFromNode.getId()));
            newLink.setToNode(newNetwork.getNodes().get(newToNode.getId()));
            newNetwork.addLink(newLink);
        }
        String string = network.getName();
        if (string != null) {
            String string2 = string + (string.endsWith(".") ? " Simplified." : ". Simplified.");
            newNetwork.setName(string2);
        } else {
            LOG.warn("The given network does not have a description. This makes reproducibility hard!");
        }
        LOG.info("Done simplifying the intersections");
        IntersectionSimplifier.reportNetworkStatistics(newNetwork);
        return newNetwork;
    }

    protected Node getClusteredNode(Node node) {
        Node n = this.mergedNodeId2clusterNode.get(node.getId());
        return n;
    }

    public void writeClustersToFile(String file) {
        if (this.djc == null) {
            LOG.info("Density-based clustering has not been run yet. Cannot write to file.");
        } else {
            this.djc.writeClustersToFile(file);
        }
    }

    public List<Cluster> getClusters() {
        if (this.djc == null) {
            LOG.warn("The network has not been simplified yet. Returning 0 clusters");
            return new ArrayList<Cluster>(0);
        }
        return this.djc.getClusterList();
    }

    public static void reportNetworkStatistics(Network network) {
        LOG.info("--- Network statistics: ------------------------------------------------------");
        LOG.info("   Network description: " + network.getName());
        LOG.info("       Number of nodes: " + network.getNodes().size());
        LOG.info("       Number of links: " + network.getLinks().size());
        LOG.info("------------------------------------------------------------------------------");
    }
}

