/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms.intersectionSimplifier;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.NetworkCalcTopoType;
import org.matsim.core.network.algorithms.NetworkCleaner;
import org.matsim.core.network.algorithms.NetworkSimplifier;
import org.matsim.core.network.algorithms.intersectionSimplifier.IntersectionSimplifier;
import org.matsim.core.network.io.MatsimNetworkReader;
import org.matsim.core.network.io.NetworkWriter;

public class RunIntersectionSimplifier {
    private static final Logger LOG = Logger.getLogger(RunIntersectionSimplifier.class);

    public static void main(String[] args) {
        RunIntersectionSimplifier.run(args);
    }

    public static void run(String[] args) {
        String input = args[0];
        String output = args[1];
        Network network = NetworkUtils.createNetwork();
        new MatsimNetworkReader(network).readFile(input);
        IntersectionSimplifier ns = new IntersectionSimplifier(30.0, 2);
        Network newNetwork = ns.simplify(network);
        NetworkCalcTopoType nct = new NetworkCalcTopoType();
        nct.run(newNetwork);
        LOG.info("Simplifying the network...");
        new NetworkSimplifier().run(newNetwork);
        LOG.info("Cleaning the network...");
        new NetworkCleaner().run(newNetwork);
        IntersectionSimplifier.reportNetworkStatistics(newNetwork);
        new NetworkWriter(newNetwork).write(output);
    }
}

