/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms.intersectionSimplifier.containers;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Identifiable;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.ClusterActivity;

public class Cluster
implements Identifiable<Cluster> {
    private final Logger log = Logger.getLogger(Cluster.class);
    private Id<Cluster> clusterId;
    private Coord centerOfGravity;
    private List<ClusterActivity> activities;
    private Geometry concaveHull;

    public Cluster(Id<Cluster> clusterId) {
        this.clusterId = clusterId;
        this.activities = new ArrayList<ClusterActivity>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCenterOfGravity() {
        if (this.concaveHull == null) {
            if (this.activities.size() <= 0) throw new IllegalArgumentException("Not enough points in cluster " + this.clusterId + " to calculate a center of gravity!");
            double xTotal = 0.0;
            double yTotal = 0.0;
            for (ClusterActivity p : this.activities) {
                xTotal += p.getCoord().getX();
                yTotal += p.getCoord().getY();
            }
            double xCenter = xTotal / (double)this.activities.size();
            double yCenter = yTotal / (double)this.activities.size();
            this.centerOfGravity = new Coord(xCenter, yCenter);
            return;
        } else {
            Point centroid = this.concaveHull.getCentroid();
            if (!centroid.isEmpty()) {
                this.centerOfGravity = new Coord(centroid.getX(), centroid.getY());
                return;
            } else {
                this.log.warn("Cannot set centre of gravity for an empty point!!");
                this.log.debug("   --> Unique facility identifier: " + this.getId().toString());
                this.log.debug("   --> No centre of gravity set.");
            }
        }
    }

    public Coord getCenterOfGravity() {
        return this.centerOfGravity;
    }

    public void setClusterId(Id<Cluster> id) {
        this.clusterId = id;
    }

    public List<ClusterActivity> getPoints() {
        return this.activities;
    }

    @Override
    public Id<Cluster> getId() {
        return this.clusterId;
    }

    public void setConcaveHull(Geometry geometry) {
        this.concaveHull = geometry;
    }

    public Geometry getConcaveHull(Geometry geometry) {
        return this.concaveHull;
    }
}

