/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms.intersectionSimplifier.containers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeTriangle;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.HullEdge;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.HullNode;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.HullTriangle;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.QuadEdgeComparator;
import org.matsim.core.utils.io.IOUtils;

public class ConcaveHull {
    private static final Logger LOG = Logger.getLogger(ConcaveHull.class);
    private GeometryFactory geomFactory;
    private GeometryCollection filteredPoints;
    private double threshold;
    private boolean printIterations = false;
    private HashMap<LineSegment, Integer> segments = new HashMap();
    private HashMap<Integer, HullEdge> edges = new HashMap();
    private HashMap<Integer, HullTriangle> triangles = new HashMap();
    private TreeMap<Integer, HullEdge> consideredEdges = new TreeMap();
    private HashMap<Integer, HullEdge> ignoredEdges = new HashMap();
    private Map<Coordinate, Integer> coordinates = new HashMap<Coordinate, Integer>();
    private Map<Integer, HullNode> vertices = new HashMap<Integer, HullNode>();

    public ConcaveHull(GeometryCollection points, double threshold) {
        this(points, threshold, false);
    }

    public ConcaveHull(GeometryCollection points, double threshold, boolean printIterations) {
        this.geomFactory = points.getFactory();
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        points.apply(filter);
        Coordinate[] ca = filter.getCoordinates();
        Geometry[] ga = new Geometry[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            ga[i] = this.geomFactory.createPoint(ca[i]);
        }
        this.filteredPoints = new GeometryCollection(ga, this.geomFactory);
        this.threshold = threshold;
        this.printIterations = printIterations;
        if (this.printIterations) {
            String filename = String.format("output/concaveHull/Threshold_%.0f_triangles.csv", this.threshold);
            BufferedWriter bw = IOUtils.getBufferedWriter(filename);
            try {
                bw.write("iteration,firstX,firstY,secondX,secondY");
                bw.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write to BufferedWriter " + filename);
            }
            finally {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close BufferedWriter " + filename);
                }
            }
            filename = String.format("output/concaveHull/Threshold_%.0f_border.csv", this.threshold);
            bw = IOUtils.getBufferedWriter(filename);
            try {
                bw.write("iteration,firstX,firstY,secondX,secondY");
                bw.newLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write to BufferedWriter " + filename);
            }
            finally {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close BufferedWriter " + filename);
                }
            }
        }
    }

    public Geometry getConcaveHull() {
        return this.getConcaveHull("");
    }

    public Geometry getConcaveHull(String facilityIdentifier) {
        if (this.filteredPoints.getNumGeometries() == 0) {
            return this.geomFactory.createGeometryCollection(null);
        }
        if (this.filteredPoints.getNumGeometries() == 1) {
            return this.filteredPoints.getGeometryN(0);
        }
        if (this.filteredPoints.getNumGeometries() == 2) {
            return this.geomFactory.createLineString(this.filteredPoints.getCoordinates());
        }
        return this.concaveHull(facilityIdentifier);
    }

    /*
     * WARNING - void declaration
     */
    private Geometry concaveHull(String facilityIdentifier) {
        Coordinate[] ca;
        DelaunayTriangulationBuilder dtb = new DelaunayTriangulationBuilder();
        dtb.setSites(this.filteredPoints);
        QuadEdgeSubdivision qes = dtb.getSubdivision();
        Collection quadEdges = qes.getEdges();
        List qeTriangles = QuadEdgeTriangle.createOn(qes);
        Collection qeVertices = qes.getVertices(false);
        if (qeTriangles.size() == 0 || qeVertices.size() == 0) {
            LOG.warn("No triangulation for " + this.filteredPoints.getNumPoints() + " points!!");
            LOG.warn("   --> Unique id for the group of points: " + facilityIdentifier);
            Coordinate[] ca2 = this.filteredPoints.getCoordinates();
            if (ca2.length == 3) {
                LOG.warn("   --> Instead, a polygon (triangle) of the three points will be returned.");
                Coordinate[] caClosed = new Coordinate[]{ca2[0], ca2[1], ca2[2], ca2[0]};
                return this.geomFactory.createPolygon(this.geomFactory.createLinearRing(caClosed), null);
            }
            LOG.warn("   --> Returning a single point geometry as the weighted coordinates of the filtered points.");
            double xSum = 0.0;
            double ySum = 0.0;
            for (Coordinate c : this.filteredPoints.getCoordinates()) {
                xSum += c.x;
                ySum += c.y;
            }
            double d = xSum / (double)this.filteredPoints.getCoordinates().length;
            double newY = ySum / (double)this.filteredPoints.getCoordinates().length;
            return this.geomFactory.createPoint(new Coordinate(d, newY));
        }
        int nodeId = 0;
        for (Vertex v : qeVertices) {
            this.coordinates.put(v.getCoordinate(), nodeId);
            this.vertices.put(nodeId, new HullNode(nodeId, v.getCoordinate()));
            ++nodeId;
        }
        ArrayList<QuadEdge> qeFrameBorder = new ArrayList<QuadEdge>();
        ArrayList<QuadEdge> qeFrame = new ArrayList<QuadEdge>();
        ArrayList<QuadEdge> qeBorder = new ArrayList<QuadEdge>();
        for (QuadEdge quadEdge : quadEdges) {
            if (qes.isFrameBorderEdge(quadEdge)) {
                qeFrameBorder.add(quadEdge);
            }
            if (!qes.isFrameEdge(quadEdge)) continue;
            qeFrame.add(quadEdge);
        }
        for (QuadEdge quadEdge : qeFrameBorder) {
            if (qeFrame.contains(quadEdge)) continue;
            qeBorder.add(quadEdge);
        }
        for (QuadEdge quadEdge : qeFrame) {
            qes.delete(quadEdge);
            quadEdges.remove(quadEdge);
        }
        HashMap<QuadEdge, Double> qeLengths = new HashMap<QuadEdge, Double>();
        for (QuadEdge qe : quadEdges) {
            qeLengths.put(qe, qe.toLineSegment().getLength());
        }
        QuadEdgeComparator quadEdgeComparator = new QuadEdgeComparator(qeLengths);
        TreeMap<QuadEdge, Double> qeSorted = new TreeMap<QuadEdge, Double>(quadEdgeComparator);
        qeSorted.putAll(qeLengths);
        int edgeId = 0;
        for (QuadEdge quadEdge : qeSorted.keySet()) {
            HullEdge edge;
            LineSegment ls = quadEdge.toLineSegment();
            ls.normalize();
            Integer idOrigin = this.coordinates.get(ls.p0);
            Integer idDestination = this.coordinates.get(ls.p1);
            HullNode nodeOrigin = this.vertices.get(idOrigin);
            HullNode nodeDestination = this.vertices.get(idDestination);
            if (qeBorder.contains(quadEdge)) {
                nodeOrigin.setBorder(true);
                nodeDestination.setBorder(true);
                edge = new HullEdge(edgeId, ls, nodeOrigin, nodeDestination, true);
                if (ls.getLength() < this.threshold) {
                    this.ignoredEdges.put(edgeId, edge);
                } else {
                    this.consideredEdges.put(edgeId, edge);
                }
            } else {
                edge = new HullEdge(edgeId, ls, nodeOrigin, nodeDestination, false);
            }
            this.edges.put(edgeId, edge);
            this.segments.put(ls, edgeId);
            ++edgeId;
        }
        int triangleId = 0;
        for (QuadEdgeTriangle qet : qeTriangles) {
            LineSegment lsA = qet.getEdge(0).toLineSegment();
            LineSegment lsB = qet.getEdge(1).toLineSegment();
            LineSegment lsC = qet.getEdge(2).toLineSegment();
            lsA.normalize();
            lsB.normalize();
            lsC.normalize();
            HullEdge edgeA = this.edges.get(this.segments.get(lsA));
            HullEdge edgeB = this.edges.get(this.segments.get(lsB));
            HullEdge edgeC = this.edges.get(this.segments.get(lsC));
            HullTriangle triangle = new HullTriangle(triangleId);
            triangle.addEdge(edgeA);
            triangle.addEdge(edgeB);
            triangle.addEdge(edgeC);
            edgeA.addTriangle(triangle);
            edgeB.addTriangle(triangle);
            edgeC.addTriangle(triangle);
            this.triangles.put(triangleId, triangle);
            ++triangleId;
        }
        for (HullEdge edge : this.edges.values()) {
            int numberOfTriangles = edge.getTriangles().size();
            if (numberOfTriangles > 1) {
                HullTriangle tA = edge.getTriangles().get(0);
                HullTriangle tB = edge.getTriangles().get(1);
                tA.addNeighbour(tB);
                tB.addNeighbour(tA);
            }
            if (numberOfTriangles != 0) continue;
            LOG.error("An edge not associated with a triangle!");
            LOG.warn("   --> Unique id for the group of points: " + facilityIdentifier);
        }
        int n = 0;
        if (this.printIterations) {
            void var16_37;
            ++var16_37;
            this.writeOutput(n);
        }
        while (!this.consideredEdges.isEmpty()) {
            void var16_38;
            HullEdge e = this.consideredEdges.firstEntry().getValue();
            if (e.getTriangles().size() == 0) {
                LOG.warn("Considered edge without a triangle association!!");
                LOG.warn("   --> For now (20130703) we deal with this by simply making the link 'ignored'.");
                LOG.warn("   --> Unique id for the group of points: " + facilityIdentifier);
                this.consideredEdges.remove(e.getId());
                this.ignoredEdges.put(e.getId(), e);
                continue;
            }
            HullTriangle triangle = e.getTriangles().get(0);
            List<HullTriangle> neighbours = triangle.getNeighbours();
            if (neighbours.size() == 1) {
                this.consideredEdges.remove(e.getId());
                this.ignoredEdges.put(e.getId(), e);
                continue;
            }
            HullEdge e0 = triangle.getEdges().get(0);
            HullEdge e1 = triangle.getEdges().get(1);
            if (e0.getOriginNode().isBorder() && e0.getDestinationNode().isBorder() && e1.getOriginNode().isBorder() && e1.getDestinationNode().isBorder()) {
                this.consideredEdges.remove(e.getId());
                this.ignoredEdges.put(e.getId(), e);
                continue;
            }
            HullTriangle tA = neighbours.get(0);
            HullTriangle tB = neighbours.get(1);
            this.triangles.remove(triangle.getId());
            tA.removeNeighbour(triangle);
            tB.removeNeighbour(triangle);
            List<HullEdge> triangleEdges = triangle.getEdges();
            triangleEdges.remove(e);
            this.edges.remove(e.getId());
            this.consideredEdges.remove(e.getId());
            HullEdge eA = triangleEdges.get(0);
            eA.setBorder(true);
            if (eA.getGeometry().getLength() > this.threshold) {
                this.consideredEdges.put(eA.getId(), eA);
            } else {
                this.ignoredEdges.put(eA.getId(), eA);
            }
            eA.removeTriangle(triangle);
            HullEdge eB = triangleEdges.get(1);
            eB.setBorder(true);
            if (eB.getGeometry().getLength() > this.threshold) {
                this.consideredEdges.put(eB.getId(), eB);
            } else {
                this.ignoredEdges.put(eB.getId(), eB);
            }
            eB.removeTriangle(triangle);
            if (!this.printIterations) continue;
            this.writeOutput((int)(++var16_38));
        }
        ArrayList<LineString> borderEdges = new ArrayList<LineString>();
        for (HullEdge e : this.consideredEdges.values()) {
            borderEdges.add(e.getGeometry().toGeometry(this.geomFactory));
        }
        for (HullEdge e : this.ignoredEdges.values()) {
            borderEdges.add(e.getGeometry().toGeometry(this.geomFactory));
        }
        LineMerger lineMerger = new LineMerger();
        lineMerger.add(borderEdges);
        LineString merge = (LineString)lineMerger.getMergedLineStrings().iterator().next();
        if (merge.isRing()) {
            LinearRing lr = new LinearRing(merge.getCoordinateSequence(), this.geomFactory);
            Polygon concaveHull = new Polygon(lr, null, this.geomFactory);
            return concaveHull;
        }
        LOG.warn("Could not create hull as the line segments do not form a closed ring.");
        LOG.warn("   --> Unique id for the group of points: " + facilityIdentifier);
        LOG.warn("   --> Unique points (" + this.filteredPoints.getNumGeometries() + "):");
        for (Coordinate c : ca = this.filteredPoints.getCoordinates()) {
            LOG.warn("       (" + c.x + ";" + c.y + ")");
        }
        LOG.warn("   --> Returning the convex hull.");
        return this.geomFactory.createMultiPoint(this.filteredPoints.getCoordinates()).convexHull();
    }

    public Object getInputPoints() {
        return this.filteredPoints.getNumGeometries();
    }

    public static List<Coordinate> getClusterCoords(String fileName) {
        LOG.info("Reading coordinate list from " + fileName);
        ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>();
        try {
            String lines;
            BufferedReader br = IOUtils.getBufferedReader(fileName);
            br.readLine();
            while ((lines = br.readLine()) != null) {
                String[] inputString = lines.split(",");
                double x = Double.parseDouble(inputString[0]);
                double y = Double.parseDouble(inputString[1]);
                Coordinate coord = new Coordinate(x, y);
                coordinateList.add(coord);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return coordinateList;
    }

    private void writeOutput(int iteration) {
        String filename = String.format("output/concaveHull/Threshold_%.0f_triangles.csv", this.threshold);
        BufferedWriter bw = IOUtils.getAppendingBufferedWriter(filename);
        try {
            for (HullEdge e : this.edges.values()) {
                bw.write(String.format("%d,", iteration));
                bw.write(String.format("%.2f,", e.getOriginNode().getCoordinate().x));
                bw.write(String.format("%.2f,", e.getOriginNode().getCoordinate().y));
                bw.write(String.format("%.2f,", e.getDestinationNode().getCoordinate().x));
                bw.write(String.format("%.2f\n", e.getDestinationNode().getCoordinate().y));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write to BufferedWriter " + filename);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close BufferedWriter " + filename);
            }
        }
        filename = String.format("output/concaveHull/Threshold_%.0f_border.csv", this.threshold);
        bw = IOUtils.getAppendingBufferedWriter(filename);
        try {
            for (HullEdge e : this.consideredEdges.values()) {
                bw.write(String.format("%d,", iteration));
                bw.write(String.format("%.2f,", e.getOriginNode().getCoordinate().x));
                bw.write(String.format("%.2f,", e.getOriginNode().getCoordinate().y));
                bw.write(String.format("%.2f,", e.getDestinationNode().getCoordinate().x));
                bw.write(String.format("%.2f\n", e.getDestinationNode().getCoordinate().y));
            }
            for (HullEdge e : this.ignoredEdges.values()) {
                bw.write(String.format("%d,", iteration));
                bw.write(String.format("%.2f,", e.getOriginNode().getCoordinate().x));
                bw.write(String.format("%.2f,", e.getOriginNode().getCoordinate().y));
                bw.write(String.format("%.2f,", e.getDestinationNode().getCoordinate().x));
                bw.write(String.format("%.2f\n", e.getDestinationNode().getCoordinate().y));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write to BufferedWriter " + filename);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close BufferedWriter " + filename);
            }
        }
    }

    public static void main(String[] args) {
        List<Coordinate> coordinates = ConcaveHull.getClusterCoords(args[0]);
        GeometryFactory gf = new GeometryFactory();
        Geometry[] points = new Geometry[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            points[i] = gf.createPoint(coordinates.get(i));
        }
        GeometryCollection gc = new GeometryCollection(points, gf);
        ConcaveHull ch = new ConcaveHull(gc, Double.parseDouble(args[1]), true);
        Geometry g2 = ch.getConcaveHull();
    }
}

