/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.algorithms.intersectionSimplifier.containers;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.LineSegment;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.HullNode;
import org.matsim.core.network.algorithms.intersectionSimplifier.containers.HullTriangle;

public class HullEdge {
    private int id;
    private LineSegment geometry;
    private boolean border;
    private HullNode originNode;
    private HullNode destinationNode;
    private List<HullTriangle> triangles = new ArrayList<HullTriangle>();
    private List<HullEdge> incidentEdges = new ArrayList<HullEdge>();

    public HullEdge() {
    }

    public HullEdge(int id) {
        this.id = id;
    }

    public HullEdge(int id, LineSegment geometry) {
        this.id = id;
        this.geometry = geometry;
    }

    public HullEdge(int id, boolean border) {
        this.id = id;
        this.border = border;
    }

    public HullEdge(int id, LineSegment geometry, boolean border) {
        this.id = id;
        this.geometry = geometry;
        this.border = border;
    }

    public HullEdge(int id, LineSegment geometry, HullNode oV, HullNode eV, boolean border) {
        this.id = id;
        this.geometry = geometry;
        this.originNode = oV;
        this.destinationNode = eV;
        this.border = border;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public LineSegment getGeometry() {
        return this.geometry;
    }

    public void setGeometry(LineSegment geometry) {
        this.geometry = geometry;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
        if (border) {
            this.originNode.setBorder(true);
            this.destinationNode.setBorder(true);
        }
    }

    public HullNode getOriginNode() {
        return this.originNode;
    }

    public void setOriginNode(HullNode originNode) {
        this.originNode = originNode;
    }

    public HullNode getDestinationNode() {
        return this.destinationNode;
    }

    public void setDestinationNode(HullNode destinationNodeV) {
        this.destinationNode = destinationNodeV;
    }

    public List<HullTriangle> getTriangles() {
        return this.triangles;
    }

    public void setTriangles(List<HullTriangle> triangles) {
        this.triangles = triangles;
    }

    public List<HullEdge> getIncidentEdges() {
        return this.incidentEdges;
    }

    public void setIncidentEdges(List<HullEdge> edges) {
        this.incidentEdges = edges;
    }

    public boolean addTriangle(HullTriangle triangle) {
        return this.getTriangles().add(triangle);
    }

    public boolean addTriangles(List<HullTriangle> triangles) {
        return this.getTriangles().addAll(triangles);
    }

    public boolean removeTriangle(HullTriangle triangle) {
        return this.getTriangles().remove(triangle);
    }

    public boolean removeTriangles(List<HullTriangle> triangles) {
        return this.getTriangles().removeAll(triangles);
    }

    public boolean addIncidentEdge(HullEdge edge) {
        return this.getIncidentEdges().add(edge);
    }

    public boolean addIncidentEdges(List<HullEdge> edges) {
        return this.getIncidentEdges().addAll(edges);
    }

    public boolean removeIncidentEdge(HullEdge edge) {
        return this.getIncidentEdges().remove(edge);
    }

    public boolean removeAllIncidentEdges(List<HullEdge> edges) {
        return this.getIncidentEdges().removeAll(edges);
    }
}

