/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.filter.NetworkLinkFilter;
import org.matsim.core.network.filter.NetworkNodeFilter;

public final class NetworkFilterManager {
    private static final Logger log = Logger.getLogger(NetworkFilterManager.class);
    private final Network network;
    private final List<NetworkLinkFilter> linkFilters;
    private final List<NetworkNodeFilter> nodeFilters;

    public NetworkFilterManager(Network net) {
        this.network = net;
        this.linkFilters = new ArrayList<NetworkLinkFilter>();
        this.nodeFilters = new ArrayList<NetworkNodeFilter>();
    }

    public void addLinkFilter(NetworkLinkFilter f) {
        this.linkFilters.add(f);
    }

    public void addNodeFilter(NetworkNodeFilter f) {
        this.nodeFilters.add(f);
    }

    private Node addNode(Network net, Node n) {
        Node newNode = net.getFactory().createNode(n.getId(), n.getCoord());
        net.addNode(newNode);
        return newNode;
    }

    private void addLink(Network net, Link l) {
        Node to;
        Node from;
        Node nn;
        Id fromId = l.getFromNode().getId();
        Id toId = l.getToNode().getId();
        if (!net.getNodes().containsKey(fromId)) {
            nn = this.network.getNodes().get(fromId);
            from = this.addNode(net, nn);
        } else {
            from = net.getNodes().get(fromId);
        }
        if (!net.getNodes().containsKey(toId)) {
            nn = this.network.getNodes().get(toId);
            to = this.addNode(net, nn);
        } else {
            to = net.getNodes().get(toId);
        }
        Link ll = net.getFactory().createLink(l.getId(), from, to);
        ll.setAllowedModes(l.getAllowedModes());
        ll.setCapacity(l.getCapacity());
        ll.setFreespeed(l.getFreespeed());
        ll.setLength(l.getLength());
        ll.setNumberOfLanes(l.getNumberOfLanes());
        for (Map.Entry<String, Object> entry : l.getAttributes().getAsMap().entrySet()) {
            ll.getAttributes().putAttribute(entry.getKey(), entry.getValue());
        }
        net.addLink(ll);
    }

    public Network applyFilters() {
        boolean add;
        log.info("applying filters to network with " + this.network.getNodes().size() + " nodes and " + this.network.getLinks().size() + " links...");
        Network net = NetworkUtils.createNetwork();
        if (!this.nodeFilters.isEmpty()) {
            for (Node node : this.network.getNodes().values()) {
                add = true;
                for (NetworkNodeFilter networkNodeFilter : this.nodeFilters) {
                    if (networkNodeFilter.judgeNode(node)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.addNode(net, node);
            }
        }
        if (!this.linkFilters.isEmpty()) {
            for (Link link : this.network.getLinks().values()) {
                add = true;
                for (NetworkLinkFilter networkLinkFilter : this.linkFilters) {
                    if (networkLinkFilter.judgeLink(link)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.addLink(net, link);
            }
        }
        log.info("filtered network contains " + net.getNodes().size() + " nodes and " + net.getLinks().size() + " links.");
        return net;
    }
}

