/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.filter;

import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.filter.NetworkLinkFilter;
import org.matsim.core.utils.geometry.CoordUtils;

public final class NetworkLinkDistanceFilter
implements NetworkLinkFilter {
    private final double distanceFilter;
    private final Node distanceFilterNode;

    public NetworkLinkDistanceFilter(double distance, Node centerNode) {
        this.distanceFilter = distance;
        this.distanceFilterNode = centerNode;
    }

    @Override
    public boolean judgeLink(Link l) {
        double dist = CoordUtils.calcEuclideanDistance(l.getCoord(), this.distanceFilterNode.getCoord());
        return dist < this.distanceFilter;
    }
}

