/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.io.IOException;
import net.opengis.kml.v_2_2_0.AbstractFeatureType;
import net.opengis.kml.v_2_2_0.DocumentType;
import net.opengis.kml.v_2_2_0.FolderType;
import net.opengis.kml.v_2_2_0.ObjectFactory;
import net.opengis.kml.v_2_2_0.PlacemarkType;
import net.opengis.kml.v_2_2_0.StyleType;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.MatsimSomeWriter;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.vis.kml.KMZWriter;
import org.matsim.vis.kml.MatsimKmlStyleFactory;
import org.matsim.vis.kml.NetworkFeatureFactory;
import org.matsim.vis.kml.NetworkKmlStyleFactory;

public final class KmlNetworkWriter
implements MatsimSomeWriter {
    private static final Logger log = Logger.getLogger(KmlNetworkWriter.class);
    private final Network network;
    private NetworkKmlStyleFactory styleFactory;
    private final ObjectFactory kmlObjectFactory = new ObjectFactory();
    private final NetworkFeatureFactory networkFeatureFactory;

    public KmlNetworkWriter(Network network, CoordinateTransformation coordTransform, KMZWriter writer, DocumentType doc) {
        this.network = network;
        this.styleFactory = new MatsimKmlStyleFactory(writer, doc);
        this.networkFeatureFactory = new NetworkFeatureFactory(coordTransform, network);
    }

    public void setNetworkKmlStyleFactory(NetworkKmlStyleFactory styleFac) {
        this.styleFactory = styleFac;
    }

    public FolderType getNetworkFolder() throws IOException {
        FolderType folder = this.kmlObjectFactory.createFolderType();
        folder.setName("MATSIM Network");
        StyleType networkLinkStyle = this.styleFactory.createDefaultNetworkLinkStyle();
        StyleType networkNodeStyle = this.styleFactory.createDefaultNetworkNodeStyle();
        FolderType nodeFolder = this.kmlObjectFactory.createFolderType();
        nodeFolder.setName("Nodes");
        for (Node node : this.network.getNodes().values()) {
            AbstractFeatureType abstractFeatureType = this.networkFeatureFactory.createNodeFeature(node, networkNodeStyle);
            if (abstractFeatureType.getClass().equals(PlacemarkType.class)) {
                nodeFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark((PlacemarkType)abstractFeatureType));
                continue;
            }
            if (abstractFeatureType.getClass().equals(FolderType.class)) {
                nodeFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder((FolderType)abstractFeatureType));
                continue;
            }
            log.warn("Not yet implemented: Adding node KML features of type " + abstractFeatureType.getClass());
        }
        folder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(nodeFolder));
        FolderType linkFolder = this.kmlObjectFactory.createFolderType();
        linkFolder.setName("Links");
        for (Link link : this.network.getLinks().values()) {
            AbstractFeatureType abstractFeature = this.networkFeatureFactory.createLinkFeature(link, networkLinkStyle);
            if (abstractFeature.getClass().equals(PlacemarkType.class)) {
                linkFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark((PlacemarkType)abstractFeature));
                continue;
            }
            if (abstractFeature.getClass().equals(FolderType.class)) {
                linkFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder((FolderType)abstractFeature));
                continue;
            }
            log.warn("Not yet implemented: Adding node KML features of type " + abstractFeature.getClass());
        }
        folder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(linkFolder));
        return folder;
    }
}

