/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.network.io.NetworkReaderMatsimV1;
import org.matsim.core.network.io.NetworkReaderMatsimV2;
import org.matsim.core.scenario.ProjectionUtils;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MatsimNetworkReader
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(MatsimNetworkReader.class);
    private static final String NETWORK_V1 = "network_v1.dtd";
    private static final String NETWORK_V2 = "network_v2.dtd";
    private MatsimXmlParser delegate = null;
    private final String inputCRS;
    private final String targetCRS;
    private final Network network;
    private Map<Class<?>, AttributeConverter<?>> converters = new HashMap();

    public MatsimNetworkReader(Network network) {
        this(null, network);
    }

    public MatsimNetworkReader(String targetCRS, Network network) {
        this(null, targetCRS, network);
    }

    public MatsimNetworkReader(String inputCRS, String targetCRS, Network network) {
        this.inputCRS = inputCRS;
        this.targetCRS = targetCRS;
        this.network = network;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        this.delegate.startTag(name, atts, context);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        this.delegate.endTag(name, content, context);
    }

    @Override
    public void endDocument() {
        try {
            this.delegate.endDocument();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        if (this.targetCRS != null) {
            ProjectionUtils.putCRS(this.network, this.targetCRS);
        }
    }

    @Override
    protected void setDoctype(String doctype) {
        super.setDoctype(doctype);
        switch (doctype) {
            case "network_v1.dtd": {
                this.delegate = new NetworkReaderMatsimV1(this.inputCRS != null ? TransformationFactory.getCoordinateTransformation(this.inputCRS, this.targetCRS) : new IdentityTransformation(), this.network);
                log.info("using network_v1-reader.");
                break;
            }
            case "network_v2.dtd": {
                this.delegate = new NetworkReaderMatsimV2(this.inputCRS, this.targetCRS, this.network);
                ((NetworkReaderMatsimV2)this.delegate).putAttributeConverters(this.converters);
                log.info("using network_v2-reader.");
                break;
            }
            default: {
                throw new IllegalArgumentException("Doctype \"" + doctype + "\" not known.");
            }
        }
    }

    public void putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        this.converters.put(clazz, converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> attributeConverters) {
        this.converters.putAll(attributeConverters);
    }
}

