/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Time;
import org.xml.sax.Attributes;

public final class NetworkChangeEventsParser
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(NetworkChangeEventsParser.class);
    static final String NETWORK_CHANGE_EVENTS_TAG = "networkChangeEvents";
    static final String NETWORK_CHANGE_EVENT_TAG = "networkChangeEvent";
    static final String START_TIME_TAG = "startTime";
    static final String LINK_TAG = "link";
    static final String REF_ID_TAG = "refId";
    static final String FLOW_CAPACITY_TAG = "flowCapacity";
    static final String FREESPEED_TAG = "freespeed";
    static final String LANES_TAG = "lanes";
    static final String CHANGE_TYPE_TAG = "type";
    static final String VALUE_TAG = "value";
    private final Network network;
    private NetworkChangeEvent currentEvent;
    private final List<NetworkChangeEvent> events;
    static final String ABSOLUTE_VALUE = "absolute";
    static final String FACTOR_VALUE = "scaleFactor";
    static final String OFFSET_VALUE = "offset";

    public NetworkChangeEventsParser(Network network, List<NetworkChangeEvent> events) {
        this.network = network;
        this.events = events;
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (name.equalsIgnoreCase(NETWORK_CHANGE_EVENT_TAG)) {
            this.events.add(this.currentEvent);
            this.currentEvent = null;
        }
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (name.equalsIgnoreCase(NETWORK_CHANGE_EVENT_TAG)) {
            String value = atts.getValue(START_TIME_TAG);
            if (value != null) {
                this.currentEvent = new NetworkChangeEvent(Time.parseTime(value));
            } else {
                this.currentEvent = null;
                log.warn("A start time must be defined!");
            }
        } else if (name.equalsIgnoreCase(LINK_TAG) && this.currentEvent != null) {
            String value = atts.getValue(REF_ID_TAG);
            if (value != null) {
                Link link = this.network.getLinks().get(Id.create(value, Link.class));
                if (link != null) {
                    this.currentEvent.addLink(link);
                } else {
                    log.warn(String.format("Link %1$s not found!", value));
                }
            }
        } else if (name.equalsIgnoreCase(FLOW_CAPACITY_TAG) && this.currentEvent != null) {
            this.currentEvent.setFlowCapacityChange(NetworkChangeEventsParser.newNetworkChangeType(atts.getValue(CHANGE_TYPE_TAG), atts.getValue(VALUE_TAG)));
        } else if (name.equalsIgnoreCase(FREESPEED_TAG) && this.currentEvent != null) {
            this.currentEvent.setFreespeedChange(NetworkChangeEventsParser.newNetworkChangeType(atts.getValue(CHANGE_TYPE_TAG), atts.getValue(VALUE_TAG)));
        } else if (name.equalsIgnoreCase(LANES_TAG) && this.currentEvent != null) {
            this.currentEvent.setLanesChange(NetworkChangeEventsParser.newNetworkChangeType(atts.getValue(CHANGE_TYPE_TAG), atts.getValue(VALUE_TAG)));
        }
    }

    private static NetworkChangeEvent.ChangeValue newNetworkChangeType(String typeStr, String valueStr) {
        if (typeStr != null && valueStr != null) {
            double value = Double.parseDouble(valueStr);
            if (typeStr.equalsIgnoreCase(ABSOLUTE_VALUE)) {
                return new NetworkChangeEvent.ChangeValue(NetworkChangeEvent.ChangeType.ABSOLUTE_IN_SI_UNITS, value);
            }
            if (typeStr.equalsIgnoreCase(FACTOR_VALUE)) {
                return new NetworkChangeEvent.ChangeValue(NetworkChangeEvent.ChangeType.FACTOR, value);
            }
            if (typeStr.equalsIgnoreCase(OFFSET_VALUE)) {
                return new NetworkChangeEvent.ChangeValue(NetworkChangeEvent.ChangeType.OFFSET_IN_SI_UNITS, value);
            }
            log.warn(String.format("The change type %1$s is not allowed. Alowed: %2$s %3$s %4$s", typeStr, ABSOLUTE_VALUE, FACTOR_VALUE, OFFSET_VALUE));
            return null;
        }
        log.warn("Change type and value must be specified!");
        return null;
    }
}

