/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.internal.MatsimSomeWriter;
import org.matsim.core.network.NetworkChangeEvent;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.misc.Time;

public final class NetworkChangeEventsWriter
extends MatsimXmlWriter
implements MatsimSomeWriter {
    private static final Logger log = Logger.getLogger(NetworkChangeEventsWriter.class);
    private static final String TAB = "\t";
    private static final String WHITESPACE = " ";
    private static final String OPEN_TAG_1 = "<";
    private static final String OPEN_TAG_2 = "</";
    private static final String CLOSE_TAG_1 = ">";
    private static final String CLOSE_TAG_2 = "/>";
    private static final String QUOTE = "\"";
    private static final String EQUALS = "=";
    private static final String DTD_LOCATION = "http://www.matsim.org/files/dtd";
    private static final String W3_URL = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSD_LOCATION = "http://www.matsim.org/files/dtd/networkChangeEvents.xsd";

    public void write(String file, Collection<NetworkChangeEvent> events) {
        try {
            this.openFile(file);
            super.writeXmlHead();
            this.writer.write(OPEN_TAG_1);
            this.writer.write("networkChangeEvents");
            this.writer.write(WHITESPACE);
            this.writer.write("xmlns");
            this.writer.write(EQUALS);
            this.writer.write(QUOTE);
            this.writer.write(DTD_LOCATION);
            this.writer.write(QUOTE);
            this.writer.write(WHITESPACE);
            this.writer.write("xmlns:xsi");
            this.writer.write(EQUALS);
            this.writer.write(QUOTE);
            this.writer.write(W3_URL);
            this.writer.write(QUOTE);
            this.writer.write(WHITESPACE);
            this.writer.write("xsi:schemaLocation");
            this.writer.write(EQUALS);
            this.writer.write(QUOTE);
            this.writer.write(DTD_LOCATION);
            this.writer.write(WHITESPACE);
            this.writer.write(XSD_LOCATION);
            this.writer.write(QUOTE);
            this.writer.write(CLOSE_TAG_1);
            this.writer.write("\n");
            this.writer.write("\n");
            for (NetworkChangeEvent event : events) {
                this.writeEvent(event);
                this.writer.write("\n");
                this.writer.write("\n");
            }
            this.writer.write(OPEN_TAG_2);
            this.writer.write("networkChangeEvents");
            this.writer.write(CLOSE_TAG_1);
            this.writer.write("\n");
            this.close();
        }
        catch (IOException e) {
            log.fatal("Error during writing network change events!", e);
        }
    }

    private void writeEvent(NetworkChangeEvent event) throws IOException {
        this.writer.write(TAB);
        this.writer.write(OPEN_TAG_1);
        this.writer.write("networkChangeEvent");
        this.writer.write(WHITESPACE);
        this.writer.write("startTime");
        this.writer.write(EQUALS);
        this.writer.write(QUOTE);
        this.writer.write(Time.writeTime(event.getStartTime()));
        this.writer.write(QUOTE);
        this.writer.write(CLOSE_TAG_1);
        this.writer.write("\n");
        if (event.getLinks().isEmpty()) {
            throw new IllegalArgumentException("NetworkChangeEvent must contain at least one link.");
        }
        for (Link link : event.getLinks()) {
            this.writer.write(TAB);
            this.writer.write(TAB);
            this.writer.write(OPEN_TAG_1);
            this.writer.write("link");
            this.writer.write(WHITESPACE);
            this.writer.write("refId");
            this.writer.write(EQUALS);
            this.writer.write(QUOTE);
            this.writer.write(link.getId().toString());
            this.writer.write(QUOTE);
            this.writer.write(CLOSE_TAG_2);
            this.writer.write("\n");
        }
        if (event.getFlowCapacityChange() != null) {
            this.writeChangeValue("flowCapacity", event.getFlowCapacityChange());
        }
        if (event.getFreespeedChange() != null) {
            this.writeChangeValue("freespeed", event.getFreespeedChange());
        }
        if (event.getLanesChange() != null) {
            this.writeChangeValue("lanes", event.getLanesChange());
        }
        this.writer.write(TAB);
        this.writer.write(OPEN_TAG_2);
        this.writer.write("networkChangeEvent");
        this.writer.write(CLOSE_TAG_1);
    }

    private void writeChangeValue(String attName, NetworkChangeEvent.ChangeValue value) throws IOException {
        this.writer.write(TAB);
        this.writer.write(TAB);
        this.writer.write(OPEN_TAG_1);
        this.writer.write(attName);
        this.writer.write(WHITESPACE);
        this.writer.write("type");
        this.writer.write(EQUALS);
        this.writer.write(QUOTE);
        switch (value.getType()) {
            case ABSOLUTE_IN_SI_UNITS: {
                this.writer.write("absolute");
                break;
            }
            case FACTOR: {
                this.writer.write("scaleFactor");
                break;
            }
            case OFFSET_IN_SI_UNITS: {
                this.writer.write("offset");
                break;
            }
            default: {
                throw new RuntimeException("missing ChangeType");
            }
        }
        this.writer.write(QUOTE);
        this.writer.write(WHITESPACE);
        this.writer.write("value");
        this.writer.write(EQUALS);
        this.writer.write(QUOTE);
        this.writer.write(String.valueOf(value.getValue()));
        this.writer.write(QUOTE);
        this.writer.write(CLOSE_TAG_2);
        this.writer.write("\n");
    }
}

