/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.scenario.ProjectionUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.StringUtils;
import org.matsim.core.utils.misc.Time;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.attributable.Attributes;
import org.matsim.utils.objectattributes.attributable.AttributesXmlReaderDelegate;

final class NetworkReaderMatsimV2
extends MatsimXmlParser {
    private static final String NETWORK = "network";
    private static final String LINKS = "links";
    private static final String NODE = "node";
    private static final String LINK = "link";
    private final Network network;
    private final AttributesXmlReaderDelegate attributesDelegate = new AttributesXmlReaderDelegate();
    private Attributes currentAttributes = null;
    private final String externalInputCRS;
    private final String targetCRS;
    private CoordinateTransformation coordinateTransformation = new IdentityTransformation();
    private static final Logger log = Logger.getLogger(NetworkReaderMatsimV2.class);

    NetworkReaderMatsimV2(String inputCRS, String targetCRS, Network network) {
        this.externalInputCRS = inputCRS;
        this.targetCRS = targetCRS;
        if (this.externalInputCRS != null && targetCRS != null) {
            this.coordinateTransformation = TransformationFactory.getCoordinateTransformation(this.externalInputCRS, targetCRS);
            ProjectionUtils.putCRS(network, targetCRS);
        }
        this.network = network;
    }

    @Override
    public void startTag(String name, org.xml.sax.Attributes atts, Stack<String> context) {
        switch (name) {
            case "node": {
                this.startNode(atts);
                break;
            }
            case "link": {
                this.startLink(atts);
                break;
            }
            case "network": {
                this.startNetwork(atts);
                break;
            }
            case "links": {
                this.startLinks(atts);
                break;
            }
            case "attributes": 
            case "attribute": {
                this.attributesDelegate.startTag(name, atts, context, this.currentAttributes);
            }
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        switch (name) {
            case "attributes": {
                String inputCRS;
                if (context.peek().equals(NETWORK) && (inputCRS = (String)this.network.getAttributes().getAttribute("coordinateReferenceSystem")) != null && this.targetCRS != null) {
                    if (this.externalInputCRS != null) {
                        log.warn("coordinate transformation defined both in config and in input file: setting from input file will be used");
                    }
                    this.coordinateTransformation = TransformationFactory.getCoordinateTransformation(inputCRS, this.targetCRS);
                    ProjectionUtils.putCRS(this.network, this.targetCRS);
                }
            }
            case "attribute": {
                this.attributesDelegate.endTag(name, content, context);
            }
        }
    }

    private void startNetwork(org.xml.sax.Attributes atts) {
        if (atts.getValue("type") != null) {
            log.info("Attribute 'type' is deprecated. There's always only ONE network, where the links and nodes define, which transportation mode is allowed to use it (for the future)");
        }
        this.network.setName(atts.getValue("name"));
        if (atts.getValue("capDivider") != null) {
            log.warn("capDivider defined. it will be used but should be gone eventually. -- This is a weird comment, since the matsim public api tells to put this into the network rather than into the ``links''.  kai, jun'11");
            String capperiod = atts.getValue("capDivider") + ":00:00";
            this.network.setCapacityPeriod(Time.parseTime(capperiod));
        }
        this.currentAttributes = this.network.getAttributes();
    }

    private void startLinks(org.xml.sax.Attributes atts) {
        double capacityPeriod = 3600.0;
        String capperiod = atts.getValue("capperiod");
        if (capperiod != null) {
            capacityPeriod = Time.parseTime(capperiod);
        } else {
            log.warn("capperiod was not defined. Using default value of " + Time.writeTime(capacityPeriod) + ".");
        }
        this.network.setCapacityPeriod(capacityPeriod);
        String effectivecellsize = atts.getValue("effectivecellsize");
        if (effectivecellsize == null) {
            this.network.setEffectiveCellSize(7.5);
        } else {
            this.network.setEffectiveCellSize(Double.parseDouble(effectivecellsize));
        }
        String effectivelanewidth = atts.getValue("effectivelanewidth");
        if (effectivelanewidth == null) {
            this.network.setEffectiveLaneWidth(3.75);
        } else {
            this.network.setEffectiveLaneWidth(Double.parseDouble(effectivelanewidth));
        }
        if (atts.getValue("capPeriod") != null || atts.getValue("capDivider") != null || atts.getValue("capdivider") != null) {
            log.warn("Found capPeriod, capDivider and/or capdivider in the links element.  They will be ignored, since they should be set in the network element. -- This is a weird warning, since setting them in the network element also produces a warning.");
            log.warn("At this point, it seems that, in network.xml, one sets capperiod in the `links' section, but in the matsim api, the corresponding entry belongs into the `network' object. kai, jun'11");
        }
    }

    private void startNode(org.xml.sax.Attributes atts) {
        Node node = this.network.getFactory().createNode(Id.create(atts.getValue("id"), Node.class), this.parseCoord(atts));
        this.network.addNode(node);
        NetworkUtils.setType(node, atts.getValue("type"));
        if (atts.getValue("origid") != null) {
            NetworkUtils.setOrigId(node, atts.getValue("origid"));
        }
        this.currentAttributes = node.getAttributes();
    }

    private Coord parseCoord(org.xml.sax.Attributes atts) {
        Coord c = atts.getValue("z") == null ? new Coord(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y"))) : new Coord(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("z")));
        return this.coordinateTransformation.transform(c);
    }

    private void startLink(org.xml.sax.Attributes atts) {
        String fromNodeStr = atts.getValue("from");
        Node fromNode = this.network.getNodes().get(Id.create(fromNodeStr, Node.class));
        if (fromNode == null) {
            throw new RuntimeException("node id given by link cannot be dereferenced; node label=" + fromNodeStr);
        }
        String toNodeStr = atts.getValue("to");
        Node toNode = this.network.getNodes().get(Id.create(toNodeStr, Node.class));
        if (toNode == null) {
            throw new RuntimeException("node id given by link cannot be dereferenced; node label=" + toNodeStr);
        }
        Link l = this.network.getFactory().createLink(Id.create(atts.getValue("id"), Link.class), fromNode, toNode);
        l.setLength(Double.parseDouble(atts.getValue("length")));
        l.setFreespeed(Double.parseDouble(atts.getValue("freespeed")));
        l.setCapacity(Double.parseDouble(atts.getValue("capacity")));
        l.setNumberOfLanes(Double.parseDouble(atts.getValue("permlanes")));
        this.network.addLink(l);
        String value = atts.getValue("origid");
        if (value != null) {
            NetworkUtils.setOrigId(l, value);
        }
        if ((value = atts.getValue("type")) != null) {
            NetworkUtils.setType(l, value);
        }
        if (atts.getValue("modes") != null) {
            String[] strModes = StringUtils.explode(atts.getValue("modes"), ',');
            if (strModes.length == 1 && strModes[0].isEmpty()) {
                l.setAllowedModes(new HashSet<String>());
            } else {
                HashSet<String> modes = new HashSet<String>();
                for (String strMode : strModes) {
                    modes.add(strMode.trim().intern());
                }
                l.setAllowedModes(modes);
            }
        }
        this.currentAttributes = l.getAttributes();
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributesDelegate.putAttributeConverters(converters);
    }
}

