/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.MatsimSomeReader;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.gis.ShapeFileReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;

public final class NetworkReaderTeleatlas
implements MatsimSomeReader {
    private static final Logger log = Logger.getLogger(NetworkReaderTeleatlas.class);
    private final Network network;
    private final String jcShpFileName;
    private final String nwShpFileName;
    public boolean ignoreFrcType8 = false;
    public boolean ignoreFrcType7onewayN = false;
    public int maxFrcTypeForDoubleLaneLink = 3;
    public int minSpeedForNormalCapacity = 40;
    private static final String NODE_ID_NAME = "ID";
    private static final String NODE_FEATTYP_NAME = "FEATTYP";
    private static final String NODE_JNCTTYP_NAME = "JNCTTYP";
    private static final String LINK_ID_NAME = "ID";
    private static final String LINK_FEATTYP_NAME = "FEATTYP";
    private static final String LINK_FERRYTYP_NAME = "FT";
    private static final String LINK_FJNCTID_NAME = "F_JNCTID";
    private static final String LINK_TJNCTID_NAME = "T_JNCTID";
    private static final String LINK_LENGTH_NAME = "METERS";
    private static final String LINK_FRCTYP_NAME = "FRC";
    private static final String LINK_ONEWAY_NAME = "ONEWAY";
    private static final String LINK_SPEED_NAME = "KPH";
    private static final String LINK_LANES_NAME = "LANES";

    public NetworkReaderTeleatlas(Network network, String jcShpFileName, String nwShpFileName) {
        this.network = network;
        this.jcShpFileName = jcShpFileName;
        this.nwShpFileName = nwShpFileName;
    }

    public void read() throws IOException {
        log.info("reading nodes from Junction Shape file '" + this.jcShpFileName + "'...");
        this.readNodesFromJCshp();
        log.info("done.");
        log.info("reading links from Network Shape file '" + this.nwShpFileName + "'...");
        this.readLinksFromNWshp();
        log.info("done.");
        this.network.setName("teleatlas");
    }

    private void readNodesFromJCshp() throws IOException {
        int nCnt = this.network.getNodes().size();
        SimpleFeatureSource fs = ShapeFileReader.readDataFile(this.jcShpFileName);
        SimpleFeatureIterator fIt = fs.getFeatures().features();
        while (fIt.hasNext()) {
            SimpleFeature f = (SimpleFeature)fIt.next();
            BoundingBox bb = f.getBounds();
            Coord c = new Coord((bb.getMinX() + bb.getMaxX()) / 2.0, (bb.getMinY() + bb.getMaxY()) / 2.0);
            Object id = f.getAttribute("ID");
            int feattyp = Integer.parseInt(f.getAttribute("FEATTYP").toString());
            if (feattyp != 4120 && feattyp != 4220) {
                throw new IllegalArgumentException("ID=" + id + ": " + "FEATTYP" + "=" + feattyp + " not allowed.");
            }
            int jncttyp = Integer.parseInt(f.getAttribute(NODE_JNCTTYP_NAME).toString());
            if (jncttyp < 0 || jncttyp == 1 || jncttyp > 6) {
                throw new IllegalArgumentException("ID=" + id + ": " + NODE_JNCTTYP_NAME + "=" + jncttyp + " not allowed.");
            }
            if (id == null) {
                throw new IllegalArgumentException("In " + this.jcShpFileName + ": There is at least one feature that does not have an ID set.");
            }
            String type = feattyp + "-" + jncttyp;
            Node n = this.network.getFactory().createNode(Id.create(id.toString(), Node.class), c);
            String type1 = type;
            Node r = n;
            NetworkUtils.setType(r, type1);
            this.network.addNode(n);
        }
        fIt.close();
        nCnt = this.network.getNodes().size() - nCnt;
        log.info("  " + nCnt + " nodes added to the network.");
    }

    private void readLinksFromNWshp() throws IOException {
        int lCnt = this.network.getLinks().size();
        int ignoreCnt = 0;
        SimpleFeatureSource fs = ShapeFileReader.readDataFile(this.nwShpFileName);
        SimpleFeatureIterator fIt = fs.getFeatures().features();
        while (fIt.hasNext()) {
            Link l;
            SimpleFeature f = (SimpleFeature)fIt.next();
            boolean ignore = false;
            Object id = f.getAttribute("ID");
            int featTyp = Integer.parseInt(f.getAttribute("FEATTYP").toString());
            if (featTyp != 4110 && featTyp != 4130 && featTyp != 4165) {
                throw new IllegalArgumentException("ID=" + id + ": " + "FEATTYP" + "=" + featTyp + " not allowed.");
            }
            int ferryType = Integer.parseInt(f.getAttribute(LINK_FERRYTYP_NAME).toString());
            if (ferryType < 0 || ferryType > 2) {
                throw new IllegalArgumentException("ID=" + id + ": " + LINK_FERRYTYP_NAME + "=" + ferryType + " not allowed.");
            }
            Id<Node> fromJunctionId = Id.create(f.getAttribute(LINK_FJNCTID_NAME).toString(), Node.class);
            Id<Node> toJunctionId = Id.create(f.getAttribute(LINK_TJNCTID_NAME).toString(), Node.class);
            double length = Double.parseDouble(f.getAttribute(LINK_LENGTH_NAME).toString());
            int linksType = Integer.parseInt(f.getAttribute(LINK_FRCTYP_NAME).toString());
            if (linksType < -1 || linksType > 8) {
                throw new IllegalArgumentException("ID=" + id + ": " + LINK_FRCTYP_NAME + "=" + linksType + " not allowed.");
            }
            String oneway = f.getAttribute(LINK_ONEWAY_NAME).toString();
            if (!(oneway.equals(" ") || oneway.equals(LINK_FERRYTYP_NAME) || oneway.equals("TF") || oneway.equals("N"))) {
                throw new IllegalArgumentException("ID=" + id + ": " + LINK_ONEWAY_NAME + "=" + oneway + " not allowed.");
            }
            double speed = Double.parseDouble(f.getAttribute(LINK_SPEED_NAME).toString());
            double lanes = Double.parseDouble(f.getAttribute(LINK_LANES_NAME).toString());
            Node fNode = this.network.getNodes().get(fromJunctionId);
            Node tNode = this.network.getNodes().get(toJunctionId);
            if (fNode == null || tNode == null) {
                log.warn("  linkId=" + id.toString() + ": at least one of the two junctions do not exist. Ignoring and proceeding anyway...");
                ignore = true;
            }
            if (featTyp != 4110 && featTyp != 4130) {
                log.trace("  linkId=" + id.toString() + ": ignoring " + "FEATTYP" + "=" + featTyp + ".");
                ignore = true;
            }
            if (linksType < 0) {
                log.trace("  linkId=" + id.toString() + ": ignoring " + LINK_FRCTYP_NAME + "=" + linksType + ".");
                ignore = true;
            }
            if (this.ignoreFrcType8 && 7 < linksType) {
                log.trace("  linkId=" + id.toString() + ": ignoring " + LINK_FRCTYP_NAME + "=" + linksType + ".");
                ignore = true;
            }
            if (this.ignoreFrcType7onewayN && linksType == 7 && oneway.equals("N")) {
                log.trace("  linkId=" + id.toString() + ": ignoring " + LINK_FRCTYP_NAME + "=" + linksType + " with " + LINK_ONEWAY_NAME + "=" + oneway);
                ignore = true;
            }
            if (lanes < 1.0) {
                lanes = linksType <= this.maxFrcTypeForDoubleLaneLink ? 2.0 : 1.0;
            }
            double cap = speed < (double)this.minSpeedForNormalCapacity ? lanes * 1000.0 : lanes * 2000.0;
            if (ignore) {
                ++ignoreCnt;
                continue;
            }
            if (oneway.equals(" ") || oneway.equals("N")) {
                l = this.network.getFactory().createLink(Id.create(id.toString() + LINK_FERRYTYP_NAME, Link.class), fNode, tNode);
                l.setLength(length);
                l.setFreespeed(speed / 3.6);
                l.setCapacity(cap);
                l.setNumberOfLanes(lanes);
                NetworkUtils.setOrigId(l, id.toString());
                NetworkUtils.setType(l, linksType + "-" + featTyp + "-" + ferryType);
                l = this.network.getFactory().createLink(Id.create(id.toString() + "TF", Link.class), tNode, fNode);
                l.setLength(length);
                l.setFreespeed(speed / 3.6);
                l.setCapacity(cap);
                l.setNumberOfLanes(lanes);
                NetworkUtils.setOrigId(l, id.toString());
                NetworkUtils.setType(l, linksType + "-" + featTyp + "-" + ferryType);
                continue;
            }
            if (oneway.equals(LINK_FERRYTYP_NAME)) {
                l = this.network.getFactory().createLink(Id.create(id.toString() + oneway, Link.class), fNode, tNode);
                l.setLength(length);
                l.setFreespeed(speed / 3.6);
                l.setCapacity(cap);
                l.setNumberOfLanes(lanes);
                NetworkUtils.setOrigId(l, id.toString());
                NetworkUtils.setType(l, linksType + "-" + featTyp + "-" + ferryType);
                continue;
            }
            if (oneway.equals("TF")) {
                l = this.network.getFactory().createLink(Id.create(id.toString() + oneway, Link.class), tNode, fNode);
                l.setLength(length);
                l.setFreespeed(speed / 3.6);
                l.setCapacity(cap);
                l.setNumberOfLanes(lanes);
                NetworkUtils.setOrigId(l, id.toString());
                NetworkUtils.setType(l, linksType + "-" + featTyp + "-" + ferryType);
                continue;
            }
            throw new IllegalArgumentException("linkId=" + id.toString() + ": " + LINK_ONEWAY_NAME + "=" + oneway + " not known!");
        }
        fIt.close();
        this.network.setCapacityPeriod(3600.0);
        lCnt = this.network.getLinks().size() - lCnt;
        log.info("  " + lCnt + " links added to the network layer.");
        log.info("  " + ignoreCnt + " links ignored from the input shape file.");
    }

    public final void printInfo(String prefix) {
        System.out.println(prefix + "configuration of " + this.getClass().getName() + ":");
        System.out.println(prefix + "  MATSim network:");
        System.out.println(prefix + "    ignoreFrcType8:              " + this.ignoreFrcType8);
        System.out.println(prefix + "    ignoreFrcType7onewayN:       " + this.ignoreFrcType7onewayN);
        System.out.println(prefix + "    maxFrcTypeForDoubleLaneLink: " + this.maxFrcTypeForDoubleLaneLink);
        System.out.println(prefix + "    minSpeedForNormalCapacity:   " + this.minSpeedForNormalCapacity);
        System.out.println(prefix + "  junction shape:");
        System.out.println(prefix + "    jcShpFileName:      " + this.jcShpFileName);
        System.out.println(prefix + "    NODE_ID_NAME:       " + "ID");
        System.out.println(prefix + "    NODE_FEATTYP_NAME:  " + "FEATTYP");
        System.out.println(prefix + "    NODE_JNCTTYP_NAME:  " + NODE_JNCTTYP_NAME);
        System.out.println(prefix + "  network shape:");
        System.out.println(prefix + "    nwShpFileName:      " + this.nwShpFileName);
        System.out.println(prefix + "    LINK_ID_NAME:       " + "ID");
        System.out.println(prefix + "    LINK_FEATTYP_NAME:  " + "FEATTYP");
        System.out.println(prefix + "    LINK_FERRYTYP_NAME: " + LINK_FERRYTYP_NAME);
        System.out.println(prefix + "    LINK_FJNCTID_NAME:  " + LINK_FJNCTID_NAME);
        System.out.println(prefix + "    LINK_TJNCTID_NAME:  " + LINK_TJNCTID_NAME);
        System.out.println(prefix + "    LINK_LENGTH_NAME:   " + LINK_LENGTH_NAME);
        System.out.println(prefix + "    LINK_FRCTYP_NAME:   " + LINK_FRCTYP_NAME);
        System.out.println(prefix + "    LINK_ONEWAY_NAME:   " + LINK_ONEWAY_NAME);
        System.out.println(prefix + "    LINK_SPEED_NAME:    " + LINK_SPEED_NAME);
        System.out.println(prefix + "    LINK_LANES_NAME:    " + LINK_LANES_NAME);
        System.out.println(prefix + "done.");
    }
}

