/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Identifiable;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.io.NetworkWriterHandler;
import org.matsim.core.network.io.NetworkWriterHandlerImplV1;
import org.matsim.core.network.io.NetworkWriterHandlerImplV2;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.utils.objectattributes.AttributeConverter;

public final class NetworkWriter
extends MatsimXmlWriter
implements MatsimWriter {
    private static final Logger log = Logger.getLogger(NetworkWriter.class);
    private final Network network;
    private final CoordinateTransformation transformation;
    private final Map<Class<?>, AttributeConverter<?>> converters = new HashMap();

    public NetworkWriter(Network network) {
        this(new IdentityTransformation(), network);
    }

    public NetworkWriter(CoordinateTransformation transformation, Network network) {
        this.transformation = transformation;
        this.network = network;
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.converters.putAll(converters);
    }

    public void putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        this.converters.put(clazz, converter);
    }

    @Override
    public void write(String filename) {
        log.info("Writing network to file: " + filename + "...");
        this.writeFileV2(filename);
        log.info("done.");
    }

    public void writeFileV1(String filename) {
        String dtd = "http://www.matsim.org/files/dtd/network_v1.dtd";
        NetworkWriterHandlerImplV1 handler = new NetworkWriterHandlerImplV1(this.transformation);
        this.writeFile(dtd, handler, filename);
    }

    public void writeFileV2(String filename) {
        String dtd = "http://www.matsim.org/files/dtd/network_v2.dtd";
        NetworkWriterHandlerImplV2 handler = new NetworkWriterHandlerImplV2(this.transformation);
        handler.putAttributeConverters(this.converters);
        this.writeFile(dtd, handler, filename);
    }

    public void writeStreamV2(OutputStream stream) {
        String dtd = "http://www.matsim.org/files/dtd/network_v2.dtd";
        NetworkWriterHandlerImplV2 handler = new NetworkWriterHandlerImplV2(this.transformation);
        handler.putAttributeConverters(this.converters);
        this.writeStream(dtd, handler, stream);
    }

    private void writeFile(String dtd, NetworkWriterHandler handler, String filename) {
        try {
            this.openFile(filename);
            this.writeContent(dtd, handler);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeStream(String dtd, NetworkWriterHandler handler, OutputStream stream) {
        try {
            this.openOutputStream(stream);
            this.writeContent(dtd, handler);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeContent(String dtd, NetworkWriterHandler handler) throws IOException {
        this.writeXmlHead();
        this.writeDoctype("network", dtd);
        handler.startNetwork(this.network, this.writer);
        handler.writeSeparator(this.writer);
        handler.startNodes(this.network, this.writer);
        for (Node node : NetworkUtils.getSortedNodes(this.network)) {
            handler.startNode(node, this.writer);
            handler.endNode(this.writer);
        }
        handler.endNodes(this.writer);
        handler.writeSeparator(this.writer);
        handler.startLinks(this.network, this.writer);
        for (Identifiable<Node> identifiable : NetworkUtils.getSortedLinks(this.network)) {
            handler.startLink((Link)identifiable, this.writer);
            handler.endLink(this.writer);
        }
        handler.endLinks(this.writer);
        handler.writeSeparator(this.writer);
        handler.endNetwork(this.writer);
        this.writer.close();
    }
}

